/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class HrefParser {
    private Reader reader;

    public HrefParser(Reader reader) {
        this.reader = reader;
    }

    public String[] parse() throws IOException {
        final ArrayList list = new ArrayList(32);
        this.parse(new Handler(){

            @Override
            public void onValueSeen(String value) {
                list.add(value);
            }
        });
        return list.toArray(new String[0]);
    }

    public void parse(Handler handler) throws IOException {
        int i;
        M m = M.TEXT;
        StringBuilder buffer = new StringBuilder(1024);
        while ((i = this.reader.read()) != -1) {
            char c = (char)i;
            buffer.append(Character.isWhitespace(c) ? (char)' ' : (char)c);
            if (m == M.TEXT) {
                if (this.endsWith(buffer, "<!--")) {
                    buffer.setLength(0);
                    m = M.COMMENT;
                    continue;
                }
                if (this.endsWith(buffer, " href")) {
                    buffer.setLength(0);
                    m = M.HREF_SEEN;
                    continue;
                }
                if (c != '>') continue;
                buffer.setLength(0);
                continue;
            }
            if (m == M.COMMENT) {
                if (!this.endsWith(buffer, "-->")) continue;
                buffer.setLength(0);
                m = M.TEXT;
                continue;
            }
            if (m == M.HREF_SEEN) {
                if (c == '=') {
                    m = M.HREF_EQ_SEEN;
                } else if (!Character.isWhitespace(c)) {
                    m = M.TEXT;
                }
                buffer.setLength(0);
                continue;
            }
            if (m == M.HREF_EQ_SEEN) {
                if (c == '\"') {
                    m = M.HREF_VALUE;
                    continue;
                }
                if (c == '\'') {
                    m = M.HREF_VALUE;
                    continue;
                }
                if (!Character.isWhitespace(c)) {
                    m = M.HREF_VALUE;
                    continue;
                }
                buffer.setLength(0);
                continue;
            }
            if (m == M.HREF_VALUE) {
                if (this.startsWith(buffer, "\"")) {
                    if (c != '\"') continue;
                    handler.onValueSeen(buffer.substring(1, buffer.length() - 1));
                    buffer.setLength(0);
                    m = M.TEXT;
                    continue;
                }
                if (this.startsWith(buffer, "'")) {
                    if (c != '\'') continue;
                    handler.onValueSeen(buffer.substring(1, buffer.length() - 1));
                    buffer.setLength(0);
                    m = M.TEXT;
                    continue;
                }
                if (!Character.isWhitespace(c) && c != '>' && c != '/') continue;
                handler.onValueSeen(buffer.substring(0, buffer.length() - 1));
                buffer.setLength(0);
                m = M.TEXT;
                continue;
            }
            throw new IllegalStateException();
        }
    }

    boolean startsWith(StringBuilder buffer, String token) {
        int n = token.length();
        if (buffer.length() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char tc = token.charAt(i);
            char bc = buffer.charAt(i);
            if (Character.toUpperCase(tc) == Character.toUpperCase(bc)) continue;
            return false;
        }
        return true;
    }

    boolean endsWith(StringBuilder buffer, String token) {
        int n = token.length();
        if (buffer.length() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char tc = token.charAt(i);
            char bc = buffer.charAt(buffer.length() - n + i);
            if (Character.toUpperCase(tc) == Character.toUpperCase(bc)) continue;
            return false;
        }
        return true;
    }

    public static interface Handler {
        public void onValueSeen(String var1);
    }

    private static enum M {
        TEXT,
        COMMENT,
        HREF_SEEN,
        HREF_EQ_SEEN,
        HREF_VALUE;

    }
}

