/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.ResourceLocator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultResourceLocator
extends ResourceLocator {
    public static final Logger LOG = Logger.getLogger(DefaultResourceLocator.class.getName());

    @Override
    public Collection<Path> locateResources(String name) {
        HashSet<Path> resourcesSet = new HashSet<Path>();
        try {
            Enumeration<URL> resources = this.getResourceClassLoader().getResources(name);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                URI uri = this.toUri(resource);
                if (uri == null) continue;
                resourcesSet.add(this.toPath(uri));
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, String.format("Failed to retrieve resources for name '%s'", name), e);
        }
        return resourcesSet;
    }

    protected ClassLoader getResourceClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected Path toPath(URI uri) throws IOException {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException exp) {
            FileSystems.newFileSystem(uri, Collections.emptyMap());
            return Paths.get(uri);
        }
    }

    private URI toUri(URL resource) {
        try {
            return resource.toURI();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, String.format("Ignoring malformed resource URI '%s'", resource), e);
            return null;
        }
    }
}

