/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.graphbuilder.rcp.dialogs.GraphBuilderDialog;
import org.esa.snap.graphbuilder.rcp.wizards.WizardDialog;
import org.esa.snap.rcp.util.Dialogs;

public abstract class WizardPanel
extends JPanel {
    private WizardDialog owner;
    private final String panelTitle;
    protected static final File wizardGraphPath = new File(GraphBuilderDialog.getInternalGraphFolder(), "wizards");
    protected boolean finishing = false;
    private File[] targetFileList = new File[0];

    protected WizardPanel(String name) {
        super(new BorderLayout(1, 1));
        this.panelTitle = name;
        this.setPreferredSize(new Dimension(500, 500));
    }

    public String getPanelTitle() {
        return this.panelTitle;
    }

    public WizardDialog getOwner() {
        return this.owner;
    }

    public void setOwner(WizardDialog owner) {
        this.owner = owner;
    }

    public void finish() {
    }

    protected static void showErrorMsg(String msg) {
        Dialogs.showError((String)"Oops!", (String)msg);
    }

    protected static JPanel createTextPanel(String title, String text) {
        JPanel textPanel = new JPanel(new BorderLayout(2, 2));
        textPanel.setBorder(BorderFactory.createTitledBorder(title));
        JTextArea textPane = new JTextArea();
        textPane.setBackground(textPanel.getBackground());
        textPane.setText(text);
        textPanel.add((Component)textPane, "North");
        return textPanel;
    }

    public abstract boolean validateInput();

    public abstract void returnFromLaterStep();

    public abstract boolean canRedisplayNextPanel();

    public abstract boolean hasNextPanel();

    public abstract boolean canFinish();

    public abstract WizardPanel getNextPanel();

    public File[] getTargetFileList() {
        return this.targetFileList;
    }

    static /* synthetic */ File[] access$002(WizardPanel x0, File[] x1) {
        x0.targetFileList = x1;
        return x1;
    }

    public class MyBatchProcessListener
    implements BatchGraphDialog.BatchProcessListener {
        @Override
        public void notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG msg, File[] inputFileList, File[] outputFileList) {
            if (msg.equals((Object)BatchGraphDialog.BatchProcessListener.BatchMSG.DONE)) {
                WizardPanel.access$002(WizardPanel.this, outputFileList);
                WizardPanel.this.getOwner().updateState();
            }
        }

        @Override
        public void notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG msg, String text) {
            if (msg.equals((Object)BatchGraphDialog.BatchProcessListener.BatchMSG.UPDATE)) {
                // empty if block
            }
        }
    }

    public class GraphProcessListener
    implements GraphBuilderDialog.ProcessingListener {
        @Override
        public void notifyMSG(GraphBuilderDialog.ProcessingListener.MSG msg, String text) {
            if (msg.equals((Object)GraphBuilderDialog.ProcessingListener.MSG.DONE)) {
                WizardPanel.this.getOwner().updateState();
                if (WizardPanel.this.finishing) {
                    WizardPanel.this.getOwner().dispose();
                }
            }
        }

        @Override
        public void notifyMSG(GraphBuilderDialog.ProcessingListener.MSG msg, File[] fileList) {
            if (msg.equals((Object)GraphBuilderDialog.ProcessingListener.MSG.DONE)) {
                WizardPanel.access$002(WizardPanel.this, fileList);
                WizardPanel.this.getOwner().updateState();
                if (WizardPanel.this.finishing) {
                    WizardPanel.this.getOwner().dispose();
                }
            }
        }
    }
}

