/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.wizards;

import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.wizards.WizardPanel;

public abstract class AbstractMapPanel
extends WizardPanel {
    protected final File[] productFileList;
    protected final File targetFolder;

    public AbstractMapPanel(File[] productFileList, File targetFolder) {
        super("Viewing the footprint");
        this.productFileList = productFileList;
        this.targetFolder = targetFolder;
        this.createPanel(productFileList);
    }

    @Override
    public void returnFromLaterStep() {
    }

    @Override
    public boolean canRedisplayNextPanel() {
        return false;
    }

    @Override
    public boolean hasNextPanel() {
        return true;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public abstract WizardPanel getNextPanel();

    @Override
    public boolean validateInput() {
        return true;
    }

    protected String getInstructions() {
        return "View the footprint of the input products on the world map\nUse the mouse wheel to zoom in and out. Hold and drag the right mouse button to pan\n";
    }

    private void createPanel(File[] productFileList) {
        JPanel textPanel = AbstractMapPanel.createTextPanel("Instructions", this.getInstructions());
        this.add((Component)textPanel, "North");
        WorldMapUI worldMapUI = new WorldMapUI();
        this.add((Component)worldMapUI.getWorlMapPane(), "Center");
        ProductEntry[] productEntryList = ProductEntry.createProductEntryList((File[])productFileList);
        GeoPos[][] geoBoundaries = new GeoPos[productEntryList.length][4];
        int i = 0;
        for (ProductEntry entry : productEntryList) {
            geoBoundaries[i++] = entry.getGeoBoundary();
        }
        worldMapUI.setAdditionalGeoBoundaries(geoBoundaries);
    }
}

