/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import com.bc.ceres.binding.dom.DomElement;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNodeList;

public class SubGraphHandler {
    private final Graph graph;
    private final GraphNodeList graphNodeList;
    private final GraphNode[] savedSubGraphList;
    private Map<GraphNode, GraphNode[]> subGraphNodesToRemoveMap = new HashMap<GraphNode, GraphNode[]>();

    public SubGraphHandler(Graph graph, GraphNodeList graphNodeList) throws GraphException {
        this.graph = graph;
        this.graphNodeList = graphNodeList;
        this.savedSubGraphList = this.replaceAllSubGraphs();
    }

    private GraphNode[] replaceAllSubGraphs() throws GraphException {
        SubGraphData[] dataList = this.findSubGraphs("SubGraph");
        ArrayList<GraphNode> savedList = new ArrayList<GraphNode>();
        for (SubGraphData data : dataList) {
            GraphNode sourceNode = this.graphNodeList.findGraphNode(data.nodeID);
            if (data.subGraph == null) continue;
            this.replaceSubGraph(sourceNode, data.subGraph);
            this.removeNode(sourceNode);
            savedList.add(sourceNode);
        }
        return savedList.toArray(new GraphNode[savedList.size()]);
    }

    private SubGraphData[] findSubGraphs(String opName) throws GraphException {
        try {
            ArrayList<SubGraphData> dataList = new ArrayList<SubGraphData>();
            for (Node n : this.graph.getNodes()) {
                DomElement[] params;
                if (!n.getOperatorName().equalsIgnoreCase(opName)) continue;
                SubGraphData data = new SubGraphData();
                data.nodeID = n.getId();
                DomElement config = n.getConfiguration();
                for (DomElement p : params = (DomElement[])config.getChildren()) {
                    if (!p.getName().equals("graphFile") || p.getValue() == null) continue;
                    data.subGraph = GraphIO.read((Reader)new FileReader(p.getValue()));
                    break;
                }
                dataList.add(data);
            }
            return dataList.toArray(new SubGraphData[dataList.size()]);
        }
        catch (Exception e) {
            throw new GraphException(e.getMessage(), (Throwable)e);
        }
    }

    public void restore() {
        for (GraphNode savedNode : this.savedSubGraphList) {
            GraphNode[] nodesToRemove;
            for (GraphNode n : nodesToRemove = this.subGraphNodesToRemoveMap.get(savedNode)) {
                GraphNode[] connectedNodes;
                for (GraphNode node : connectedNodes = this.graphNodeList.findConnectedNodes(n)) {
                    node.connectOperatorSource(savedNode.getID());
                    String name = node.getSourceName(n.getID());
                    node.setSourceName(name, savedNode.getNode().getId());
                }
                this.removeNode(n);
            }
            this.graphNodeList.add(savedNode);
            this.graph.addNode(savedNode.getNode());
        }
    }

    private void replaceSubGraph(GraphNode subGraphOpNode, Graph subGraph) {
        NodeSource[] sources;
        ArrayList<GraphNode> toRemove = new ArrayList<GraphNode>();
        Node[] nodes = subGraph.getNodes();
        Node firstNode = nodes[0];
        Node lastNode = nodes[nodes.length - 1];
        GraphNode[] connectedNodes = this.graphNodeList.findConnectedNodes(subGraphOpNode);
        for (NodeSource source : sources = subGraphOpNode.getNode().getSources()) {
            HashMap<String, Node> subGraphNodeMap = new HashMap<String, Node>();
            for (Node subNode : nodes) {
                Node newNode = new Node(source.getSourceNodeId() + subNode.getId(), subNode.getOperatorName());
                subGraphNodeMap.put(subNode.getId(), newNode);
                newNode.setConfiguration(subNode.getConfiguration());
                this.graph.addNode(newNode);
                GraphNode newGraphNode = new GraphNode(newNode);
                this.graphNodeList.add(newGraphNode);
                toRemove.add(newGraphNode);
                for (NodeSource nodeSource : subNode.getSources()) {
                    Node src = (Node)subGraphNodeMap.get(nodeSource.getSourceNodeId());
                    if (src == null) continue;
                    newGraphNode.connectOperatorSource(src.getId());
                }
                if (subNode == firstNode) {
                    newNode.addSource(source);
                    continue;
                }
                if (subNode != lastNode) continue;
                for (GraphNode graphNode : connectedNodes) {
                    graphNode.connectOperatorSource(newNode.getId());
                    String name = graphNode.getSourceName(subGraphOpNode.getID());
                    graphNode.setSourceName(name, newNode.getId());
                }
            }
        }
        this.subGraphNodesToRemoveMap.put(subGraphOpNode, toRemove.toArray(new GraphNode[toRemove.size()]));
    }

    private void removeNode(GraphNode node) {
        this.graphNodeList.remove(node);
        this.graph.removeNode(node.getID());
    }

    private static class SubGraphData {
        String nodeID = null;
        Graph subGraph = null;

        private SubGraphData() {
        }
    }
}

