/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.ReadOp;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Node;

public class GPFProcessor {
    private final Graph graph;
    private final GraphProcessor processor = new GraphProcessor();

    public GPFProcessor(File graphFile) throws GraphException, IOException {
        this(graphFile, null);
    }

    public GPFProcessor(File graphFile, Map<String, String> parameterMap) throws GraphException, IOException {
        this.graph = GPFProcessor.readGraph(new FileReader(graphFile), parameterMap);
    }

    public static Graph readGraph(Reader fileReader, Map<String, String> parameterMap) throws GraphException, IOException {
        Graph graph = null;
        try {
            graph = GraphIO.read((Reader)fileReader, parameterMap);
        }
        finally {
            fileReader.close();
        }
        return graph;
    }

    public void setIO(File srcFile, File tgtFile, String format) {
        String writeOperatorAlias;
        Node writerNode;
        String readOperatorAlias = OperatorSpi.getOperatorAlias(ReadOp.class);
        Node readerNode = GPFProcessor.findNode(this.graph, readOperatorAlias);
        if (readerNode != null) {
            DefaultDomElement param = new DefaultDomElement("parameters");
            param.createChild("file").setValue(srcFile.getAbsolutePath());
            readerNode.setConfiguration((DomElement)param);
        }
        if ((writerNode = GPFProcessor.findNode(this.graph, writeOperatorAlias = OperatorSpi.getOperatorAlias(WriteOp.class))) != null && tgtFile != null) {
            DomElement origParam = writerNode.getConfiguration();
            ((DomElement)origParam.getChild("file")).setValue(tgtFile.getAbsolutePath());
            if (format != null) {
                ((DomElement)origParam.getChild("formatName")).setValue(format);
            }
        }
    }

    public void executeGraph(ProgressMonitor pm) throws GraphException {
        this.processor.executeGraph(this.graph, pm);
    }

    private static Node findNode(Graph graph, String alias) {
        for (Node n : graph.getNodes()) {
            if (!n.getOperatorName().equals(alias)) continue;
            return n;
        }
        return null;
    }
}

