/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import java.io.File;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.support.BaseFileModel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTableModel;

public class FileModel
extends BaseFileModel
implements FileTableModel {
    @Override
    protected void setColumnData() {
        this.titles = new String[]{"File Name", "Type", "Acquisition", "Track", "Orbit"};
        this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
        this.widths = new int[]{75, 10, 20, 3, 5};
    }

    @Override
    protected BaseFileModel.TableData createFileStats(File file) {
        return new FileStats(file);
    }

    @Override
    protected BaseFileModel.TableData createFileStats(ProductEntry entry) {
        return new FileStats(entry);
    }

    private class FileStats
    extends BaseFileModel.TableData {
        FileStats(File file) {
            super(file);
        }

        FileStats(ProductEntry entry) {
            super(entry);
        }

        @Override
        protected void updateData() {
            if (this.file != null) {
                this.data[0] = this.file.getName();
            } else if (this.entry != null) {
                this.data[0] = this.entry.getName();
                this.data[1] = this.entry.getProductType();
                this.data[2] = this.entry.getFirstLineTime().format();
                MetadataElement meta = this.entry.getMetadata();
                if (meta != null) {
                    this.data[3] = String.valueOf(meta.getAttributeInt("REL_ORBIT", 0));
                    this.data[4] = String.valueOf(meta.getAttributeInt("ABS_ORBIT", 0));
                }
            }
        }

        @Override
        protected void updateData(Product product) {
            if (product != null) {
                this.data[0] = product.getName();
                this.data[1] = product.getProductType();
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
                if (absRoot != null) {
                    this.data[2] = OperatorUtils.getAcquisitionDate((MetadataElement)absRoot);
                    this.data[3] = String.valueOf(absRoot.getAttributeInt("REL_ORBIT", 0));
                    this.data[4] = String.valueOf(absRoot.getAttributeInt("ABS_ORBIT", 0));
                }
            }
        }
    }
}

