/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.gpf.CommonReaders;
import org.esa.snap.engine_utilities.gpf.ProcessTimeMonitor;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.ProductSetPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTable;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphDialog;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphsMenu;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.FileChooserFactory;
import org.esa.snap.ui.ModelessDialog;

public class BatchGraphDialog
extends ModelessDialog
implements GraphDialog,
LabelBarProgressMonitor.ProgressBarListener {
    protected static final Path defaultGraphPath = ResourceUtils.getGraphFolder((String)"");
    private final AppContext appContext;
    private final String baseTitle;
    protected final List<GraphExecuter> graphExecutorList = new ArrayList<GraphExecuter>(10);
    private final List<BatchProcessListener> listenerList = new ArrayList<BatchProcessListener>(1);
    protected ProductSetPanel productSetPanel;
    private JTabbedPane tabbedPane;
    private JLabel statusLabel;
    private JLabel bottomStatusLabel;
    private JPanel progressPanel;
    private JProgressBar progressBar;
    private JLabel progressMsgLabel;
    private LabelBarProgressMonitor progBarMonitor;
    private Map<File, File[]> slaveFileMap;
    private final boolean closeOnDone;
    private boolean skipExistingTargetFiles;
    private boolean replaceWritersWithUniqueTargetProduct;
    private boolean isProcessing;
    protected File graphFile;
    protected boolean openProcessedProducts;

    public BatchGraphDialog(AppContext theAppContext, String title, String helpID, boolean closeOnDone) {
        super(theAppContext.getApplicationWindow(), title, 154, helpID);
        this.appContext = theAppContext;
        this.baseTitle = title;
        this.closeOnDone = closeOnDone;
        this.openProcessedProducts = true;
        this.setContent(this.createUI());
        if (this.getJDialog().getJMenuBar() == null) {
            GraphsMenu operatorMenu = new GraphsMenu(this.getJDialog(), this);
            this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
        }
        super.getJDialog().setMinimumSize(new Dimension(400, 300));
    }

    private JPanel createUI() {
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BatchGraphDialog.this.ValidateAllNodes();
            }
        });
        mainPanel.add((Component)this.tabbedPane, "Center");
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        mainPanel.add((Component)this.statusLabel, "North");
        this.bottomStatusLabel = new JLabel("");
        this.getButtonPanel().add((Component)this.bottomStatusLabel, 0);
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout(2, 2));
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.progressMsgLabel = new JLabel();
        this.progressPanel.add((Component)this.progressMsgLabel, "North");
        this.progBarMonitor = new LabelBarProgressMonitor(this.progressBar, this.progressMsgLabel);
        this.progBarMonitor.addListener(this);
        JButton progressCancelBtn = new JButton("Cancel");
        progressCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchGraphDialog.this.CancelProcessing();
            }
        });
        this.progressPanel.add((Component)progressCancelBtn, "East");
        this.progressPanel.setVisible(false);
        mainPanel.add((Component)this.progressPanel, "South");
        this.productSetPanel = new ProductSetPanel(this.appContext, null, new FileTable(), true, true);
        this.tabbedPane.add("I/O Parameters", this.productSetPanel);
        this.getButton(8).setText("Run");
        this.getButton(2).setText("Load Graph");
        return mainPanel;
    }

    public int show() {
        return super.show();
    }

    public void hide() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
        this.notifyMSG(BatchProcessListener.BatchMSG.CLOSE);
        super.hide();
    }

    public void onApply() {
        if (this.isProcessing) {
            return;
        }
        this.productSetPanel.onApply();
        this.skipExistingTargetFiles = this.productSetPanel.isSkippingExistingTargetFiles();
        try {
            this.DoProcessing();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            this.bottomStatusLabel.setText("");
        }
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void addListener(BatchProcessListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(BatchProcessListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyMSG(BatchProcessListener.BatchMSG msg, String text) {
        for (BatchProcessListener listener : this.listenerList) {
            listener.notifyMSG(msg, text);
        }
    }

    private void notifyMSG(BatchProcessListener.BatchMSG msg) {
        for (BatchProcessListener listener : this.listenerList) {
            listener.notifyMSG(msg, this.productSetPanel.getFileList(), this.getAllBatchProcessedTargetProducts());
        }
    }

    protected void onYes() {
        this.LoadGraph();
    }

    public void setInputFiles(File[] productFileList) {
        this.productSetPanel.setProductFileList(productFileList);
    }

    public void setInputFiles(ProductEntry[] productEntryList) {
        this.productSetPanel.setProductEntryList(productEntryList);
    }

    public void setTargetFolder(File path) {
        this.productSetPanel.setTargetFolder(path);
    }

    @Override
    public void LoadGraph() {
        if (this.isProcessing) {
            return;
        }
        File file = BatchGraphDialog.getFilePath(this.getContent(), "Graph File");
        if (file != null) {
            this.LoadGraph(file);
        }
    }

    @Override
    public void LoadGraph(File file) {
        try {
            this.graphFile = file;
            this.initGraphs();
            this.addGraphTabs("", true);
            this.setTitle(file.getName());
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to load graph " + file.toString(), (Throwable)e);
        }
    }

    public void setTitle(String title) {
        super.setTitle(this.baseTitle + " : " + title);
    }

    @Override
    public boolean canSaveGraphs() {
        return false;
    }

    @Override
    public void SaveGraph() {
    }

    @Override
    public String getGraphAsString() throws GraphException, IOException {
        if (!this.graphExecutorList.isEmpty()) {
            return this.graphExecutorList.get(0).getGraphAsString();
        }
        return "";
    }

    private static File getFilePath(Component component, String title) {
        File graphPath = new File(SnapApp.getDefault().getPreferences().get("batch.last_graph_path", defaultGraphPath.toFile().getAbsolutePath()));
        JFileChooser chooser = FileChooserFactory.getInstance().createFileChooser(graphPath);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(title);
        if (chooser.showDialog(component, "OK") == 0) {
            File file = chooser.getSelectedFile();
            SnapApp.getDefault().getPreferences().put("batch.last_graph_path", file.getAbsolutePath());
            return file;
        }
        return null;
    }

    protected void onClose() {
        this.CancelProcessing();
        super.onClose();
    }

    void initGraphs() {
        try {
            this.replaceWritersWithUniqueTargetProduct = this.productSetPanel.isReplacingWritersWithUniqueTargetProduct();
            this.deleteGraphs();
            this.createGraphs();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            this.bottomStatusLabel.setText("");
        }
    }

    private void DoProcessing() {
        if (this.ValidateAllNodes()) {
            SystemUtils.freeAllMemory();
            this.progressBar.setValue(0);
            ProcessThread processThread = new ProcessThread(this.progBarMonitor);
            processThread.execute();
        } else if (this.statusLabel.getText() != null && !this.statusLabel.getText().isEmpty()) {
            this.showErrorDialog(this.statusLabel.getText());
        }
    }

    @Override
    public void notifyProgressStart() {
        this.progressPanel.setVisible(true);
    }

    @Override
    public void notifyProgressDone() {
        this.progressPanel.setVisible(false);
    }

    private void CancelProcessing() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
    }

    private void deleteGraphs() {
        for (GraphExecuter gex : this.graphExecutorList) {
            gex.ClearGraph();
        }
        this.graphExecutorList.clear();
    }

    protected void LoadGraph(GraphExecuter executer, File file, boolean addUI) {
        try {
            executer.loadGraph(new FileInputStream(file), file, addUI, true);
        }
        catch (Exception e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    private boolean ValidateAllNodes() {
        boolean result;
        if (this.isProcessing) {
            return false;
        }
        if (this.productSetPanel == null) {
            return false;
        }
        if (this.graphExecutorList.isEmpty()) {
            return false;
        }
        this.statusLabel.setText("");
        try {
            this.cloneGraphs();
            this.assignParameters();
            result = this.graphExecutorList.get(0).InitGraph();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            this.bottomStatusLabel.setText("");
            result = false;
        }
        return result;
    }

    private void openTargetProducts() {
        File[] fileList = this.getAllBatchProcessedTargetProducts();
        if (fileList != null && fileList.length > 0) {
            for (File file : fileList) {
                try {
                    Product product = CommonReaders.readProduct((File)file);
                    if (product == null) continue;
                    this.appContext.getProductManager().addProduct(product);
                }
                catch (IOException e) {
                    this.showErrorDialog(e.getMessage());
                }
            }
        }
    }

    protected ProductSetPanel getProductSetPanel() {
        return this.productSetPanel;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.productSetPanel.setTargetProductNameSuffix(suffix);
    }

    void createGraphs() throws GraphException {
        try {
            GraphExecuter graphEx = new GraphExecuter();
            this.LoadGraph(graphEx, this.graphFile, true);
            this.graphExecutorList.add(graphEx);
        }
        catch (Exception e) {
            throw new GraphException(e.getMessage());
        }
    }

    private void addGraphTabs(String title, boolean addUI) {
        if (this.graphExecutorList.isEmpty()) {
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        while (this.tabbedPane.getTabCount() > 1) {
            this.tabbedPane.remove(this.tabbedPane.getTabCount() - 1);
        }
        GraphExecuter graphEx = this.graphExecutorList.get(0);
        for (GraphNode n : graphEx.GetGraphNodes()) {
            if (n.GetOperatorUI() == null) continue;
            if (n.getNode().getOperatorName().equals("Read") || this.replaceWritersWithUniqueTargetProduct && n.getNode().getOperatorName().equals("Write") || n.getNode().getOperatorName().equals("ProductSet-Reader")) {
                n.setOperatorUI(null);
                continue;
            }
            if (!addUI) continue;
            String tabTitle = title;
            if (tabTitle.isEmpty()) {
                tabTitle = n.getOperatorName();
            }
            this.tabbedPane.addTab(tabTitle, null, n.GetOperatorUI().CreateOpTab(n.getOperatorName(), n.getParameterMap(), this.appContext), n.getID() + " Operator");
        }
    }

    public void setSlaveFileMap(Map<File, File[]> fileMap) {
        this.slaveFileMap = fileMap;
    }

    protected void assignParameters() {
        File[] fileList = this.productSetPanel.getFileList();
        int graphIndex = 0;
        for (File f : fileList) {
            File[] slaveFiles;
            String name = FileUtils.getFilenameWithoutExtension((File)f);
            File targetFolder = this.productSetPanel.getTargetFolder();
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                SystemUtils.LOG.severe("Unable to create folders in " + targetFolder);
            }
            File targetFile = new File(targetFolder, name);
            String targetFormat = this.productSetPanel.getTargetFormat();
            this.setIO(this.graphExecutorList.get(graphIndex), "Read", f, "Write", targetFile, targetFormat);
            if (this.slaveFileMap != null && (slaveFiles = this.slaveFileMap.get(f)) != null) {
                BatchGraphDialog.setSlaveIO(this.graphExecutorList.get(graphIndex), "ProductSet-Reader", f, slaveFiles);
            }
            ++graphIndex;
        }
    }

    protected void setIO(GraphExecuter graphEx, String readID, File readPath, String writeID, File writePath, String format) {
        GraphNode writeNode;
        GraphNode readNode = graphEx.getGraphNodeList().findGraphNodeByOperator(readID);
        if (readNode != null) {
            graphEx.setOperatorParam(readNode.getID(), "file", readPath.getAbsolutePath());
        }
        if (this.replaceWritersWithUniqueTargetProduct && writeID != null && (writeNode = graphEx.getGraphNodeList().findGraphNodeByOperator(writeID)) != null) {
            if (format != null) {
                graphEx.setOperatorParam(writeNode.getID(), "formatName", format);
            }
            graphEx.setOperatorParam(writeNode.getID(), "file", writePath.getAbsolutePath());
        }
    }

    protected static void setSlaveIO(GraphExecuter graphEx, String productSetID, File masterFile, File[] slaveFiles) {
        GraphNode productSetNode = graphEx.getGraphNodeList().findGraphNodeByOperator(productSetID);
        if (productSetNode != null) {
            StringBuilder str = new StringBuilder(masterFile.getAbsolutePath());
            for (File slaveFile : slaveFiles) {
                str.append(',');
                str.append(slaveFile.getAbsolutePath());
            }
            graphEx.setOperatorParam(productSetNode.getID(), "fileList", str.toString());
        }
    }

    protected void cloneGraphs() throws Exception {
        GraphExecuter graphEx = this.graphExecutorList.get(0);
        for (int graphIndex = 1; graphIndex < this.graphExecutorList.size(); ++graphIndex) {
            GraphExecuter cloneGraphEx = this.graphExecutorList.get(graphIndex);
            cloneGraphEx.ClearGraph();
        }
        this.graphExecutorList.clear();
        this.graphExecutorList.add(graphEx);
        File[] fileList = this.productSetPanel.getFileList();
        for (int graphIndex = 1; graphIndex < fileList.length; ++graphIndex) {
            GraphNode[] cloneGraphNodes;
            GraphExecuter cloneGraphEx = new GraphExecuter();
            this.LoadGraph(cloneGraphEx, this.graphFile, false);
            this.graphExecutorList.add(cloneGraphEx);
            for (GraphNode cloneNode : cloneGraphNodes = cloneGraphEx.GetGraphNodes()) {
                GraphNode node = graphEx.getGraphNodeList().findGraphNode(cloneNode.getID());
                if (node == null) continue;
                cloneNode.setOperatorUI(node.GetOperatorUI());
            }
        }
    }

    public File[] getAllBatchProcessedTargetProducts() {
        ArrayList<File> targetFileList = new ArrayList<File>();
        for (GraphExecuter graphEx : this.graphExecutorList) {
            targetFileList.addAll(graphEx.getProductsToOpenInDAT());
        }
        return targetFileList.toArray(new File[targetFileList.size()]);
    }

    void cleanUpTempFiles() {
    }

    public static interface BatchProcessListener {
        public void notifyMSG(BatchMSG var1, File[] var2, File[] var3);

        public void notifyMSG(BatchMSG var1, String var2);

        public static enum BatchMSG {
            DONE,
            UPDATE,
            CLOSE;

        }
    }

    private class ProcessThread
    extends SwingWorker<Boolean, Object> {
        private final ProgressMonitor pm;
        private ProcessTimeMonitor timeMonitor = new ProcessTimeMonitor();
        private boolean errorOccured = false;
        final List<String> errMsgs = new ArrayList<String>();

        public ProcessThread(ProgressMonitor pm) {
            this.pm = pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean doInBackground() throws Exception {
            this.pm.beginTask("Processing Graph...", BatchGraphDialog.this.graphExecutorList.size());
            try {
                this.timeMonitor.start();
                BatchGraphDialog.this.isProcessing = true;
                File[] existingFiles = BatchGraphDialog.this.productSetPanel.getTargetFolder().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                File[] fileList = BatchGraphDialog.this.productSetPanel.getFileList();
                int graphIndex = 0;
                for (GraphExecuter graphEx : BatchGraphDialog.this.graphExecutorList) {
                    if (this.pm.isCanceled()) {
                        break;
                    }
                    String nOfm = String.valueOf(graphIndex + 1) + " of " + BatchGraphDialog.this.graphExecutorList.size() + ' ';
                    String statusText = nOfm + fileList[graphIndex].getName();
                    try {
                        graphEx.InitGraph();
                        graphEx.InitGraph();
                        if (this.shouldSkip(graphEx, existingFiles)) {
                            BatchGraphDialog.this.statusLabel.setText("Skipping " + statusText);
                            BatchGraphDialog.this.notifyMSG(BatchProcessListener.BatchMSG.UPDATE, statusText);
                            this.pm.worked(1);
                            graphEx = null;
                            ++graphIndex;
                            continue;
                        }
                        BatchGraphDialog.this.statusLabel.setText("Processing " + statusText);
                        BatchGraphDialog.this.notifyMSG(BatchProcessListener.BatchMSG.UPDATE, statusText);
                        graphEx.executeGraph(SubProgressMonitor.create((ProgressMonitor)this.pm, (int)1));
                        graphEx.disposeGraphContext();
                        SystemUtils.freeAllMemory();
                    }
                    catch (Exception e) {
                        SystemUtils.LOG.severe(e.getMessage());
                        String filename = fileList[graphIndex].getName();
                        this.errMsgs.add(filename + " -> " + e.getMessage());
                    }
                    graphEx = null;
                    long duration = this.timeMonitor.getCurrentDuration();
                    double timePerGraph = (double)duration / (double)(++graphIndex);
                    long timeLeft = (long)(timePerGraph * (double)(BatchGraphDialog.this.graphExecutorList.size() - graphIndex));
                    if (timeLeft <= 0L) continue;
                    String remainingStr = "Estimated " + ProcessTimeMonitor.formatDuration((long)timeLeft) + " remaining";
                    if (!this.errMsgs.isEmpty()) {
                        remainingStr = remainingStr + " (Errors occurred)";
                    }
                    BatchGraphDialog.this.bottomStatusLabel.setText(remainingStr);
                }
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(e.getMessage());
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    BatchGraphDialog.this.statusLabel.setText(e.getMessage());
                } else {
                    BatchGraphDialog.this.statusLabel.setText(e.toString());
                }
                this.errorOccured = true;
            }
            finally {
                long duration = this.timeMonitor.stop();
                BatchGraphDialog.this.statusLabel.setText("Processing completed in " + ProcessTimeMonitor.formatDuration((long)duration));
                BatchGraphDialog.this.isProcessing = false;
                this.pm.done();
                if (BatchGraphDialog.this.openProcessedProducts) {
                    BatchGraphDialog.this.bottomStatusLabel.setText("Opening resulting products...");
                }
            }
            return true;
        }

        @Override
        public void done() {
            if (!this.errorOccured) {
                if (BatchGraphDialog.this.openProcessedProducts) {
                    BatchGraphDialog.this.openTargetProducts();
                }
                BatchGraphDialog.this.bottomStatusLabel.setText("");
            }
            if (!this.errMsgs.isEmpty()) {
                StringBuilder msg = new StringBuilder("The following errors occurred:\n");
                for (String errStr : this.errMsgs) {
                    msg.append(errStr);
                    msg.append('\n');
                }
                BatchGraphDialog.this.showErrorDialog(msg.toString());
            }
            BatchGraphDialog.this.cleanUpTempFiles();
            BatchGraphDialog.this.notifyMSG(BatchProcessListener.BatchMSG.DONE);
            if (BatchGraphDialog.this.closeOnDone) {
                BatchGraphDialog.this.close();
            }
            if (SnapApp.getDefault().getPreferences().getBoolean("snap.gpf.beepAfterProcessing", false)) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private boolean shouldSkip(GraphExecuter graphEx, File[] existingFiles) {
            if (BatchGraphDialog.this.skipExistingTargetFiles && existingFiles != null) {
                File[] targetFiles = graphEx.getPotentialOutputFiles();
                boolean allTargetsExist = true;
                for (File targetFile : targetFiles) {
                    String targetPath = targetFile.getAbsolutePath();
                    boolean fileExists = false;
                    for (File existingFile : existingFiles) {
                        if (!existingFile.getAbsolutePath().equalsIgnoreCase(targetPath)) continue;
                        fileExists = true;
                        break;
                    }
                    if (fileExists) continue;
                    allTargetsExist = false;
                    break;
                }
                return allTargetsExist;
            }
            return false;
        }
    }
}

