/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui.worldmap;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.MouseInputAdapter;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.NestWorldMapPane;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.NestWorldMapPaneDataModel;

public class WorldMapUI {
    private final NestWorldMapPaneDataModel worldMapDataModel;
    private final NestWorldMapPane worlMapPane;
    private final List<WorldMapUIListener> listenerList = new ArrayList<WorldMapUIListener>(1);

    public WorldMapUI() {
        this.worldMapDataModel = new NestWorldMapPaneDataModel();
        this.worlMapPane = new NestWorldMapPane(this.worldMapDataModel);
        this.worlMapPane.getLayerCanvas().addMouseListener((MouseListener)new MouseHandler());
    }

    public GeoPos[] getSelectionBox() {
        return this.worldMapDataModel.getSelectionBox();
    }

    public void setSelectionStart(double lat, double lon) {
        this.worldMapDataModel.setSelectionBoxStart(lat, lon);
    }

    public void setSelectionEnd(double lat, double lon) {
        this.worldMapDataModel.setSelectionBoxEnd(lat, lon);
    }

    public void setAdditionalGeoBoundaries(GeoPos[][] geoBoundaries) {
        this.worldMapDataModel.setAdditionalGeoBoundaries(geoBoundaries);
    }

    public void setSelectedGeoBoundaries(GeoPos[][] geoBoundaries) {
        this.worldMapDataModel.setSelectedGeoBoundaries(geoBoundaries);
    }

    public NestWorldMapPane getWorlMapPane() {
        return this.worlMapPane;
    }

    public NestWorldMapPaneDataModel getModel() {
        return this.worldMapDataModel;
    }

    public void addListener(WorldMapUIListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(WorldMapUIListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyQuery() {
        for (WorldMapUIListener listener : this.listenerList) {
            listener.notifyNewMapSelectionAvailable();
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                WorldMapUI.this.notifyQuery();
            }
        }
    }

    public static interface WorldMapUIListener {
        public void notifyNewMapSelectionAvailable();
    }
}

