/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui.worldmap;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glayer.swing.WakefulComponent;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.NestWorldMapPaneDataModel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.ButtonOverlayControl;
import org.esa.snap.ui.UIUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class NestWorldMapPane
extends JPanel {
    private LayerCanvas layerCanvas;
    private Layer worldMapLayer;
    private final NestWorldMapPaneDataModel dataModel;
    private boolean navControlShown;
    private WakefulComponent navControlWrapper;
    private static final Color transWhiteColor = new Color(255, 255, 255, 5);
    private static final Color borderWhiteColor = new Color(255, 255, 255, 100);
    private static final Color transRedColor = new Color(255, 0, 0, 30);
    private static final Color borderRedColor = new Color(255, 0, 0, 100);
    private static final Color selectionFillColor = new Color(255, 255, 0, 70);
    private static final Color selectionBorderColor = new Color(255, 255, 0, 255);

    public NestWorldMapPane(NestWorldMapPaneDataModel dataModel) {
        this.dataModel = dataModel;
        try {
            this.layerCanvas = new LayerCanvas();
            this.layerCanvas.getModel().getViewport().setModelYAxisDown(false);
            NestWorldMapPane.installLayerCanvasNavigation(this.layerCanvas, dataModel);
            this.layerCanvas.addOverlay((LayerCanvas.Overlay)new BoundaryOverlay());
            Layer rootLayer = this.layerCanvas.getLayer();
            Dimension dimension = new Dimension(400, 150);
            Viewport viewport = this.layerCanvas.getViewport();
            viewport.setViewBounds(new Rectangle(dimension));
            this.setPreferredSize(dimension);
            this.setSize(dimension);
            this.setLayout(new BorderLayout());
            this.add((Component)this.layerCanvas, "Center");
            dataModel.addModelChangeListener(new ModelChangeListener());
            this.worldMapLayer = dataModel.getWorldMapLayer(new WorldMapLayerContext(rootLayer));
            this.layerCanvas.getLayer().getChildren().add(this.worldMapLayer);
            this.layerCanvas.getViewport().zoom(this.worldMapLayer.getModelBounds());
            this.setNavControlVisible(true);
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Error in worldmap initialization", (Throwable)e);
        }
    }

    public LayerCanvas getLayerCanvas() {
        return this.layerCanvas;
    }

    @Override
    public void doLayout() {
        if (this.navControlShown && this.navControlWrapper != null) {
            this.navControlWrapper.setLocation(this.getWidth() - this.navControlWrapper.getWidth() - 4, 4);
        }
        super.doLayout();
    }

    public Product getSelectedProduct() {
        return this.dataModel.getSelectedProduct();
    }

    public Product[] getProducts() {
        return this.dataModel.getProducts();
    }

    public float getScale() {
        return (float)this.layerCanvas.getViewport().getZoomFactor();
    }

    public void setScale(float scale) {
        if (this.getScale() != scale) {
            float oldValue = this.getScale();
            this.layerCanvas.getViewport().setZoomFactor((double)scale);
            this.firePropertyChange("scale", oldValue, scale);
        }
    }

    public void zoomToProduct(Product product) {
        GeneralPath[] generalPaths;
        NestWorldMapPaneDataModel.Boundary[] selGeoBoundaries = this.dataModel.getSelectedGeoBoundaries();
        if (product != null && product.getSceneGeoCoding() != null) {
            generalPaths = NestWorldMapPane.getGeoBoundaryPaths(product);
        } else if (selGeoBoundaries.length > 0) {
            generalPaths = NestWorldMapPane.assemblePathList(selGeoBoundaries[0].geoBoundary);
        } else {
            return;
        }
        Rectangle2D modelArea = new Rectangle2D.Double();
        Viewport viewport = this.layerCanvas.getViewport();
        for (GeneralPath generalPath : generalPaths) {
            Rectangle2D rectangle2D = generalPath.getBounds2D();
            if (((RectangularShape)modelArea).isEmpty()) {
                if (!viewport.isModelYAxisDown()) {
                    modelArea.setFrame(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                }
                modelArea = rectangle2D;
                continue;
            }
            modelArea.add(rectangle2D);
        }
        Rectangle2D modelBounds = ((Rectangle2D)modelArea).getBounds2D();
        modelBounds.setFrame(modelBounds.getX() - 2.0, modelBounds.getY() - 2.0, modelBounds.getWidth() + 4.0, modelBounds.getHeight() + 4.0);
        modelBounds = this.cropToMaxModelBounds(modelBounds);
        viewport.zoom(modelBounds);
    }

    public void setNavControlVisible(boolean navControlShown) {
        boolean oldValue = this.navControlShown;
        if (oldValue != navControlShown) {
            if (navControlShown) {
                ButtonOverlayControl navControl = new ButtonOverlayControl(new Action[]{new ZoomAllAction(), new ZoomToSelectedAction()});
                this.navControlWrapper = new WakefulComponent((JComponent)navControl);
                this.navControlWrapper.setMinAlpha(0.5f);
                this.layerCanvas.add((Component)this.navControlWrapper);
            } else {
                this.layerCanvas.remove((Component)this.navControlWrapper);
                this.navControlWrapper = null;
            }
            this.validate();
            this.navControlShown = navControlShown;
        }
    }

    private void updateUiState(PropertyChangeEvent evt) {
        if ("layer".equals(evt.getPropertyName())) {
            this.exchangeWorldMapLayer();
        }
        if ("products".equals(evt.getPropertyName())) {
            this.repaint();
        }
        if ("selectedProduct".equals(evt.getPropertyName()) || "autoZoomEnabled".equals(evt.getPropertyName())) {
            Product selectedProduct = this.dataModel.getSelectedProduct();
            if (selectedProduct != null && this.dataModel.isAutoZommEnabled()) {
                this.zoomToProduct(selectedProduct);
            } else {
                this.repaint();
            }
        }
        if ("additionalGeoBoundaries".equals(evt.getPropertyName()) || "selectedGeoBoundaries".equals(evt.getPropertyName())) {
            this.repaint();
        }
    }

    private void exchangeWorldMapLayer() {
        List children = this.layerCanvas.getLayer().getChildren();
        for (Layer child : children) {
            child.dispose();
        }
        children.clear();
        Layer rootLayer = this.layerCanvas.getLayer();
        this.worldMapLayer = this.dataModel.getWorldMapLayer(new WorldMapLayerContext(rootLayer));
        children.add(this.worldMapLayer);
        this.layerCanvas.getViewport().zoom(this.worldMapLayer.getModelBounds());
    }

    private Rectangle2D cropToMaxModelBounds(Rectangle2D modelBounds) {
        Rectangle2D maxModelBounds = this.worldMapLayer.getModelBounds();
        if (modelBounds.getWidth() >= maxModelBounds.getWidth() - 1.0 || modelBounds.getHeight() >= maxModelBounds.getHeight() - 1.0) {
            modelBounds = maxModelBounds;
        }
        return modelBounds;
    }

    public static GeneralPath[] getGeoBoundaryPaths(Product product) {
        int step = Math.max(16, (product.getSceneRasterWidth() + product.getSceneRasterHeight()) / 250);
        return ProductUtils.createGeoBoundaryPaths((Product)product, null, (int)step);
    }

    private PixelPos getProductCenter(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        PixelPos centerPos = null;
        if (geoCoding != null) {
            float pixelX = (float)Math.floor(0.5f * (float)product.getSceneRasterWidth()) + 0.5f;
            float pixelY = (float)Math.floor(0.5f * (float)product.getSceneRasterHeight()) + 0.5f;
            GeoPos geoPos = geoCoding.getGeoPos(new PixelPos((double)pixelX, (double)pixelY), null);
            AffineTransform transform = this.layerCanvas.getViewport().getModelToViewTransform();
            Point2D point2D = transform.transform(new Point2D.Double(geoPos.getLon(), geoPos.getLat()), null);
            centerPos = new PixelPos((double)((float)point2D.getX()), (double)((float)point2D.getY()));
        }
        return centerPos;
    }

    private static void installLayerCanvasNavigation(LayerCanvas layerCanvas, NestWorldMapPaneDataModel dataModel) {
        MouseHandler mouseHandler = new MouseHandler(layerCanvas, dataModel);
        layerCanvas.addMouseListener((MouseListener)mouseHandler);
        layerCanvas.addMouseMotionListener((MouseMotionListener)mouseHandler);
        layerCanvas.addMouseWheelListener((MouseWheelListener)mouseHandler);
    }

    public static GeneralPath[] assemblePathList(GeoPos[] geoPoints) {
        GeneralPath path = new GeneralPath(1, geoPoints.length + 8);
        ArrayList<GeneralPath> pathList = new ArrayList<GeneralPath>(16);
        if (geoPoints.length > 1) {
            double minLon = 0.0;
            double maxLon = 0.0;
            boolean first = true;
            for (GeoPos gp : geoPoints) {
                double lon = gp.getLon();
                double lat = gp.getLat();
                if (first) {
                    minLon = lon;
                    maxLon = lon;
                    path.moveTo(lon, lat);
                    first = false;
                }
                if (lon < minLon) {
                    minLon = lon;
                }
                if (lon > maxLon) {
                    maxLon = lon;
                }
                path.lineTo(lon, lat);
            }
            int runIndexMin = (int)Math.floor((minLon + 180.0) / 360.0);
            int runIndexMax = (int)Math.floor((maxLon + 180.0) / 360.0);
            if (runIndexMin == 0 && runIndexMax == 0) {
                pathList.add(path);
                return pathList.toArray(new GeneralPath[pathList.size()]);
            }
            Area pathArea = new Area(path);
            GeneralPath pixelPath = new GeneralPath(1);
            for (int k = runIndexMin; k <= runIndexMax; ++k) {
                Area currentArea = new Area(new Rectangle2D.Float((float)k * 360.0f - 180.0f, -90.0f, 360.0f, 180.0f));
                currentArea.intersect(pathArea);
                if (currentArea.isEmpty()) continue;
                pathList.add(NestWorldMapPane.areaToPath(currentArea, (double)(-k) * 360.0, pixelPath));
            }
        }
        return pathList.toArray(new GeneralPath[pathList.size()]);
    }

    private static GeneralPath areaToPath(Area negativeArea, double deltaX, GeneralPath pixelPath) {
        float[] floats = new float[6];
        AffineTransform transform = AffineTransform.getTranslateInstance(deltaX, 0.0);
        PathIterator iterator = negativeArea.getPathIterator(transform);
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(floats);
            if (segmentType == 1) {
                pixelPath.lineTo(floats[0], floats[1]);
            } else if (segmentType == 0) {
                pixelPath.moveTo(floats[0], floats[1]);
            } else if (segmentType == 4) {
                pixelPath.closePath();
            }
            iterator.next();
        }
        return pixelPath;
    }

    private class ZoomToLocationAction
    extends AbstractAction {
        private ZoomToLocationAction() {
            this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon((String)"/org/esa/nest/icons/define-location-24.png", this.getClass()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NestWorldMapPane.this.zoomToProduct(NestWorldMapPane.this.getSelectedProduct());
        }
    }

    private class ZoomToSelectedAction
    extends AbstractAction {
        private ZoomToSelectedAction() {
            this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon((String)"icons/ZoomTo24.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NestWorldMapPane.this.zoomToProduct(NestWorldMapPane.this.getSelectedProduct());
        }
    }

    private class ZoomAllAction
    extends AbstractAction {
        private ZoomAllAction() {
            this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon((String)"icons/ZoomAll24.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NestWorldMapPane.this.layerCanvas.getViewport().zoom(NestWorldMapPane.this.worldMapLayer.getModelBounds());
        }
    }

    private class BoundaryOverlay
    implements LayerCanvas.Overlay {
        private BoundaryOverlay() {
        }

        public void paintOverlay(LayerCanvas canvas, Rendering rendering) {
            for (NestWorldMapPaneDataModel.Boundary extraGeoBoundary : NestWorldMapPane.this.dataModel.getAdditionalGeoBoundaries()) {
                this.drawGeoBoundary(rendering.getGraphics(), NestWorldMapPane.assemblePathList(extraGeoBoundary.geoBoundary), extraGeoBoundary.isClosed, transWhiteColor, borderWhiteColor);
            }
            for (NestWorldMapPaneDataModel.Boundary selectGeoBoundary : NestWorldMapPane.this.dataModel.getSelectedGeoBoundaries()) {
                this.drawGeoBoundary(rendering.getGraphics(), NestWorldMapPane.assemblePathList(selectGeoBoundary.geoBoundary), selectGeoBoundary.isClosed, transRedColor, borderRedColor);
            }
            Product selectedProduct = NestWorldMapPane.this.dataModel.getSelectedProduct();
            for (Product product : NestWorldMapPane.this.dataModel.getProducts()) {
                if (product == null || selectedProduct == product) continue;
                this.drawProduct(rendering.getGraphics(), product, transWhiteColor, Color.WHITE);
            }
            if (selectedProduct != null) {
                this.drawProduct(rendering.getGraphics(), selectedProduct, transWhiteColor, Color.RED);
            }
            NestWorldMapPaneDataModel.Boundary selectionBox = NestWorldMapPane.this.dataModel.getSelectionBoundary();
            this.drawGeoBoundary(rendering.getGraphics(), NestWorldMapPane.assemblePathList(selectionBox.geoBoundary), selectionBox.isClosed, selectionFillColor, selectionBorderColor);
        }

        private boolean isClosedPath(GeoPos[] geoBoundary) {
            return geoBoundary[0].equals((Object)geoBoundary[geoBoundary.length - 1]);
        }

        private void drawProduct(Graphics2D g2d, Product product, Color fillColor, Color borderColor) {
            GeoCoding geoCoding = product.getSceneGeoCoding();
            if (geoCoding == null) {
                return;
            }
            GeneralPath[] boundaryPaths = NestWorldMapPane.getGeoBoundaryPaths(product);
            String text = String.valueOf(product.getRefNo());
            PixelPos textCenter = NestWorldMapPane.this.getProductCenter(product);
            this.drawGeoBoundaryPath(g2d, boundaryPaths, fillColor, borderColor);
            this.drawText(g2d, text, textCenter, 0.0f);
        }

        private void drawGeoBoundaryPath(Graphics2D g2d, GeneralPath[] boundaryPaths, Color fillColor, Color borderColor) {
            AffineTransform transform = NestWorldMapPane.this.layerCanvas.getViewport().getModelToViewTransform();
            for (GeneralPath boundaryPath : boundaryPaths) {
                boundaryPath.transform(transform);
                g2d.setColor(fillColor);
                g2d.fill(boundaryPath);
                g2d.setColor(borderColor);
                g2d.draw(boundaryPath);
            }
        }

        private void drawGeoBoundary(Graphics2D g2d, GeneralPath[] boundaryPaths, boolean fill, Color fillColor, Color borderColor) {
            AffineTransform transform = NestWorldMapPane.this.layerCanvas.getViewport().getModelToViewTransform();
            for (GeneralPath boundaryPath : boundaryPaths) {
                boundaryPath.transform(transform);
                if (fill) {
                    g2d.setColor(fillColor);
                    g2d.fill(boundaryPath);
                }
                g2d.setColor(borderColor);
                g2d.draw(boundaryPath);
            }
        }

        private GeneralPath convertToPixelPath(GeoPos[] geoBoundary) {
            GeneralPath gp = new GeneralPath();
            for (int i = 0; i < geoBoundary.length; ++i) {
                GeoPos geoPos = geoBoundary[i];
                AffineTransform m2vTransform = NestWorldMapPane.this.layerCanvas.getViewport().getModelToViewTransform();
                Point2D viewPos = m2vTransform.transform(new Point2D.Double(geoPos.lon, geoPos.lat), null);
                if (i == 0) {
                    gp.moveTo(viewPos.getX(), viewPos.getY());
                    continue;
                }
                gp.lineTo(viewPos.getX(), viewPos.getY());
            }
            gp.closePath();
            return gp;
        }

        private void drawText(Graphics2D g2d, String text, PixelPos textCenter, float offsetX) {
            if (text == null || textCenter == null) {
                return;
            }
            g2d = this.prepareGraphics2D(offsetX, g2d);
            FontMetrics fontMetrics = g2d.getFontMetrics();
            Color color = g2d.getColor();
            g2d.setColor(Color.black);
            g2d.drawString(text, (float)((int)textCenter.x) - (float)fontMetrics.stringWidth(text) / 2.0f, (float)((int)textCenter.y) + (float)fontMetrics.getAscent() / 2.0f);
            g2d.setColor(color);
        }

        private Graphics2D prepareGraphics2D(float offsetX, Graphics2D g2d) {
            if (offsetX != 0.0f) {
                g2d = (Graphics2D)g2d.create();
                AffineTransform transform = g2d.getTransform();
                AffineTransform offsetTrans = new AffineTransform();
                offsetTrans.setToTranslation(offsetX, 0.0);
                transform.concatenate(offsetTrans);
                g2d.setTransform(transform);
            }
            return g2d;
        }
    }

    private static class WorldMapLayerContext
    implements LayerContext {
        private final Layer rootLayer;

        private WorldMapLayerContext(Layer rootLayer) {
            this.rootLayer = rootLayer;
        }

        public Object getCoordinateReferenceSystem() {
            return DefaultGeographicCRS.WGS84;
        }

        public Layer getRootLayer() {
            return this.rootLayer;
        }
    }

    public static class MouseHandler
    extends MouseInputAdapter {
        private final LayerCanvas layerCanvas;
        private final NestWorldMapPaneDataModel dataModel;
        private Point p0;
        private Point2D.Float selectionStart = new Point2D.Float();
        private Point2D.Float selectionEnd = new Point2D.Float();
        private boolean leftButtonDown = false;

        private MouseHandler(LayerCanvas layerCanvas, NestWorldMapPaneDataModel dataModel) {
            this.layerCanvas = layerCanvas;
            this.dataModel = dataModel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.leftButtonDown = true;
                AffineTransform viewToModelTransform = this.layerCanvas.getViewport().getViewToModelTransform();
                viewToModelTransform.transform(e.getPoint(), this.selectionStart);
                this.dataModel.setSelectionBoxStart(this.selectionStart.y, this.selectionStart.x);
                this.dataModel.setSelectionBoxEnd(this.selectionStart.y, this.selectionStart.x);
                this.layerCanvas.updateUI();
            } else {
                this.p0 = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.leftButtonDown = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            if (this.leftButtonDown) {
                AffineTransform viewToModelTransform = this.layerCanvas.getViewport().getViewToModelTransform();
                viewToModelTransform.transform(e.getPoint(), this.selectionEnd);
                this.dataModel.setSelectionBoxEnd(this.selectionEnd.y, this.selectionEnd.x);
                this.layerCanvas.updateUI();
            } else if (this.p0 != null) {
                double dx = p.x - this.p0.x;
                double dy = p.y - this.p0.y;
                this.layerCanvas.getViewport().moveViewDelta(dx, dy);
                this.p0 = p;
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int wheelRotation = e.getWheelRotation();
            double newZoomFactor = this.layerCanvas.getViewport().getZoomFactor() * FastMath.pow((double)1.1, (int)wheelRotation);
            this.layerCanvas.getViewport().setZoomFactor(newZoomFactor);
        }
    }

    private class ModelChangeListener
    implements PropertyChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NestWorldMapPane.this.updateUiState(evt);
        }
    }
}

