/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageGeometry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DemSelector;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsSelectionPanel;
import org.esa.snap.ui.crs.CustomCrsForm;
import org.esa.snap.ui.crs.OutputGeometryForm;
import org.esa.snap.ui.crs.OutputGeometryFormModel;
import org.esa.snap.ui.crs.PredefinedCrsForm;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReprojectionUI
extends BaseOperatorUI {
    private static final String[] RESAMPLING_IDENTIFIER = new String[]{"Nearest", "Bilinear", "Bicubic"};
    private JScrollPane scrollPane;
    private boolean orthoMode = false;
    private AppContext appContext = SnapApp.getDefault().getAppContext();
    private DemSelector demSelector;
    private CrsSelectionPanel crsSelectionPanel;
    private OutputGeometryFormModel outputGeometryModel;
    private JButton outputParamButton;
    private InfoForm infoForm;
    private CoordinateReferenceSystem crs;
    private CustomCrsForm customCrsUI;
    final JCheckBox preserveResolutionCheckBox = new JCheckBox("Preserve resolution", true);
    JCheckBox includeTPcheck = new JCheckBox("Reproject tie-point grids", true);
    final JTextField noDataField = new JTextField(Double.toString(Double.NaN));
    JCheckBox addDeltaBandsChecker = new JCheckBox("Add delta lat/lon bands");
    JComboBox<String> resampleComboBox = new JComboBox<String>(RESAMPLING_IDENTIFIER);

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.scrollPane = new JScrollPane(panel);
        return this.scrollPane;
    }

    @Override
    public void initParameters() {
        if (this.hasSourceProducts() && this.sourceProducts[0] != null) {
            this.crsSelectionPanel.setReferenceProduct(this.sourceProducts[0]);
            if (this.sourceProducts[0].getBand("longitude") != null && this.sourceProducts[0].getBand("latitude") != null || this.sourceProducts[0].getTiePointGrid("longitude") != null && this.sourceProducts[0].getTiePointGrid("latitude") != null) {
                this.addDeltaBandsChecker.setEnabled(true);
            } else {
                this.addDeltaBandsChecker.setEnabled(false);
            }
        }
        this.updateCRS();
        this.updateParameters();
    }

    @Override
    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        this.paramMap.clear();
        this.paramMap.put("resamplingName", this.resampleComboBox.getSelectedItem().toString());
        this.paramMap.put("includeTiePointGrids", this.includeTPcheck.isSelected());
        this.paramMap.put("addDeltaBands", this.addDeltaBandsChecker.isSelected());
        this.paramMap.put("noDataValue", Double.parseDouble(this.noDataField.getText()));
        CoordinateReferenceSystem selectedCrs = this.getSelectedCrs();
        if (selectedCrs != null) {
            this.paramMap.put("crs", selectedCrs.toWKT());
        } else {
            this.paramMap.put("crs", "EPSG:4326");
        }
        if (this.orthoMode) {
            this.paramMap.put("orthorectify", this.orthoMode);
            if (this.demSelector.isUsingExternalDem()) {
                this.paramMap.put("elevationModelName", this.demSelector.getDemName());
            } else {
                this.paramMap.put("elevationModelName", null);
            }
        }
        if (!this.preserveResolutionCheckBox.isSelected() && this.outputGeometryModel != null) {
            PropertySet container = this.outputGeometryModel.getPropertySet();
            this.paramMap.put("referencePixelX", container.getValue("referencePixelX"));
            this.paramMap.put("referencePixelY", container.getValue("referencePixelY"));
            this.paramMap.put("easting", container.getValue("easting"));
            this.paramMap.put("northing", container.getValue("northing"));
            this.paramMap.put("orientation", container.getValue("orientation"));
            this.paramMap.put("pixelSizeX", container.getValue("pixelSizeX"));
            this.paramMap.put("pixelSizeY", container.getValue("pixelSizeY"));
            this.paramMap.put("width", container.getValue("width"));
            this.paramMap.put("height", container.getValue("height"));
        }
    }

    private JComponent createPanel() {
        JPanel parameterPanel = new JPanel();
        TableLayout layout = new TableLayout(1);
        layout.setTablePadding(4, 4);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableWeightX(Double.valueOf(1.0));
        parameterPanel.setLayout((LayoutManager)layout);
        this.customCrsUI = new CustomCrsForm(this.appContext);
        PredefinedCrsForm predefinedCrsUI = new PredefinedCrsForm(this.appContext);
        CrsForm[] crsForms = new CrsForm[]{this.customCrsUI, predefinedCrsUI};
        this.crsSelectionPanel = new CrsSelectionPanel(crsForms);
        this.crsSelectionPanel.prepareShow();
        parameterPanel.add((Component)this.crsSelectionPanel);
        if (this.orthoMode) {
            this.demSelector = new DemSelector();
            parameterPanel.add((Component)this.demSelector);
        }
        parameterPanel.add(this.createOuputSettingsPanel());
        this.infoForm = new InfoForm();
        parameterPanel.add(this.infoForm.createUI());
        this.crsSelectionPanel.addPropertyChangeListener("crs", evt -> this.updateCRS());
        this.updateCRS();
        return parameterPanel;
    }

    Product getSourceProduct() {
        if (!this.hasSourceProducts()) {
            return null;
        }
        return this.sourceProducts[0];
    }

    CoordinateReferenceSystem getSelectedCrs() {
        return this.crs;
    }

    private void updateCRS() {
        Product sourceProduct = this.getSourceProduct();
        try {
            if (sourceProduct != null) {
                this.crs = this.crsSelectionPanel.getCrs(ProductUtils.getCenterGeoPos((Product)sourceProduct));
                this.infoForm.setCenterPos(ProductUtils.getCenterGeoPos((Product)sourceProduct));
                if (this.outputGeometryModel != null) {
                    this.outputGeometryModel.setSourceProduct(sourceProduct);
                }
                if (this.crs != null) {
                    this.infoForm.setCrsInfoText(this.crs.getName().getCode(), this.crs.toString());
                } else {
                    this.infoForm.setCrsErrorText("No valid 'Coordinate Reference System' selected.");
                }
            } else {
                this.infoForm.setCrsErrorText("No source product selected.");
                this.crs = null;
            }
        }
        catch (FactoryException e) {
            this.infoForm.setCrsErrorText(e.getMessage());
            this.crs = null;
        }
        if (this.outputGeometryModel != null) {
            this.outputGeometryModel.setTargetCrs(this.crs);
        }
        this.updateOutputParameterState();
    }

    private void updateProductSize() {
        int width = 0;
        int height = 0;
        Product sourceProduct = this.getSourceProduct();
        if (sourceProduct != null && this.crs != null) {
            if (!this.preserveResolutionCheckBox.isSelected() && this.outputGeometryModel != null) {
                PropertySet container = this.outputGeometryModel.getPropertySet();
                width = (Integer)container.getValue("width");
                height = (Integer)container.getValue("height");
            } else {
                ImageGeometry iGeometry = ImageGeometry.createTargetGeometry((Product)sourceProduct, (CoordinateReferenceSystem)this.crs, null, null, null, null, null, null, null, null, null);
                Rectangle imageRect = iGeometry.getImageRect();
                width = imageRect.width;
                height = imageRect.height;
            }
        }
        this.infoForm.setWidth(width);
        this.infoForm.setHeight(height);
    }

    private JPanel createOuputSettingsPanel() {
        TableLayout tableLayout = new TableLayout(3);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnFill(0, TableLayout.Fill.NONE);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setColumnPadding(0, new Insets(4, 4, 4, 20));
        tableLayout.setColumnWeightX(0, Double.valueOf(0.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
        tableLayout.setColumnWeightX(2, Double.valueOf(1.0));
        tableLayout.setCellColspan(0, 1, Integer.valueOf(2));
        tableLayout.setCellPadding(1, 0, new Insets(4, 24, 4, 20));
        JPanel outputSettingsPanel = new JPanel((LayoutManager)tableLayout);
        outputSettingsPanel.setBorder(BorderFactory.createTitledBorder("Output Settings"));
        this.preserveResolutionCheckBox.addActionListener(e -> {
            if (this.preserveResolutionCheckBox.isSelected()) {
                this.outputParamButton.setEnabled(false);
            } else {
                this.outputParamButton.setEnabled(true);
            }
        });
        outputSettingsPanel.add(this.preserveResolutionCheckBox);
        outputSettingsPanel.add(this.includeTPcheck);
        this.outputParamButton = new JButton("Output Parameters...");
        this.outputParamButton.setEnabled(!this.preserveResolutionCheckBox.isSelected());
        this.outputParamButton.addActionListener(new OutputParamActionListener());
        outputSettingsPanel.add(this.outputParamButton);
        outputSettingsPanel.add(new JLabel("No-data value:"));
        outputSettingsPanel.add(this.noDataField);
        outputSettingsPanel.add(this.addDeltaBandsChecker);
        outputSettingsPanel.add(new JLabel("Resampling method:"));
        this.resampleComboBox.setPrototypeDisplayValue(RESAMPLING_IDENTIFIER[0]);
        outputSettingsPanel.add(this.resampleComboBox);
        return outputSettingsPanel;
    }

    private void updateOutputParameterState() {
        this.outputParamButton.setEnabled(!this.preserveResolutionCheckBox.isSelected() && this.crs != null);
        this.updateProductSize();
    }

    private void showWarningMessage(String message) {
        AbstractDialog.showWarningDialog((Component)this.scrollPane, (String)message, (String)"Reprojection");
    }

    private class OutputParametersDialog
    extends ModalDialog {
        private static final String TITLE = "Output Parameters";
        private final Product sourceProduct;
        private final OutputGeometryFormModel outputGeometryFormModel;

        public OutputParametersDialog(Window parent, Product sourceProduct, OutputGeometryFormModel outputGeometryFormModel) {
            super(parent, TITLE, 97, null);
            this.sourceProduct = sourceProduct;
            this.outputGeometryFormModel = outputGeometryFormModel;
        }

        protected void onReset() {
            ImageGeometry imageGeometry = ImageGeometry.createTargetGeometry((Product)this.sourceProduct, (CoordinateReferenceSystem)ReprojectionUI.this.crs, null, null, null, null, null, null, null, null, null);
            this.outputGeometryFormModel.resetToDefaults(imageGeometry);
        }
    }

    private class OutputParamActionListener
    implements ActionListener {
        private OutputParamActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                Product sourceProduct = ReprojectionUI.this.getSourceProduct();
                if (sourceProduct == null) {
                    ReprojectionUI.this.showWarningMessage("Please select a product to reproject.\n");
                    return;
                }
                if (ReprojectionUI.this.crs == null) {
                    ReprojectionUI.this.showWarningMessage("Please specify a 'Coordinate Reference System' first.\n");
                    return;
                }
                OutputGeometryFormModel workCopy = ReprojectionUI.this.outputGeometryModel != null ? new OutputGeometryFormModel(ReprojectionUI.this.outputGeometryModel) : new OutputGeometryFormModel(sourceProduct, ReprojectionUI.this.crs);
                OutputGeometryForm form = new OutputGeometryForm(workCopy);
                OutputParametersDialog outputParametersDialog = new OutputParametersDialog(ReprojectionUI.this.appContext.getApplicationWindow(), sourceProduct, workCopy);
                outputParametersDialog.setContent((Component)form);
                if (outputParametersDialog.show() == 1) {
                    ReprojectionUI.this.outputGeometryModel = workCopy;
                    ReprojectionUI.this.updateProductSize();
                }
            }
            catch (Exception e) {
                ReprojectionUI.this.appContext.handleError("Could not create a 'Coordinate Reference System'.\n" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private class InfoForm {
        private JLabel widthLabel;
        private JLabel heightLabel;
        private JLabel centerLatLabel;
        private JLabel centerLonLabel;
        private JLabel crsLabel;
        private String wkt;
        private JButton wktButton;

        private InfoForm() {
        }

        void setWidth(int width) {
            this.widthLabel.setText(Integer.toString(width));
        }

        void setHeight(int height) {
            this.heightLabel.setText(Integer.toString(height));
        }

        void setCenterPos(GeoPos geoPos) {
            if (geoPos != null) {
                this.centerLatLabel.setText(geoPos.getLatString());
                this.centerLonLabel.setText(geoPos.getLonString());
            } else {
                this.centerLatLabel.setText("");
                this.centerLonLabel.setText("");
            }
        }

        void setCrsErrorText(String infoText) {
            this.setCrsInfoText("<html><b>" + infoText + "</b>", null);
        }

        void setCrsInfoText(String infoText, String wkt) {
            this.wkt = wkt;
            this.crsLabel.setText(infoText);
            boolean hasWKT = wkt != null;
            this.wktButton.setEnabled(hasWKT);
        }

        JPanel createUI() {
            this.widthLabel = new JLabel();
            this.heightLabel = new JLabel();
            this.centerLatLabel = new JLabel();
            this.centerLonLabel = new JLabel();
            this.crsLabel = new JLabel();
            TableLayout tableLayout = new TableLayout(5);
            tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
            tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
            tableLayout.setTablePadding(4, 4);
            tableLayout.setColumnWeightX(0, Double.valueOf(0.0));
            tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
            tableLayout.setColumnWeightX(2, Double.valueOf(1.0));
            tableLayout.setColumnWeightX(3, Double.valueOf(0.0));
            tableLayout.setColumnWeightX(4, Double.valueOf(1.0));
            tableLayout.setCellColspan(2, 1, Integer.valueOf(3));
            tableLayout.setCellPadding(0, 3, new Insets(4, 24, 4, 20));
            tableLayout.setCellPadding(1, 3, new Insets(4, 24, 4, 20));
            JPanel panel = new JPanel((LayoutManager)tableLayout);
            panel.setBorder(BorderFactory.createTitledBorder("Output Information"));
            panel.add(new JLabel("Scene width:"));
            panel.add(this.widthLabel);
            panel.add(new JLabel("pixel"));
            panel.add(new JLabel("Center longitude:"));
            panel.add(this.centerLonLabel);
            panel.add(new JLabel("Scene height:"));
            panel.add(this.heightLabel);
            panel.add(new JLabel("pixel"));
            panel.add(new JLabel("Center latitude:"));
            panel.add(this.centerLatLabel);
            panel.add(new JLabel("CRS:"));
            panel.add(this.crsLabel);
            this.wktButton = new JButton("Show WKT");
            this.wktButton.addActionListener(e -> {
                JTextArea wktArea = new JTextArea(30, 40);
                wktArea.setEditable(false);
                wktArea.setText(this.wkt);
                JScrollPane scrollPane = new JScrollPane(wktArea);
                ModalDialog dialog = new ModalDialog(ReprojectionUI.this.appContext.getApplicationWindow(), "Coordinate reference system as well known text", (Object)scrollPane, 1, null);
                dialog.show();
            });
            this.wktButton.setEnabled(false);
            panel.add(this.wktButton);
            return panel;
        }
    }
}

