/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;

class RasterStatistics {
    public static final String FILE_NAME = "sta.adf";
    private static final CompoundType TYPE = TypeBuilder.COMPOUND((String)"RasterStatistics", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"MIN", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"MAX", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"MEAN", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"STDDEV", (Type)TypeBuilder.DOUBLE)});
    final double min;
    final double max;
    final double mean;
    final double stddev;

    private RasterStatistics(double min, double max, double mean, double stddev) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.stddev = stddev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RasterStatistics create(File file) {
        DataContext context;
        DataFormat dataFormat = new DataFormat(TYPE, ByteOrder.BIG_ENDIAN);
        try {
            context = dataFormat.createContext(file, "r");
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
        CompoundData data = context.createData();
        try {
            RasterStatistics rasterStatistics = new RasterStatistics(data.getDouble(0), data.getDouble(1), data.getDouble(2), data.getDouble(3));
            return rasterStatistics;
        }
        catch (IOException ignore) {
            RasterStatistics rasterStatistics = null;
            return rasterStatistics;
        }
        finally {
            context.dispose();
        }
    }
}

