/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.arcbin.GeorefBounds;
import org.esa.snap.dataio.arcbin.Header;
import org.esa.snap.dataio.arcbin.RasterStatistics;

class MetaDataHandler {
    private MetaDataHandler() {
    }

    static MetadataElement createHeaderElement(Header header) {
        MetadataElement elem = new MetadataElement("Header");
        elem.addAttribute(MetaDataHandler.createIntAttr("cellType", header.cellType, "1 = int cover, 2 = float cover."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("pixelSizeX", header.pixelSizeX, "Width of a pixel in georeferenced coordinates."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("pixelSizeY", header.pixelSizeY, "Height of a pixel in georeferenced coordinates."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("xRef", header.xRef, null));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("yRef", header.yRef, null));
        elem.addAttribute(MetaDataHandler.createIntAttr("tilesPerRow", header.tilesPerRow, "The width of the file in tiles."));
        elem.addAttribute(MetaDataHandler.createIntAttr("tilesPerColumn", header.tilesPerColumn, "The height of the file in tiles. Note this may be much more than the number of tiles actually represented in the index file."));
        elem.addAttribute(MetaDataHandler.createIntAttr("tileXSize", header.tileXSize, "The width of a file in pixels. Normally 256."));
        elem.addAttribute(MetaDataHandler.createIntAttr("tileYSize", header.tileYSize, "Height of a tile in pixels, usually 4."));
        return elem;
    }

    static MetadataElement createGeorefBoundsElement(GeorefBounds georefBounds) {
        MetadataElement elem = new MetadataElement("GeorefBounds");
        elem.addAttribute(MetaDataHandler.createDoubleAttr("llx", georefBounds.lowerLeftX, "Lower left X (easting) of the grid."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("lly", georefBounds.lowerLeftY, "Lower left Y (northing) of the grid."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("urx", georefBounds.upperRightX, "Upper right X (northing) of the grid."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("ury", georefBounds.upperRightY, "Upper right Y (northing) of the grid."));
        return elem;
    }

    static MetadataElement createRasterStatisticsElement(RasterStatistics rasterStat) {
        MetadataElement elem = new MetadataElement("RasterStatistics");
        elem.addAttribute(MetaDataHandler.createDoubleAttr("min", rasterStat.min, "Minimum value of a raster cell in this grid."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("max", rasterStat.max, "Maximum value of a raster cell in this grid."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("mean", rasterStat.mean, "Mean value of a raster cells in this grid."));
        elem.addAttribute(MetaDataHandler.createDoubleAttr("stddev", rasterStat.stddev, "Standard deviation of raster cells in this grid."));
        return elem;
    }

    static MetadataAttribute createIntAttr(String name, int value, String desc) {
        ProductData productData = ProductData.createInstance((int[])new int[]{value});
        MetadataAttribute attribute = new MetadataAttribute(name, productData, true);
        if (desc != null) {
            attribute.setDescription(desc);
        }
        return attribute;
    }

    static MetadataAttribute createDoubleAttr(String name, double value, String desc) {
        ProductData productData = ProductData.createInstance((double[])new double[]{value});
        MetadataAttribute attribute = new MetadataAttribute(name, productData, true);
        if (desc != null) {
            attribute.setDescription(desc);
        }
        return attribute;
    }
}

