/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import com.bc.ceres.binio.util.ByteArrayCodec;
import java.awt.image.DataBuffer;
import java.nio.ByteOrder;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.arcbin.GridTileProvider;
import org.esa.snap.dataio.arcbin.RasterDataFile;
import org.esa.snap.dataio.arcbin.TileIndex;

class FloatGridTileProvider
implements GridTileProvider {
    private static final ByteArrayCodec byteArrayCodec = ByteArrayCodec.getInstance((ByteOrder)ByteOrder.BIG_ENDIAN);
    private final RasterDataFile rasterDataFile;
    private final TileIndex tileIndex;
    private final float nodataValue;
    private final int size;
    private final int productDataType;

    FloatGridTileProvider(RasterDataFile rasterDataFile, TileIndex tileIndex, float nodataValue, int size, int productDataType) {
        this.rasterDataFile = rasterDataFile;
        this.tileIndex = tileIndex;
        this.nodataValue = nodataValue;
        this.size = size;
        this.productDataType = productDataType;
    }

    @Override
    public ProductData getData(int currentTileIndex) {
        ProductData data = ProductData.createInstance((int)this.productDataType, (int)this.size);
        TileIndex.IndexEntry indexEntry = this.tileIndex.getIndexEntry(currentTileIndex);
        if (indexEntry == null) {
            this.fillBuffer(data, this.nodataValue);
        } else {
            try {
                byte[] rawTileData = this.rasterDataFile.loadRawTileData(indexEntry);
                int tileOffset = 2;
                for (int i = 0; i < this.size; ++i) {
                    float value = byteArrayCodec.getFloat(rawTileData, tileOffset);
                    tileOffset += 4;
                    data.setElemFloatAt(i, value);
                }
            }
            catch (Exception ignored) {
                this.fillBuffer(data, this.nodataValue);
            }
        }
        return data;
    }

    @Override
    public void transferData(ProductData data, int sourceIndex, DataBuffer dataBuffer, int targetIndex) {
        float value = data.getElemFloatAt(sourceIndex);
        dataBuffer.setElemFloat(targetIndex, value);
    }

    private void fillBuffer(ProductData data, float value) {
        for (int i = 0; i < this.size; ++i) {
            data.setElemFloatAt(i, value);
        }
    }
}

