/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

public interface DoubleList {
    public int getSize();

    public double getDouble(int var1);

    public static class Double
    implements DoubleList {
        private final double[] _array;

        public Double(double[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }

    public static class Float
    implements DoubleList {
        private final float[] _array;

        public Float(float[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }

    public static class ULong
    implements DoubleList {
        private final long[] _array;

        public ULong(long[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }

    public static class Long
    implements DoubleList {
        private final long[] _array;

        public Long(long[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }

    public static class UInt
    implements DoubleList {
        private final int[] _array;

        public UInt(int[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return (long)this._array[index] & 0xFFFFFFFFL;
        }
    }

    public static class Int
    implements DoubleList {
        private final int[] _array;

        public Int(int[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }

    public static class UShort
    implements DoubleList {
        private final short[] _array;

        public UShort(short[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index] & 0xFFFF;
        }
    }

    public static class Short
    implements DoubleList {
        private final short[] _array;

        public Short(short[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }

    public static class UByte
    implements DoubleList {
        private final byte[] _array;

        public UByte(byte[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index] & 0xFF;
        }
    }

    public static class Byte
    implements DoubleList {
        private final byte[] _array;

        public Byte(byte[] array) {
            this._array = array;
        }

        @Override
        public final int getSize() {
            return this._array.length;
        }

        @Override
        public final double getDouble(int index) {
            return this._array[index];
        }
    }
}

