/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.DistanceMeasure;

public final class CosineDistance
implements DistanceMeasure {
    private final double lon;
    private final double si;
    private final double co;

    public CosineDistance(double lon, double lat) {
        this.lon = lon;
        this.si = Math.sin(Math.toRadians(lat));
        this.co = Math.cos(Math.toRadians(lat));
    }

    @Override
    public double distance(double lon, double lat) {
        double phi = Math.toRadians(lat);
        double cos = this.si * Math.sin(phi) + this.co * Math.cos(phi) * Math.cos(Math.toRadians(lon - this.lon));
        return 1.0 - cos;
    }
}

