/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

public interface Array {
    public int getLength();

    public double getValue(int var1);

    public void copyTo(int var1, double[] var2, int var3, int var4);

    public static class Float
    implements Array {
        private final float[] values;

        public Float(float ... values) {
            if (values == null) {
                throw new IllegalArgumentException("values == null");
            }
            this.values = values;
        }

        @Override
        public final int getLength() {
            return this.values.length;
        }

        @Override
        public final double getValue(int i) {
            return this.values[i];
        }

        @Override
        public final void copyTo(int srcPos, double[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = this.values[srcPos + i];
            }
        }
    }

    public static class Double
    implements Array {
        private final double[] values;

        public Double(double ... values) {
            if (values == null) {
                throw new NullPointerException("values == null");
            }
            this.values = values;
        }

        @Override
        public final int getLength() {
            return this.values.length;
        }

        @Override
        public final double getValue(int i) {
            return this.values[i];
        }

        @Override
        public final void copyTo(int srcPos, double[] dest, int destPos, int length) {
            System.arraycopy(this.values, srcPos, dest, destPos, length);
        }
    }
}

