/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.kmz;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.util.kmz.ExtendedData;

public abstract class KmlFeature {
    private String kmlElementName;
    private final String name;
    private final String description;
    private ExtendedData extendedData;

    protected KmlFeature(String kmlElementName, String name, String description) {
        Assert.notNull((Object)kmlElementName, (String)"xmlTagName");
        Assert.notNull((Object)name, (String)"name");
        this.kmlElementName = kmlElementName;
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setExtendedData(ExtendedData extendedData) {
        this.extendedData = extendedData;
    }

    public final void createKml(StringBuilder sb) {
        sb.append("<").append(this.kmlElementName).append(">");
        sb.append("<name>");
        sb.append(this.getName());
        sb.append("</name>");
        String description = this.getDescription();
        if (description != null && !description.isEmpty()) {
            sb.append("<description>");
            sb.append(description);
            sb.append("</description>");
        }
        this.createKmlSpecifics(sb);
        this.addExtendedData(sb, this.extendedData);
        sb.append("</").append(this.kmlElementName).append(">");
    }

    private void addExtendedData(StringBuilder sb, ExtendedData extendedData) {
        if (extendedData != null) {
            extendedData.createKml(sb);
        }
    }

    protected abstract void createKmlSpecifics(StringBuilder var1);
}

