/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.geotiff;

import java.awt.geom.AffineTransform;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.geotools.coverage.grid.io.imageio.geotiff.CRS2GeoTiffMetadataAdapter;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoKeyEntry;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataEncoder;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GeoCoding2GeoTIFFMetadata {
    private GeoCoding2GeoTIFFMetadata() {
    }

    public static GeoTIFFMetadata createGeoTIFFMetadata(GeoCoding geoCoding, int width, int height) {
        GeoTIFFMetadata metadata = null;
        if (geoCoding instanceof CrsGeoCoding || geoCoding instanceof MapGeoCoding) {
            metadata = GeoCoding2GeoTIFFMetadata.createProjectedGeoTIFFMetadata(geoCoding.getMapCRS(), geoCoding.getImageToMapTransform());
        } else if (geoCoding != null) {
            metadata = GeoCoding2GeoTIFFMetadata.createFallbackGeoTIFFMetada(geoCoding, width, height);
        }
        return metadata;
    }

    public static GeoTIFFMetadata createProjectedGeoTIFFMetadata(CoordinateReferenceSystem mapCRS, MathTransform imageToMapTransform) {
        GeoTIFFMetadata metadata = new GeoTIFFMetadata();
        try {
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)mapCRS, (boolean)true);
            if (epsgCode != null) {
                mapCRS = CRS.decode((String)("EPSG:" + epsgCode));
            }
            CRS2GeoTiffMetadataAdapter metadataAdapter = new CRS2GeoTiffMetadataAdapter(mapCRS);
            GeoTiffIIOMetadataEncoder encoder = metadataAdapter.parseCoordinateReferenceSystem();
            int numGeoKeyEntries = encoder.getNumGeoKeyEntries();
            for (int i = 1; i < numGeoKeyEntries; ++i) {
                GeoKeyEntry entry = encoder.getGeoKeyEntryAt(i);
                int id = entry.getKeyID();
                if (entry.getTiffTagLocation() == 34737) {
                    metadata.addGeoAscii(id, encoder.getGeoAsciiParam(id));
                    continue;
                }
                if (entry.getTiffTagLocation() == 34736) {
                    if (entry.getCount() > 1) {
                        double[] doubles = encoder.getGeoDoubleParams(id);
                        metadata.addGeoDoubleParams(id, doubles);
                        continue;
                    }
                    double value = encoder.getGeoDoubleParam(id);
                    metadata.addGeoDoubleParam(id, value);
                    continue;
                }
                int value = encoder.getGeoShortParam(id);
                metadata.addGeoShortParam(id, value);
            }
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        catch (GeoTiffException e) {
            e.printStackTrace();
        }
        if (!metadata.hasGeoKeyEntry(3073)) {
            metadata.addGeoAscii(3073, mapCRS.getName().getCode());
        }
        if (imageToMapTransform instanceof AffineTransform) {
            AffineTransform transform = (AffineTransform)imageToMapTransform;
            double[] transformationMatrix = new double[16];
            transformationMatrix[0] = transform.getScaleX();
            transformationMatrix[1] = transform.getShearX();
            transformationMatrix[3] = transform.getTranslateX();
            transformationMatrix[4] = transform.getShearY();
            transformationMatrix[5] = transform.getScaleY();
            transformationMatrix[7] = transform.getTranslateY();
            transformationMatrix[15] = 1.0;
            metadata.setModelTransformation(transformationMatrix);
        }
        metadata.addGeoShortParam(1025, 1);
        metadata.addGeoAscii(1026, mapCRS.getName().getCode());
        return metadata;
    }

    public static GeoTIFFMetadata createFallbackGeoTIFFMetada(GeoCoding geoCoding, int width, int height) {
        int numVer;
        GeoTIFFMetadata metadata = new GeoTIFFMetadata();
        metadata.addGeoShortParam(1024, 2);
        metadata.addGeoShortParam(1025, 1);
        metadata.addGeoShortParam(2048, 4326);
        int numTotMax = 128;
        int numHor = (int)Math.sqrt(128.0 * ((double)width / (double)height));
        if (numHor < 2) {
            numHor = 2;
        }
        if ((numVer = 128 / numHor) < 2) {
            numVer = 2;
        }
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos();
        for (int y = 0; y < numVer; ++y) {
            for (int x = 0; x < numHor; ++x) {
                pixelPos.setLocation((double)(width - 1) * (double)x / (double)((float)numHor - 1.0f) + 0.5, (double)(height - 1) * (double)y / (double)((float)numVer - 1.0f) + 0.5);
                geoCoding.getGeoPos(pixelPos, geoPos);
                metadata.addModelTiePoint(pixelPos.x, pixelPos.y, geoPos.lon, geoPos.lat);
            }
        }
        GeoPos geoPos1 = geoCoding.getGeoPos(new PixelPos(0.5, 0.5), null);
        GeoPos geoPos2 = geoCoding.getGeoPos(new PixelPos(1.5, 1.5), null);
        double scaleX = Math.abs(geoPos2.lon - geoPos1.lon);
        double scaleY = Math.abs(geoPos2.lat - geoPos1.lat);
        metadata.setModelPixelScale(scaleX, scaleY);
        return metadata;
    }
}

