/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.Assert;
import java.util.LinkedList;
import java.util.List;

public class TreeNode<T> {
    private TreeNode<T> parent;
    private final String id;
    private T content;
    private List<TreeNode<T>> children;

    public TreeNode(String id) {
        Assert.notNull((Object)id, (String)"id");
        this.id = id;
        this.children = new LinkedList<TreeNode<T>>();
    }

    public TreeNode(String id, T content) {
        this(id);
        this.content = content;
    }

    public TreeNode<T> getRoot() {
        TreeNode<T> node = this;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node;
    }

    public String getAbsolutePath() {
        StringBuilder path = new StringBuilder(32);
        TreeNode<T> node = this;
        while (node.getParent() != null) {
            path.insert(0, "/");
            path.insert(0, node.getId());
            node = node.getParent();
        }
        return path.toString();
    }

    public String getId() {
        return this.id;
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public TreeNode<T> getChild(String path) {
        return this.getChildForPath(path, false);
    }

    public TreeNode<T> createChild(String path) {
        return this.getChildForPath(path, true);
    }

    public void addChild(TreeNode<T> child) {
        Assert.notNull(child, (String)"child");
        if (this.children == null) {
            this.children = new LinkedList<TreeNode<T>>();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public boolean removeChild(TreeNode<T> child) {
        Assert.notNull(child, (String)"child");
        boolean suceess = false;
        if (this.children != null && (suceess = this.children.remove(child))) {
            child.setParent(null);
        }
        return suceess;
    }

    public TreeNode<T>[] getChildren() {
        if (this.children != null) {
            return this.children.toArray(new TreeNode[this.children.size()]);
        }
        return new TreeNode[0];
    }

    private TreeNode<T> getChildForPath(String path, boolean create) {
        int separatorPos = path.indexOf(47);
        if (separatorPos == -1) {
            return this.getChildForId(path, create);
        }
        if (separatorPos == 0) {
            return super.getChildForPath(path.substring(1), create);
        }
        String id = path.substring(0, separatorPos);
        TreeNode<T> child = this.getChildForId(id, create);
        if (child != null) {
            String remainingPath = path.substring(separatorPos + 1);
            if (remainingPath.equals("")) {
                return child;
            }
            return super.getChildForPath(remainingPath, create);
        }
        return null;
    }

    private TreeNode<T> getChildForId(String id, boolean create) {
        if (id.equals("") || id.equals(".")) {
            return this;
        }
        if (id.equals("..")) {
            return this.getParent();
        }
        if (this.children != null) {
            for (TreeNode<T> child : this.children) {
                if (!child.getId().equals(id)) continue;
                return child;
            }
        }
        if (create) {
            TreeNode<T> proxyChild = new TreeNode<T>(id);
            this.addChild(proxyChild);
            return proxyChild;
        }
        return null;
    }
}

