/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

public class ImageUtils {
    public static BufferedImage convertImage(RenderedImage image, int imageType) {
        BufferedImage newImage;
        int width = image.getWidth();
        int height = image.getHeight();
        if (imageType != 0) {
            newImage = new BufferedImage(width, height, imageType);
        } else {
            ColorSpace cs = ColorSpace.getInstance(1000);
            ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
            WritableRaster wr = Raster.createInterleavedRaster(0, width, height, 3 * width, 3, new int[]{2, 1, 0}, null);
            newImage = new BufferedImage(cm, wr, false, null);
        }
        Graphics2D graphics = newImage.createGraphics();
        graphics.drawRenderedImage(image, null);
        graphics.dispose();
        return newImage;
    }

    public static double[] getDataTypeMinMax(int dataType, double[] minmax) {
        if (minmax == null) {
            minmax = new double[2];
        }
        if (dataType == 0 || dataType == 3) {
            minmax[0] = 0.0;
            minmax[1] = 255.0;
        } else if (dataType == 2) {
            minmax[0] = -32768.0;
            minmax[1] = 32767.0;
        } else if (dataType == 1) {
            minmax[0] = 0.0;
            minmax[1] = 65533.0;
        } else {
            minmax[0] = 0.0;
            minmax[1] = 1.0;
        }
        return minmax;
    }

    public static String getDataTypeName(int dataType) {
        switch (dataType) {
            case 0: {
                return "DataBuffer.TYPE_BYTE";
            }
            case 2: {
                return "DataBuffer.TYPE_SHORT";
            }
            case 1: {
                return "DataBuffer.TYPE_USHORT";
            }
            case 3: {
                return "DataBuffer.TYPE_INT";
            }
            case 4: {
                return "DataBuffer.TYPE_FLOAT";
            }
            case 5: {
                return "DataBuffer.TYPE_DOUBLE";
            }
            case 32: {
                return "DataBuffer.TYPE_UNDEFINED";
            }
        }
        return "DataBuffer.TYPE_<?>";
    }

    public static String getColorSpaceName(int spaceType) {
        switch (spaceType) {
            case 0: {
                return "ColorSpace.TYPE_XYZ";
            }
            case 1: {
                return "ColorSpace.TYPE_Lab";
            }
            case 2: {
                return "ColorSpace.TYPE_Luv";
            }
            case 3: {
                return "ColorSpace.TYPE_YCbCr";
            }
            case 4: {
                return "ColorSpace.TYPE_Yxy";
            }
            case 5: {
                return "ColorSpace.TYPE_RGB";
            }
            case 6: {
                return "ColorSpace.TYPE_GRAY";
            }
            case 7: {
                return "ColorSpace.TYPE_HSV";
            }
            case 8: {
                return "ColorSpace.TYPE_HLS";
            }
            case 9: {
                return "ColorSpace.TYPE_CMYK";
            }
            case 11: {
                return "ColorSpace.TYPE_CMY";
            }
            case 12: {
                return "ColorSpace.TYPE_2CLR";
            }
            case 13: {
                return "ColorSpace.TYPE_3CLR";
            }
            case 14: {
                return "ColorSpace.TYPE_4CLR";
            }
            case 15: {
                return "ColorSpace.TYPE_5CLR";
            }
            case 16: {
                return "ColorSpace.TYPE_6CLR";
            }
            case 17: {
                return "ColorSpace.TYPE_7CLR";
            }
            case 18: {
                return "ColorSpace.TYPE_8CLR";
            }
            case 19: {
                return "ColorSpace.TYPE_9CLR";
            }
            case 20: {
                return "ColorSpace.TYPE_ACLR";
            }
            case 21: {
                return "ColorSpace.TYPE_BCLR";
            }
            case 22: {
                return "ColorSpace.TYPE_CCLR";
            }
            case 23: {
                return "ColorSpace.TYPE_DCLR";
            }
            case 24: {
                return "ColorSpace.TYPE_ECLR";
            }
            case 25: {
                return "ColorSpace.TYPE_FCLR";
            }
        }
        return "ColorSpace.TYPE_<?>";
    }

    public static BufferedImage createGreyscaleColorModelImage(int width, int height, byte[] data) {
        ColorModel cm = ImageUtils.create8BitGreyscaleColorModel();
        DataBufferByte db = new DataBufferByte(data, data.length);
        WritableRaster wr = WritableRaster.createBandedRaster(db, width, height, width, new int[]{0}, new int[]{0}, null);
        return new BufferedImage(cm, wr, false, null);
    }

    public static BufferedImage createIndexedImage(int width, int height, byte[] data, IndexColorModel cm) {
        int numSamples = data.length;
        SampleModel sm = cm.createCompatibleSampleModel(width, height);
        DataBufferByte db = new DataBufferByte(data, numSamples);
        WritableRaster wr = WritableRaster.createWritableRaster(sm, db, null);
        return new BufferedImage(cm, wr, false, null);
    }

    public static ColorModel create8BitGreyscaleColorModel() {
        ColorSpace cs = ColorSpace.getInstance(1003);
        return new ComponentColorModel(cs, new int[]{8}, false, false, 1, 0);
    }

    public static Object getPrimitiveArray(DataBuffer dataBuffer) {
        switch (dataBuffer.getDataType()) {
            case 0: {
                return ((DataBufferByte)dataBuffer).getData();
            }
            case 2: {
                return ((DataBufferShort)dataBuffer).getData();
            }
            case 1: {
                return ((DataBufferUShort)dataBuffer).getData();
            }
            case 3: {
                return ((DataBufferInt)dataBuffer).getData();
            }
            case 4: {
                return ((DataBufferFloat)dataBuffer).getData();
            }
            case 5: {
                return ((DataBufferDouble)dataBuffer).getData();
            }
        }
        throw new IllegalArgumentException("dataBuffer");
    }

    public static Object createDataBufferArray(int dataBufferType, int size) {
        switch (dataBufferType) {
            case 0: {
                return new byte[size];
            }
            case 1: 
            case 2: {
                return new short[size];
            }
            case 3: {
                return new int[size];
            }
            case 4: {
                return new float[size];
            }
            case 5: {
                return new double[size];
            }
        }
        throw new IllegalArgumentException("dataBuffer");
    }

    public static SampleModel createSingleBandedSampleModel(int dataBufferType, int width, int height) {
        return new SingleBandedSampleModel(dataBufferType, width, height);
    }

    public static RenderedImage createRenderedImage(int width, int height, ProductData data) {
        DataBuffer db;
        int dataBufferType = ImageManager.getDataBufferType(data.getType());
        if (dataBufferType == 0) {
            db = new DataBufferByte((byte[])data.getElems(), data.getNumElems());
        } else if (dataBufferType == 1) {
            db = new DataBufferUShort((short[])data.getElems(), data.getNumElems());
        } else if (dataBufferType == 2) {
            db = new DataBufferShort((short[])data.getElems(), data.getNumElems());
        } else if (dataBufferType == 3) {
            db = new DataBufferInt((int[])data.getElems(), data.getNumElems());
        } else if (dataBufferType == 4) {
            db = new DataBufferFloat((float[])data.getElems(), data.getNumElems());
        } else if (dataBufferType == 5) {
            db = new DataBufferDouble((double[])data.getElems(), data.getNumElems());
        } else {
            throw new IllegalStateException("illegal image data buffer type: " + dataBufferType);
        }
        SampleModel sampleModel = ImageUtils.createSingleBandedSampleModel(dataBufferType, width, height);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, db, new Point(0, 0));
        return new MyRenderedImage(raster, colorModel);
    }

    private static class MyRenderedImage
    implements RenderedImage {
        private final WritableRaster raster;
        private final ColorModel colorModel;

        public MyRenderedImage(WritableRaster raster, ColorModel colorModel) {
            this.raster = raster;
            this.colorModel = colorModel;
        }

        @Override
        public Vector<RenderedImage> getSources() {
            return null;
        }

        @Override
        public Object getProperty(String name) {
            return null;
        }

        @Override
        public String[] getPropertyNames() {
            return new String[0];
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public SampleModel getSampleModel() {
            return this.raster.getSampleModel();
        }

        @Override
        public int getWidth() {
            return this.raster.getWidth();
        }

        @Override
        public int getHeight() {
            return this.raster.getHeight();
        }

        @Override
        public int getMinX() {
            return 0;
        }

        @Override
        public int getMinY() {
            return 0;
        }

        @Override
        public int getNumXTiles() {
            return 1;
        }

        @Override
        public int getNumYTiles() {
            return 1;
        }

        @Override
        public int getMinTileX() {
            return 0;
        }

        @Override
        public int getMinTileY() {
            return 0;
        }

        @Override
        public int getTileWidth() {
            return this.getWidth();
        }

        @Override
        public int getTileHeight() {
            return this.getHeight();
        }

        @Override
        public int getTileGridXOffset() {
            return 0;
        }

        @Override
        public int getTileGridYOffset() {
            return 0;
        }

        @Override
        public Raster getTile(int tileX, int tileY) {
            return this.raster;
        }

        @Override
        public Raster getData() {
            return this.raster;
        }

        @Override
        public Raster getData(Rectangle rect) {
            SampleModel sm = this.raster.getSampleModel();
            SampleModel nsm = sm.createCompatibleSampleModel(rect.width, rect.height);
            WritableRaster wr = Raster.createWritableRaster(nsm, rect.getLocation());
            int width = rect.width;
            int height = rect.height;
            int startX = rect.x;
            int startY = rect.y;
            return MyRenderedImage.copyData(this.raster, startX, startY, width, height, wr);
        }

        @Override
        public WritableRaster copyData(WritableRaster outRaster) {
            if (outRaster == null) {
                return (WritableRaster)this.getData();
            }
            int width = outRaster.getWidth();
            int height = outRaster.getHeight();
            int startX = outRaster.getMinX();
            int startY = outRaster.getMinY();
            return MyRenderedImage.copyData(this.raster, startX, startY, width, height, outRaster);
        }

        private static WritableRaster copyData(WritableRaster raster, int startX, int startY, int width, int height, WritableRaster outRaster) {
            Object tdata = null;
            for (int i = startY; i < startY + height; ++i) {
                tdata = raster.getDataElements(startX, i, width, 1, tdata);
                outRaster.setDataElements(startX, i, width, 1, tdata);
            }
            return outRaster;
        }
    }
}

