/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.param.editors;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.param.AbstractParamXEditor;
import org.esa.snap.core.param.Parameter;

public abstract class TextFieldXEditor
extends AbstractParamXEditor {
    private JTextComponent _textComponent;
    private JComponent _component;

    public TextFieldXEditor(Parameter parameter) {
        super(parameter, true);
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    @Override
    public JComponent getEditorComponentChild() {
        return this._component;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        String text = this.getParameter().getValueAsText();
        JTextComponent textField = this.getTextComponent();
        if (!textField.getText().equals(text)) {
            textField.setText(text);
        }
        if (textField.isEnabled() != this.isEnabled()) {
            textField.setEnabled(this.isEnabled());
        }
    }

    @Override
    protected void initUIChild() {
        JTextComponent textComponent;
        int numCols = this.getParameter().getProperties().getNumCols();
        int numRows = this.getParameter().getProperties().getNumRows();
        if (numRows <= 1) {
            textComponent = new JTextField();
            this.nameEditorComponent(textComponent);
            if (numCols <= 0) {
                ((JTextField)textComponent).setColumns(24);
            } else {
                ((JTextField)textComponent).setColumns(numCols);
            }
            ((JTextField)textComponent).addActionListener(this.getDefaultActionListener());
            this.setTextComponent(textComponent);
        } else {
            textComponent = new JTextArea();
            this.nameEditorComponent(textComponent);
            ((JTextArea)textComponent).setRows(numRows);
            if (numCols > 0) {
                ((JTextArea)textComponent).setColumns(numCols);
            }
            ((JTextArea)textComponent).setLineWrap(true);
            ((JTextArea)textComponent).setWrapStyleWord(true);
            textComponent.setBorder(new EtchedBorder(1));
            this.setTextComponent(textComponent);
        }
        boolean enabled = !this.getParameter().getProperties().isReadOnly();
        this._textComponent.setEnabled(enabled);
        this._component.setEnabled(enabled);
        String toolTiptext = this.getParameter().getProperties().getDescription();
        this._textComponent.setText(this.getParameter().getValueAsText());
        this._textComponent.setToolTipText(toolTiptext);
        this._textComponent.setInputVerifier(this.getDefaultInputVerifier());
    }

    private void setTextComponent(JTextComponent textComponent) {
        this._textComponent = textComponent;
        if (this._textComponent instanceof JTextArea) {
            this._textComponent.setBorder(null);
            this._component = new JScrollPane(this._textComponent);
            this.nameComponent(textComponent, "ScrollPane");
        } else {
            this._component = this._textComponent;
        }
    }
}

