/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.nn;

import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;

class FormattedStringReader {
    private StringReader inp;
    private String delimiters;
    private boolean file_has_comments;
    private boolean echo_comments;
    private String comment_begin;

    public FormattedStringReader(StringReader inp) {
        this(inp, " \t\n\r,;:");
    }

    public FormattedStringReader(StringReader inp, String delimiters) {
        this.inp = inp;
        this.delimiters = delimiters;
        this.file_has_comments = true;
        this.echo_comments = false;
        this.comment_begin = "#";
    }

    public void commentStart(String comment_begin) {
        this.comment_begin = comment_begin;
        this.file_has_comments = true;
    }

    public void noComments() {
        this.file_has_comments = false;
    }

    public void setEcho(boolean echo_comments) {
        this.echo_comments = echo_comments;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    private static String readLine(StringReader sr) throws IOException {
        String res = "";
        char[] helper = new char[1];
        int readCount = 0;
        while (helper[0] != '\n' && (readCount = sr.read(helper, 0, 1)) != -1) {
            res = res.concat(String.copyValueOf(helper));
        }
        return res.trim();
    }

    public long rlong() throws IOException {
        boolean ready = false;
        long res = 0L;
        while (!ready) {
            String eing = FormattedStringReader.readLine(this.inp);
            if (this.file_has_comments && eing.startsWith(this.comment_begin)) {
                if (!this.echo_comments) continue;
                System.out.println(eing);
                continue;
            }
            StringTokenizer st = new StringTokenizer(eing, this.delimiters);
            res = Long.parseLong(st.nextToken());
            ready = true;
        }
        return res;
    }

    public double rdouble() throws IOException {
        boolean ready = false;
        double res = 0.0;
        while (!ready) {
            String eing = FormattedStringReader.readLine(this.inp);
            if (this.file_has_comments && eing.startsWith(this.comment_begin)) {
                if (!this.echo_comments) continue;
                System.out.println(eing);
                continue;
            }
            StringTokenizer st = new StringTokenizer(eing, this.delimiters);
            res = Double.valueOf(st.nextToken());
            ready = true;
        }
        return res;
    }

    public String rString() throws IOException {
        String eing = null;
        boolean ready = false;
        while (!ready) {
            eing = FormattedStringReader.readLine(this.inp);
            if (this.file_has_comments && eing.startsWith(this.comment_begin)) {
                if (!this.echo_comments) continue;
                System.out.println(eing);
                continue;
            }
            ready = true;
        }
        return eing;
    }

    public long[] rlong(int how_many) throws IOException {
        boolean ready = false;
        long[] res = new long[how_many];
        int got = 0;
        block0: while (!ready) {
            String eing = FormattedStringReader.readLine(this.inp);
            if (this.file_has_comments && eing.startsWith(this.comment_begin)) {
                if (!this.echo_comments) continue;
                System.out.println(eing);
                continue;
            }
            StringTokenizer st = new StringTokenizer(eing, this.delimiters);
            int nn = st.countTokens();
            for (int i = 0; i < nn; ++i) {
                res[got] = Long.parseLong(st.nextToken());
                if (++got != how_many) continue;
                ready = true;
                continue block0;
            }
        }
        if (got == how_many) {
            return res;
        }
        long[] less = new long[got];
        System.arraycopy(res, 0, less, 0, got);
        return less;
    }

    public double[] rdouble(int how_many) throws IOException {
        boolean ready = false;
        double[] res = new double[how_many];
        int got = 0;
        block0: while (!ready) {
            String eing = FormattedStringReader.readLine(this.inp);
            if (this.file_has_comments && eing.startsWith(this.comment_begin)) {
                if (!this.echo_comments) continue;
                System.out.println(eing);
                continue;
            }
            StringTokenizer st = new StringTokenizer(eing, this.delimiters);
            int nn = st.countTokens();
            if (nn == 0) break;
            for (int i = 0; i < nn; ++i) {
                res[got] = Double.valueOf(st.nextToken());
                if (++got != how_many) continue;
                ready = true;
                continue block0;
            }
        }
        if (got == how_many) {
            return res;
        }
        double[] less = new double[got];
        System.arraycopy(res, 0, less, 0, got);
        return less;
    }

    public double[][] rdoubleAll(int dimension) throws IOException {
        double[] p;
        int npoints = 0;
        this.inp.mark(100000000);
        while ((p = this.rdouble(dimension)).length >= dimension) {
            ++npoints;
        }
        this.inp.reset();
        double[][] points = new double[npoints][];
        for (int i = 0; i < npoints; ++i) {
            points[i] = this.rdouble(dimension);
        }
        return points;
    }

    public double[][] rdoubleAll() throws IOException {
        this.inp.mark(100000000);
        String eing = this.rString();
        this.inp.reset();
        StringTokenizer st = new StringTokenizer(eing, this.delimiters);
        return this.rdoubleAll(st.countTokens());
    }
}

