/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ColoredBandImageMultiLevelSource;

@LayerTypeMetadata(name="RasterImageLayerType", aliasNames={"org.esa.snap.core.layer.RasterImageLayerType"})
public class RasterImageLayerType
extends ImageLayer.Type {
    public static final String PROPERTY_NAME_RASTER = "raster";

    public ImageLayer createLayer(LayerContext ctx, PropertySet configuration) {
        Object multiLevelSource = (MultiLevelSource)configuration.getValue("multiLevelSource");
        if (multiLevelSource == null) {
            RasterDataNode raster = (RasterDataNode)configuration.getValue(PROPERTY_NAME_RASTER);
            multiLevelSource = ColoredBandImageMultiLevelSource.create(raster, ProgressMonitor.NULL);
            configuration.setValue("multiLevelSource", multiLevelSource);
        }
        return new ImageLayer((ImageLayer.Type)this, multiLevelSource, configuration);
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertySet template = super.createLayerConfig(ctx);
        template.addProperty(Property.create((String)PROPERTY_NAME_RASTER, RasterDataNode.class));
        template.getDescriptor(PROPERTY_NAME_RASTER).setItemAlias(PROPERTY_NAME_RASTER);
        template.getDescriptor(PROPERTY_NAME_RASTER).setNotNull(true);
        return template;
    }

    public Layer createLayer(RasterDataNode raster, MultiLevelSource multiLevelSource) {
        PropertySet configuration = this.createLayerConfig(null);
        configuration.setValue(PROPERTY_NAME_RASTER, (Object)raster);
        if (multiLevelSource == null) {
            multiLevelSource = ColoredBandImageMultiLevelSource.create(raster, ProgressMonitor.NULL);
        }
        configuration.setValue("multiLevelSource", multiLevelSource);
        return this.createLayer(null, configuration);
    }
}

