/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.layer;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.layer.MaskCollectionLayerType;
import org.esa.snap.core.layer.MaskLayerType;

public class MaskCollectionLayer
extends CollectionLayer {
    public static final String ID = MaskCollectionLayer.class.getName();
    private final ProductNodeListener maskPNL;
    private RasterDataNode raster;

    public MaskCollectionLayer(MaskCollectionLayerType layerType, RasterDataNode raster, PropertySet configuration) {
        super((CollectionLayer.Type)layerType, configuration, "Masks");
        Assert.notNull((Object)raster, (String)"raster");
        this.raster = raster;
        this.maskPNL = new MaskPNL();
        this.setId(ID);
        this.getProduct().addProductNodeListener(this.maskPNL);
        this.addListener((LayerListener)new VisibilityLL());
    }

    public void disposeLayer() {
        if (this.raster != null) {
            this.raster.getProduct().removeProductNodeListener(this.maskPNL);
            this.raster = null;
        }
    }

    private Product getProduct() {
        return this.raster.getProduct();
    }

    private RasterDataNode getRaster() {
        return this.raster;
    }

    private Layer createLayer(Mask mask) {
        return MaskLayerType.createLayer(this.getRaster(), mask);
    }

    private ImageLayer getMaskLayer(Mask mask) {
        LayerFilter layerFilter = layer -> layer instanceof ImageLayer && mask == layer.getConfiguration().getValue("mask");
        return (ImageLayer)LayerUtils.getChildLayer((Layer)LayerUtils.getRootLayer((Layer)this), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)layerFilter);
    }

    private synchronized void updateChildren() {
        LayerFilter layerFilter = layer -> {
            PropertySet conf = layer.getConfiguration();
            return conf.isPropertyDefined("mask") && conf.getValue("mask") != null;
        };
        List maskLayers = LayerUtils.getChildLayers((Layer)LayerUtils.getRootLayer((Layer)this), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)layerFilter);
        HashMap<Mask, Layer> currentLayers = new HashMap<Mask, Layer>();
        for (Layer maskLayer : maskLayers) {
            Mask mask = (Mask)maskLayer.getConfiguration().getValue("mask");
            currentLayers.put(mask, maskLayer);
        }
        if (this.raster != null && this.getProduct() != null) {
            Mask[] availableMasks = (Mask[])this.getProduct().getMaskGroup().toArray(new Mask[0]);
            HashSet unusedLayers = new HashSet(maskLayers);
            for (Mask availableMask : availableMasks) {
                if (!this.raster.getRasterSize().equals(availableMask.getRasterSize())) continue;
                Layer layer2 = (Layer)currentLayers.get(availableMask);
                if (layer2 != null) {
                    unusedLayers.remove(layer2);
                } else {
                    layer2 = this.createLayer(availableMask);
                    this.getChildren().add(layer2);
                }
                layer2.setVisible(this.raster.getOverlayMaskGroup().contains(availableMask));
            }
            for (Layer layer3 : unusedLayers) {
                layer3.dispose();
                Layer layerParent = layer3.getParent();
                if (layerParent == null) continue;
                layerParent.getChildren().remove(layer3);
            }
        }
    }

    private class VisibilityLL
    extends AbstractLayerListener {
        private VisibilityLL() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            Object value;
            if ("visible".equals(event.getPropertyName()) && (value = layer.getConfiguration().getValue("mask")) instanceof Mask) {
                Mask mask = (Mask)value;
                ProductNodeGroup<Mask> overlayMaskGroup = MaskCollectionLayer.this.getRaster().getOverlayMaskGroup();
                if (layer.isVisible()) {
                    if (!overlayMaskGroup.contains(mask)) {
                        overlayMaskGroup.add(mask);
                    }
                } else {
                    overlayMaskGroup.remove(mask);
                }
            }
        }
    }

    public class MaskPNL
    implements ProductNodeListener {
        @Override
        public synchronized void nodeChanged(ProductNodeEvent event) {
            Mask mask;
            ImageLayer maskLayer;
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Mask && (maskLayer = MaskCollectionLayer.this.getMaskLayer(mask = (Mask)sourceNode)) != null) {
                if (event.getPropertyName().equals("name")) {
                    maskLayer.setName(mask.getName());
                } else {
                    maskLayer.regenerate();
                }
            }
        }

        @Override
        public void nodeDataChanged(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                this.nodeChanged(event);
            }
        }

        @Override
        public void nodeAdded(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                MaskCollectionLayer.this.updateChildren();
            }
        }

        @Override
        public void nodeRemoved(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                MaskCollectionLayer.this.updateChildren();
            }
        }
    }
}

