/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.layer;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import org.esa.snap.core.datamodel.Graticule;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.layer.GraticuleLayerType;

public class GraticuleLayer
extends Layer {
    private static final GraticuleLayerType LAYER_TYPE = (GraticuleLayerType)LayerTypeRegistry.getLayerType(GraticuleLayerType.class);
    private RasterDataNode raster;
    private ProductNodeHandler productNodeHandler;
    private Graticule graticule;

    public GraticuleLayer(RasterDataNode raster) {
        this(LAYER_TYPE, raster, GraticuleLayer.initConfiguration(LAYER_TYPE.createLayerConfig(null), raster));
    }

    public GraticuleLayer(GraticuleLayerType type, RasterDataNode raster, PropertySet configuration) {
        super((LayerType)type, configuration);
        this.setName("Graticule Layer");
        this.raster = raster;
        this.productNodeHandler = new ProductNodeHandler();
        raster.getProduct().addProductNodeListener(this.productNodeHandler);
        this.setTransparency(0.5);
    }

    private static PropertySet initConfiguration(PropertySet configurationTemplate, RasterDataNode raster) {
        configurationTemplate.setValue("raster", (Object)raster);
        return configurationTemplate;
    }

    private Product getProduct() {
        return this.getRaster().getProduct();
    }

    RasterDataNode getRaster() {
        return this.raster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderLayer(Rendering rendering) {
        if (this.graticule == null) {
            this.graticule = Graticule.create(this.raster, this.getResAuto(), this.getResPixels(), (float)this.getResLat(), (float)this.getResLon());
        }
        if (this.graticule != null) {
            Graphics2D g2d = rendering.getGraphics();
            Viewport vp = rendering.getViewport();
            AffineTransform transformSave = g2d.getTransform();
            try {
                Graticule.TextGlyph[] textGlyphs;
                AffineTransform transform = new AffineTransform();
                transform.concatenate(transformSave);
                transform.concatenate(vp.getModelToViewTransform());
                transform.concatenate(this.raster.getSourceImage().getModel().getImageToModelTransform(0));
                g2d.setTransform(transform);
                GeneralPath[] linePaths = this.graticule.getLinePaths();
                if (linePaths != null) {
                    this.drawLinePaths(g2d, linePaths);
                }
                if (this.isTextEnabled() && (textGlyphs = this.graticule.getTextGlyphs()) != null) {
                    this.drawTextLabels(g2d, textGlyphs);
                }
            }
            finally {
                g2d.setTransform(transformSave);
            }
        }
    }

    private void drawLinePaths(Graphics2D g2d, GeneralPath[] linePaths) {
        Composite oldComposite = null;
        if (this.getLineTransparency() > 0.0) {
            oldComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite(this.getLineTransparency()));
        }
        g2d.setPaint(this.getLineColor());
        g2d.setStroke(new BasicStroke((float)this.getLineWidth()));
        for (GeneralPath linePath : linePaths) {
            g2d.draw(linePath);
        }
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
    }

    private void drawTextLabels(Graphics2D g2d, Graticule.TextGlyph[] textGlyphs) {
        float tx = 3.0f;
        float ty = -3.0f;
        if (this.getTextBgTransparency() < 1.0) {
            Composite oldComposite = null;
            if (this.getTextBgTransparency() > 0.0) {
                oldComposite = g2d.getComposite();
                g2d.setComposite(this.getAlphaComposite(this.getTextBgTransparency()));
            }
            g2d.setPaint(this.getTextBgColor());
            g2d.setStroke(new BasicStroke(0.0f));
            Graticule.TextGlyph[] textGlyphArray = textGlyphs;
            int n = textGlyphArray.length;
            for (int i = 0; i < n; ++i) {
                Graticule.TextGlyph glyph = textGlyphArray[i];
                g2d.translate(glyph.getX(), glyph.getY());
                g2d.rotate(glyph.getAngle());
                Rectangle2D labelBounds = g2d.getFontMetrics().getStringBounds(glyph.getText(), g2d);
                labelBounds.setRect(labelBounds.getX() + 3.0 - 1.0, labelBounds.getY() + -3.0 - 1.0, labelBounds.getWidth() + 4.0, labelBounds.getHeight());
                g2d.fill(labelBounds);
                g2d.rotate(-glyph.getAngle());
                g2d.translate(-glyph.getX(), -glyph.getY());
            }
            if (oldComposite != null) {
                g2d.setComposite(oldComposite);
            }
        }
        g2d.setFont(this.getTextFont());
        g2d.setPaint(this.getTextFgColor());
        for (Graticule.TextGlyph glyph : textGlyphs) {
            g2d.translate(glyph.getX(), glyph.getY());
            g2d.rotate(glyph.getAngle());
            g2d.drawString(glyph.getText(), 3.0f, -3.0f);
            g2d.rotate(-glyph.getAngle());
            g2d.translate(-glyph.getX(), -glyph.getY());
        }
    }

    private AlphaComposite getAlphaComposite(double itemTransparancy) {
        double combinedAlpha = (1.0 - this.getTransparency()) * (1.0 - itemTransparancy);
        return AlphaComposite.getInstance(3, (float)combinedAlpha);
    }

    public void disposeLayer() {
        Product product = this.getProduct();
        if (product != null) {
            product.removeProductNodeListener(this.productNodeHandler);
            this.graticule = null;
            this.raster = null;
        }
    }

    protected void fireLayerPropertyChanged(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("graticule.res.auto") || propertyName.equals("graticule.res.lat") || propertyName.equals("graticule.res.lon") || propertyName.equals("graticule.res.pixels")) {
            this.graticule = null;
        }
        if (this.getConfiguration().getProperty(propertyName) != null) {
            this.getConfiguration().setValue(propertyName, event.getNewValue());
        }
        super.fireLayerPropertyChanged(event);
    }

    private boolean getResAuto() {
        return (Boolean)this.getConfigurationProperty("graticule.res.auto", true);
    }

    private double getResLon() {
        return (Double)this.getConfigurationProperty("graticule.res.lon", 1.0);
    }

    private double getResLat() {
        return (Double)this.getConfigurationProperty("graticule.res.lat", 1.0);
    }

    private int getResPixels() {
        return (Integer)this.getConfigurationProperty("graticule.res.pixels", 128);
    }

    private boolean isTextEnabled() {
        return (Boolean)this.getConfigurationProperty("graticule.text.enabled", true);
    }

    private Color getLineColor() {
        return (Color)this.getConfigurationProperty("graticule.line.color", GraticuleLayerType.DEFAULT_LINE_COLOR);
    }

    private double getLineTransparency() {
        return (Double)this.getConfigurationProperty("graticule.line.transparency", 0.0);
    }

    private double getLineWidth() {
        return (Double)this.getConfigurationProperty("graticule.line.width", 0.5);
    }

    private Font getTextFont() {
        return (Font)this.getConfigurationProperty("graticule.text.font", GraticuleLayerType.DEFAULT_TEXT_FONT);
    }

    private Color getTextFgColor() {
        return (Color)this.getConfigurationProperty("graticule.text.fg.color", GraticuleLayerType.DEFAULT_TEXT_FG_COLOR);
    }

    private Color getTextBgColor() {
        return (Color)this.getConfigurationProperty("graticule.text.bg.color", GraticuleLayerType.DEFAULT_TEXT_BG_COLOR);
    }

    private double getTextBgTransparency() {
        return (Double)this.getConfigurationProperty("graticule.text.bg.transparency", 0.7);
    }

    private class ProductNodeHandler
    extends ProductNodeListenerAdapter {
        private ProductNodeHandler() {
        }

        @Override
        public void nodeChanged(ProductNodeEvent event) {
            if (event.getSourceNode() == GraticuleLayer.this.getProduct() && "sceneGeoCoding".equals(event.getPropertyName())) {
                GraticuleLayer.this.graticule = null;
                GraticuleLayer.this.fireLayerDataChanged(GraticuleLayer.this.getModelBounds());
            }
        }
    }
}

