/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.image.RasterDataNodeOpImage;
import org.esa.snap.core.image.ResolutionLevel;

public class BandOpImage
extends RasterDataNodeOpImage {
    public BandOpImage(Band band) {
        this(band, ResolutionLevel.MAXRES);
    }

    public BandOpImage(Band band, ResolutionLevel level) {
        super(band, level);
        if (Boolean.getBoolean("snap.imageManager.disableSourceTileCaching")) {
            this.setTileCache(null);
        }
    }

    public Band getBand() {
        return (Band)this.getRasterDataNode();
    }

    @Override
    protected void computeProductData(ProductData productData, Rectangle destRect) throws IOException {
        ProductReader productReader = this.getBand().getProductReader();
        if (productReader == null) {
            throw new IllegalStateException("no product reader for band '" + this.getBand().getDisplayName() + "'");
        }
        if (this.getLevel() == 0) {
            productReader.readBandRasterData(this.getBand(), destRect.x, destRect.y, destRect.width, destRect.height, productData, ProgressMonitor.NULL);
        } else {
            int sourceWidth = this.getSourceWidth(destRect.width);
            ProductData lineData = ProductData.createInstance(this.getBand().getDataType(), sourceWidth);
            int[] sourceCoords = this.getSourceCoords(sourceWidth, destRect.width);
            int srcX = this.getSourceX(destRect.x);
            Band band = this.getBand();
            for (int y = 0; y < destRect.height; ++y) {
                productReader.readBandRasterData(band, srcX, this.getSourceY(destRect.y + y), lineData.getNumElems(), 1, lineData, ProgressMonitor.NULL);
                BandOpImage.copyLine(y, destRect.width, lineData, productData, sourceCoords);
            }
        }
    }
}

