/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.dem;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.Set;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ServiceLoader;

public class ElevationModelRegistry {
    private final ServiceRegistry<ElevationModelDescriptor> descriptors = ServiceRegistryManager.getInstance().getServiceRegistry(ElevationModelDescriptor.class);

    private ElevationModelRegistry() {
        ServiceLoader.loadServices(this.descriptors);
    }

    public static ElevationModelRegistry getInstance() {
        return Holder.instance;
    }

    public void addDescriptor(ElevationModelDescriptor elevationModelDescriptor) {
        this.descriptors.addService((Object)elevationModelDescriptor);
    }

    public void removeDescriptor(ElevationModelDescriptor elevationModelDescriptor) {
        this.descriptors.removeService((Object)elevationModelDescriptor);
    }

    public ElevationModelDescriptor getDescriptor(String demName) {
        Guardian.assertNotNullOrEmpty("demName", demName);
        Set services = this.descriptors.getServices();
        for (ElevationModelDescriptor descriptor : services) {
            if (!demName.equalsIgnoreCase(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    public ElevationModelDescriptor[] getAllDescriptors() {
        return this.descriptors.getServices().toArray(new ElevationModelDescriptor[0]);
    }

    private static class Holder {
        private static final ElevationModelRegistry instance = new ElevationModelRegistry();

        private Holder() {
        }
    }
}

