/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.dem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.util.SystemUtils;

public abstract class AbstractElevationModelDescriptor
implements ElevationModelDescriptor {
    private static final String PROPERTIES_FILE_NAME = "dem.properties";
    private static final String INSTALL_DIR_PROPERTY_NAME = "dem.installDir";
    private static final Logger LOG = Logger.getLogger(AbstractElevationModelDescriptor.class.getName());
    private final File demInstallDir;
    private final Properties properties;

    protected AbstractElevationModelDescriptor() {
        File demPropertiesDir = new File(SystemUtils.getAuxDataPath().resolve("dem").toFile(), this.getName());
        if (!demPropertiesDir.exists()) {
            demPropertiesDir.mkdirs();
        }
        this.properties = this.loadProperties(new File(demPropertiesDir, PROPERTIES_FILE_NAME));
        this.demInstallDir = this.getDemInstallDir(demPropertiesDir);
    }

    @Override
    public File getDemInstallDir() {
        return this.demInstallDir;
    }

    private String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    private Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            try (FileInputStream stream = new FileInputStream(propertiesFile);){
                properties.load(stream);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, String.format("Could not load properties from '%s'", propertiesFile), ioe);
            }
        }
        return properties;
    }

    private File getDemInstallDir(File defaultDirectory) {
        File installDir;
        String installDirPath = this.getProperty(INSTALL_DIR_PROPERTY_NAME);
        if (installDirPath != null && installDirPath.length() > 0 && (installDir = new File(installDirPath)).exists()) {
            return installDir;
        }
        return defaultDirectory;
    }
}

