/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.barithm;

import org.esa.snap.core.image.LevelImageSupport;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.jexp.EvalEnv;

public class RasterDataEvalEnv
implements EvalEnv {
    private final int offsetX;
    private final int offsetY;
    private final int regionWidth;
    private final int regionHeight;
    private int elemIndex;
    private LevelImageSupport levelImageSupport;

    public RasterDataEvalEnv(int offsetX, int offsetY, int regionWidth, int regionHeight) {
        this(offsetX, offsetY, regionWidth, regionHeight, new LevelImageSupport(regionWidth, regionHeight, ResolutionLevel.MAXRES));
    }

    public RasterDataEvalEnv(int offsetX, int offsetY, int regionWidth, int regionHeight, LevelImageSupport levelImageSupport) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.levelImageSupport = levelImageSupport;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getRegionWidth() {
        return this.regionWidth;
    }

    public int getRegionHeight() {
        return this.regionHeight;
    }

    public final int getPixelX() {
        return this.levelImageSupport.getSourceX(this.offsetX + this.elemIndex % this.regionWidth);
    }

    public final int getPixelY() {
        return this.levelImageSupport.getSourceY(this.offsetY + this.elemIndex / this.regionWidth);
    }

    public final int getElemIndex() {
        return this.elemIndex;
    }

    public void setElemIndex(int elemIndex) {
        this.elemIndex = elemIndex;
    }
}

