/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensibleObject;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;

public abstract class ProductNode
extends ExtensibleObject {
    public static final String PROPERTY_NAME_NAME = "name";
    public static final String PROPERTY_NAME_DESCRIPTION = "description";
    private transient Product product;
    private transient ProductNode owner;
    private transient boolean modified;
    private String name;
    private String description;

    protected ProductNode(String name) {
        this(name, null);
    }

    protected ProductNode(String name, String description) {
        Guardian.assertNotNull(PROPERTY_NAME_NAME, name);
        name = name.trim();
        Guardian.assertNotNullOrEmpty(PROPERTY_NAME_NAME, name);
        this.name = name;
        this.description = description;
    }

    public void setOwner(ProductNode owner) {
        if (owner != this.owner) {
            this.owner = owner;
            this.product = null;
        }
    }

    public ProductNode getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Guardian.assertNotNull(PROPERTY_NAME_NAME, name);
        this.setNodeName(name.trim(), false);
    }

    private void setNodeName(String trimmedName, boolean silent) {
        Guardian.assertNotNullOrEmpty("name contains only spaces", trimmedName);
        if (!ObjectUtils.equalObjects(this.name, trimmedName)) {
            Product product = this.getProduct();
            if (product != null) {
                Assert.argument((!product.containsRasterDataNode(trimmedName) ? 1 : 0) != 0, (String)("The Product '" + product.getName() + "' already contains " + "a raster data node with the name '" + trimmedName + "'."));
            }
            if (!ProductNode.isValidNodeName(trimmedName)) {
                throw new IllegalArgumentException("The given name '" + trimmedName + "' is not a valid node name.");
            }
            String oldName = this.name;
            this.name = trimmedName;
            if (!silent) {
                this.fireProductNodeChanged(PROPERTY_NAME_NAME, oldName, this.name);
                this.setModified(true);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!ObjectUtils.equalObjects(this.description, description)) {
            this.description = description;
            this.fireProductNodeChanged(PROPERTY_NAME_DESCRIPTION);
            this.setModified(true);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        boolean oldState = this.modified;
        if (oldState != modified) {
            this.modified = modified;
            if (this.modified && this.getOwner() != null) {
                this.getOwner().setModified(true);
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[name=" + this.getName() + "]";
    }

    public void dispose() {
        this.owner = null;
        this.product = null;
        this.description = null;
        this.name = null;
    }

    public static boolean isValidNodeName(String name) {
        if (name == null || "or".equalsIgnoreCase(name) || "and".equalsIgnoreCase(name) || "not".equalsIgnoreCase(name)) {
            return false;
        }
        String trimmedName = name.trim();
        return trimmedName.matches("[^\\\\/:*?\"<>|\\.][^\\\\/:*?\"<>|]*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProduct() {
        if (this.product == null) {
            ProductNode productNode = this;
            synchronized (productNode) {
                if (this.product == null) {
                    ProductNode owner = this;
                    do {
                        if (!(owner instanceof Product)) continue;
                        this.product = (Product)owner;
                        break;
                    } while ((owner = owner.getOwner()) != null);
                }
            }
        }
        return this.product;
    }

    protected Product getProductSafe() throws IllegalStateException {
        Product product = this.getProduct();
        if (product == null) {
            throw new IllegalStateException("node '" + this.getName() + "' must be owned by a product before it can be used");
        }
        return product;
    }

    public ProductReader getProductReader() {
        Product product = this.getProduct();
        return product != null ? product.getProductReader() : null;
    }

    protected ProductReader getProductReaderSafe() {
        ProductReader productReader = this.getProductReader();
        if (productReader == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " '" + this.getName() + "': no ProductReader set");
        }
        return productReader;
    }

    public ProductWriter getProductWriter() {
        Product product = this.getProduct();
        return product != null ? product.getProductWriter() : null;
    }

    protected ProductWriter getProductWriterSafe() {
        ProductWriter productWriter = this.getProductWriter();
        if (productWriter == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " '" + this.getName() + "': no ProductWriter set");
        }
        return productWriter;
    }

    public String getDisplayName() {
        String prefix = this.getProductRefString();
        if (prefix == null) {
            return this.getName();
        }
        return prefix.concat(" ").concat(this.getName());
    }

    public String getProductRefString() {
        Product product = this.getProduct();
        return product != null ? product.getRefStr() : null;
    }

    public long getRawStorageSize() {
        return this.getRawStorageSize(null);
    }

    public abstract long getRawStorageSize(ProductSubsetDef var1);

    public void updateExpression(String oldExternalName, String newExternalName) {
    }

    public void fireProductNodeChanged(String propertyName) {
        this.fireProductNodeChanged(propertyName, null, null);
    }

    public void fireProductNodeChanged(String propertyName, Object oldValue, Object newValue) {
        Product product = this.getProduct();
        if (product != null) {
            product.fireNodeChanged(this, propertyName, oldValue, newValue);
        }
    }

    public abstract void acceptVisitor(ProductVisitor var1);

    protected boolean isPartOfSubset(ProductSubsetDef subsetDef) {
        return subsetDef == null || subsetDef.containsNodeName(this.getName());
    }

    public void removeFromFile(ProductWriter productWriter) {
    }
}

