/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import Jama.LUDecomposition;
import Jama.Matrix;
import java.awt.Rectangle;
import java.awt.image.Raster;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.GeoApproximation;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.math.SinusoidalDistance;

class PixelFinder {
    private static final int MAX_SEARCH_CYCLE_COUNT = 30;
    private final PlanarImage lonImage;
    private final PlanarImage latImage;
    private final PlanarImage maskImage;
    private final double halfPixelDiagonal;
    private final int imageW;
    private final int imageH;
    private final PixelPosCreator pixelFindingStrategy;
    private final int searchRadius;

    PixelFinder(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double halfPixelDiagonal, boolean fractionAccuracy, int searchRadius) {
        this.lonImage = lonImage;
        this.latImage = latImage;
        this.maskImage = maskImage;
        this.halfPixelDiagonal = halfPixelDiagonal;
        this.searchRadius = searchRadius;
        this.pixelFindingStrategy = fractionAccuracy ? new FractionPixelPosCreator() : new DefaultPixelPosCreator();
        this.imageW = lonImage.getWidth();
        this.imageH = lonImage.getHeight();
    }

    void findPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        int searchableExtent = 60;
        int x0 = (int)Math.floor(pixelPos.x);
        int y0 = (int)Math.floor(pixelPos.y);
        if (x0 + 60 >= 0 && x0 - 60 < this.imageW && y0 + 60 >= 0 && y0 - 60 < this.imageH) {
            double minDistance;
            GeoPos bestGeoPos;
            if (x0 < 0) {
                x0 = 0;
            } else if (x0 >= this.imageW) {
                x0 = this.imageW - 1;
            }
            if (y0 < 0) {
                y0 = 0;
            } else if (y0 >= this.imageH) {
                y0 = this.imageH - 1;
            }
            int x1 = Math.max(x0 - 60, 0);
            int y1 = Math.max(y0 - 60, 0);
            int x2 = Math.min(x0 + 60, this.imageW - 1);
            int y2 = Math.min(y0 + 60, this.imageH - 1);
            int rasterMinX = x1;
            int rasterMinY = y1;
            int rasterMaxX = x2;
            int rasterMaxY = y2;
            double lon0 = GeoApproximation.normalizeLon(geoPos.lon);
            double lat0 = geoPos.lat;
            SinusoidalDistance dc = new SinusoidalDistance(lon0, lat0);
            if (this.maskImage == null || PixelFinder.getSample(x0, y0, this.maskImage) != 0) {
                double lon = GeoApproximation.normalizeLon(PixelFinder.getSampleDouble(x0, y0, this.lonImage));
                double lat = PixelFinder.getSampleDouble(x0, y0, this.latImage);
                bestGeoPos = new GeoPos(lat, lon);
                minDistance = dc.distance(lon, lat);
            } else {
                bestGeoPos = null;
                minDistance = Double.POSITIVE_INFINITY;
            }
            Rectangle knownRectangle = new Rectangle(x0, y0, 1, 1);
            for (int i = 0; i < 30; ++i) {
                x1 = x0;
                y1 = y0;
                int minX = Math.max(x1 - this.searchRadius, rasterMinX);
                int minY = Math.max(y1 - this.searchRadius, rasterMinY);
                int maxX = Math.min(x1 + this.searchRadius, rasterMaxX);
                int maxY = Math.min(y1 + this.searchRadius, rasterMaxY);
                if (this.maskImage != null) {
                    while (minX > rasterMinX && PixelFinder.getSample(minX, y1, this.maskImage) == 0) {
                        if (minX <= rasterMinX) continue;
                        --minX;
                    }
                    while (maxX < rasterMaxX && PixelFinder.getSample(maxX, y1, this.maskImage) == 0) {
                        if (maxX >= rasterMaxX) continue;
                        ++maxX;
                    }
                }
                for (int y = minY; y <= maxY; ++y) {
                    for (int x = minX; x <= maxX; ++x) {
                        double lat;
                        double lon;
                        double d;
                        if (knownRectangle.contains(x, y) || this.maskImage != null && PixelFinder.getSample(x, y, this.maskImage) == 0 || !((d = dc.distance(lon = GeoApproximation.normalizeLon(PixelFinder.getSampleDouble(x, y, this.lonImage)), lat = PixelFinder.getSampleDouble(x, y, this.latImage))) < minDistance)) continue;
                        bestGeoPos = new GeoPos(lat, lon);
                        minDistance = d;
                        x1 = x;
                        y1 = y;
                    }
                }
                if (x1 == x0 && y1 == y0) break;
                x0 = x1;
                y0 = y1;
                knownRectangle = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            }
            pixelPos.setLocation(this.pixelFindingStrategy.createPixelPos(lat0, lon0, minDistance, x0, y0, bestGeoPos));
        } else {
            pixelPos.setInvalid();
        }
    }

    private static double getSampleDouble(int pixelX, int pixelY, PlanarImage image) {
        int x = image.getMinX() + pixelX;
        int y = image.getMinY() + pixelY;
        int tileX = image.XToTileX(x);
        int tileY = image.YToTileY(y);
        Raster data = image.getTile(tileX, tileY);
        return data.getSampleDouble(x, y, 0);
    }

    private static int getSample(int pixelX, int pixelY, PlanarImage image) {
        int x = image.getMinX() + pixelX;
        int y = image.getMinY() + pixelY;
        int tileX = image.XToTileX(x);
        int tileY = image.YToTileY(y);
        Raster data = image.getTile(tileX, tileY);
        return data.getSample(x, y, 0);
    }

    private class FractionPixelPosCreator
    implements PixelPosCreator {
        private static final int upper_left_quadrant = 0;
        private static final int upper_right_quadrant = 1;
        private static final int lower_left_quadrant = 2;
        private static final int lower_right_quadrant = 3;
        private int centerX;
        private int centerY;
        private GeoPos centerGeoPos;
        private GeoPos leftGeoPos;
        private GeoPos upperGeoPos;
        private GeoPos rightGeoPos;
        private GeoPos lowerGeoPos;

        private FractionPixelPosCreator() {
        }

        @Override
        public PixelPos createPixelPos(double lat0, double lon0, double minDistance, int x, int y, GeoPos geoPos) {
            boolean onLowerBorder;
            this.centerX = x;
            this.centerY = y;
            this.centerGeoPos = geoPos;
            this.leftGeoPos = new GeoPos();
            this.upperGeoPos = new GeoPos();
            this.rightGeoPos = new GeoPos();
            this.lowerGeoPos = new GeoPos();
            boolean onLeftBorder = x <= 0;
            boolean onUpperBorder = y <= 0;
            boolean onRightBorder = x >= PixelFinder.this.imageW - 1;
            boolean bl = onLowerBorder = y >= PixelFinder.this.imageH - 1;
            if (!onLeftBorder) {
                this.leftGeoPos = this.initGeoPos(x - 1, y);
            }
            if (!onUpperBorder) {
                this.upperGeoPos = this.initGeoPos(x, y - 1);
            }
            if (!onRightBorder) {
                this.rightGeoPos = this.initGeoPos(x + 1, y);
            }
            if (!onLowerBorder) {
                this.lowerGeoPos = this.initGeoPos(x, y + 1);
            }
            if (onLeftBorder && onUpperBorder) {
                return this.getPixelPosFromLowerRight(lat0, lon0);
            }
            if (onLeftBorder && onLowerBorder) {
                return this.getPixelPosFromUpperRight(lat0, lon0);
            }
            if (onRightBorder && onUpperBorder) {
                return this.getPixelPosFromLowerLeft(lat0, lon0);
            }
            if (onRightBorder && onLowerBorder) {
                return this.getPixelPosFromUpperLeft(lat0, lon0);
            }
            this.simulateGeoPosIfNecessary(onLeftBorder, this.leftGeoPos, this.rightGeoPos);
            this.simulateGeoPosIfNecessary(onUpperBorder, this.upperGeoPos, this.lowerGeoPos);
            this.simulateGeoPosIfNecessary(onRightBorder, this.rightGeoPos, this.leftGeoPos);
            this.simulateGeoPosIfNecessary(onLowerBorder, this.lowerGeoPos, this.upperGeoPos);
            int quadrant = this.determineQuadrant(lat0, lon0);
            if (quadrant == 0) {
                if (onLeftBorder) {
                    return this.getPixelPosFromUpperRight(lat0, lon0);
                }
                if (onUpperBorder) {
                    return this.getPixelPosFromLowerLeft(lat0, lon0);
                }
                return this.getPixelPosFromUpperLeft(lat0, lon0);
            }
            if (quadrant == 1) {
                if (onRightBorder) {
                    return this.getPixelPosFromUpperLeft(lat0, lon0);
                }
                if (onUpperBorder) {
                    return this.getPixelPosFromLowerRight(lat0, lon0);
                }
                return this.getPixelPosFromUpperRight(lat0, lon0);
            }
            if (quadrant == 2) {
                if (onLeftBorder) {
                    return this.getPixelPosFromLowerRight(lat0, lon0);
                }
                if (onLowerBorder) {
                    return this.getPixelPosFromUpperLeft(lat0, lon0);
                }
                return this.getPixelPosFromLowerLeft(lat0, lon0);
            }
            if (onRightBorder) {
                return this.getPixelPosFromLowerLeft(lat0, lon0);
            }
            if (onLowerBorder) {
                return this.getPixelPosFromUpperRight(lat0, lon0);
            }
            return this.getPixelPosFromLowerRight(lat0, lon0);
        }

        private GeoPos initGeoPos(int x, int y) {
            double lon = GeoApproximation.normalizeLon(PixelFinder.getSampleDouble(x, y, PixelFinder.this.lonImage));
            double lat = PixelFinder.getSampleDouble(x, y, PixelFinder.this.latImage);
            return new GeoPos(lat, lon);
        }

        private int determineQuadrant(double lat, double lon) {
            boolean isAboveLeftCenterLine = this.determineWhetherIsAbove(this.leftGeoPos, lat, lon);
            boolean isLeftToUpperCenterLine = this.determineWhetherIsLeftTo(this.upperGeoPos, lat, lon);
            if (isAboveLeftCenterLine && isLeftToUpperCenterLine) {
                return 0;
            }
            boolean isAboveRightCenterLine = this.determineWhetherIsAbove(this.rightGeoPos, lat, lon);
            if (isAboveRightCenterLine && !isLeftToUpperCenterLine) {
                return 1;
            }
            boolean isLeftToLowerCenterLine = this.determineWhetherIsLeftTo(this.lowerGeoPos, lat, lon);
            if (isLeftToLowerCenterLine && !isAboveLeftCenterLine) {
                return 2;
            }
            return 3;
        }

        private boolean determineWhetherIsAbove(GeoPos geoPos, double lat, double lon) {
            if (!(Math.abs(this.centerGeoPos.getLat() - geoPos.getLat()) < 1.0E-8)) {
                double mToLeft = (this.centerGeoPos.getLon() - geoPos.getLon()) / (this.centerGeoPos.getLat() - geoPos.getLat());
                double calculatedLon = mToLeft * (lat - geoPos.getLat()) + geoPos.getLon();
                double calculatedUpperLon = mToLeft * (this.upperGeoPos.getLat() - geoPos.getLat()) + geoPos.getLon();
                double diff = calculatedLon - lon;
                double upperDiff = calculatedUpperLon - this.upperGeoPos.getLon();
                return diff >= 0.0 && upperDiff >= 0.0 || diff < 0.0 && upperDiff < 0.0;
            }
            return lat >= this.centerGeoPos.getLat() && this.upperGeoPos.getLat() >= this.centerGeoPos.getLat() || lat < this.centerGeoPos.getLat() && this.upperGeoPos.getLat() < this.centerGeoPos.getLat();
        }

        private boolean determineWhetherIsLeftTo(GeoPos geoPos, double lat, double lon) {
            if (!(Math.abs(this.centerGeoPos.getLat() - geoPos.getLat()) < 1.0E-8)) {
                double mToUpper = (this.centerGeoPos.getLon() - geoPos.getLon()) / (this.centerGeoPos.getLat() - geoPos.getLat());
                double calculatedLon = mToUpper * (lat - geoPos.getLat()) + geoPos.getLon();
                double calculatedLeftLon = mToUpper * (this.leftGeoPos.getLat() - geoPos.getLat()) + geoPos.getLon();
                double diff = calculatedLon - lon;
                double leftDiff = calculatedLeftLon - this.leftGeoPos.getLon();
                return diff >= 0.0 && leftDiff >= 0.0 || diff < 0.0 && leftDiff < 0.0;
            }
            return lon >= this.centerGeoPos.getLon() && this.leftGeoPos.getLon() >= this.centerGeoPos.getLon() || lon < this.centerGeoPos.getLon() && this.leftGeoPos.getLon() < this.centerGeoPos.getLon();
        }

        private GeoPos simulateGeoPosIfNecessary(boolean simulate, GeoPos geoPos, GeoPos counterGeoPos) {
            if (simulate) {
                double lonDiff = this.centerGeoPos.getLon() - counterGeoPos.getLon();
                double latDiff = this.centerGeoPos.getLat() - counterGeoPos.getLat();
                double simulatedLat = this.centerGeoPos.getLat() + latDiff;
                double simulatedLon = this.centerGeoPos.getLon() + lonDiff;
                geoPos.setLocation(simulatedLat, simulatedLon);
            }
            return geoPos;
        }

        private PixelPos getPixelPosFromUpperLeft(double lat, double lon) {
            GeoPos[] geoPoses = new GeoPos[]{this.centerGeoPos, this.upperGeoPos, this.leftGeoPos};
            int[] xPositions = new int[]{this.centerX, this.centerX, this.centerX - 1};
            int[] yPositions = new int[]{this.centerY, this.centerY - 1, this.centerY};
            return this.getPixelPosWithFractionAccuracy(lat, lon, geoPoses, xPositions, yPositions);
        }

        private PixelPos getPixelPosFromUpperRight(double lat, double lon) {
            GeoPos[] geoPoses = new GeoPos[]{this.centerGeoPos, this.upperGeoPos, this.rightGeoPos};
            int[] xPositions = new int[]{this.centerX, this.centerX, this.centerX + 1};
            int[] yPositions = new int[]{this.centerY, this.centerY - 1, this.centerY};
            return this.getPixelPosWithFractionAccuracy(lat, lon, geoPoses, xPositions, yPositions);
        }

        private PixelPos getPixelPosFromLowerLeft(double lat, double lon) {
            GeoPos[] geoPoses = new GeoPos[]{this.centerGeoPos, this.lowerGeoPos, this.leftGeoPos};
            int[] xPositions = new int[]{this.centerX, this.centerX, this.centerX - 1};
            int[] yPositions = new int[]{this.centerY, this.centerY + 1, this.centerY};
            return this.getPixelPosWithFractionAccuracy(lat, lon, geoPoses, xPositions, yPositions);
        }

        private PixelPos getPixelPosFromLowerRight(double lat, double lon) {
            GeoPos[] geoPoses = new GeoPos[]{this.centerGeoPos, this.lowerGeoPos, this.rightGeoPos};
            int[] xPositions = new int[]{this.centerX, this.centerX, this.centerX + 1};
            int[] yPositions = new int[]{this.centerY, this.centerY + 1, this.centerY};
            return this.getPixelPosWithFractionAccuracy(lat, lon, geoPoses, xPositions, yPositions);
        }

        private PixelPos getPixelPosWithFractionAccuracy(double lat, double lon, GeoPos[] geoPositions, int[] xPositions, int[] yPositions) {
            Matrix mX;
            Matrix mY;
            PixelPos pixelPos = new PixelPos();
            if (!geoPositions[1].isValid() || !geoPositions[2].isValid()) {
                pixelPos.setInvalid();
                return pixelPos;
            }
            Matrix mA = new Matrix(3, 3);
            mA.set(0, 0, 1.0);
            mA.set(1, 0, 1.0);
            mA.set(2, 0, 1.0);
            mA.set(0, 1, geoPositions[0].getLat());
            mA.set(1, 1, geoPositions[1].getLat());
            mA.set(2, 1, geoPositions[2].getLat());
            mA.set(0, 2, geoPositions[0].getLon());
            mA.set(1, 2, geoPositions[1].getLon());
            mA.set(2, 2, geoPositions[2].getLon());
            LUDecomposition decomp = new LUDecomposition(mA);
            Matrix mB = new Matrix(3, 1);
            mB.set(0, 0, (double)yPositions[0] + 0.5);
            mB.set(1, 0, (double)yPositions[1] + 0.5);
            mB.set(2, 0, (double)yPositions[2] + 0.5);
            try {
                mY = decomp.solve(mB);
            }
            catch (Exception e) {
                pixelPos.setInvalid();
                return pixelPos;
            }
            mB.set(0, 0, (double)xPositions[0] + 0.5);
            mB.set(1, 0, (double)xPositions[1] + 0.5);
            mB.set(2, 0, (double)xPositions[2] + 0.5);
            try {
                mX = decomp.solve(mB);
            }
            catch (Exception e) {
                pixelPos.setInvalid();
                return pixelPos;
            }
            double fx = mX.get(0, 0) + mX.get(1, 0) * lat + mX.get(2, 0) * lon;
            double fy = mY.get(0, 0) + mY.get(1, 0) * lat + mY.get(2, 0) * lon;
            pixelPos.setLocation(fx, fy);
            return pixelPos;
        }
    }

    private class DefaultPixelPosCreator
    implements PixelPosCreator {
        private DefaultPixelPosCreator() {
        }

        @Override
        public PixelPos createPixelPos(double lat0, double lon0, double minDistance, int bestX, int bestY, GeoPos bestGeoPos) {
            PixelPos pixelPos = new PixelPos();
            if (minDistance < PixelFinder.this.halfPixelDiagonal) {
                pixelPos.setLocation((double)bestX + 0.5, (double)bestY + 0.5);
            } else {
                pixelPos.setInvalid();
            }
            return pixelPos;
        }
    }

    static interface PixelPosCreator {
        public PixelPos createPixelPos(double var1, double var3, double var5, int var7, int var8, GeoPos var9);
    }
}

