/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Color;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.dataio.dimap.DimapProductHelpers;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataMultiLevelImage;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.impl.Tokenizer;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.jdom.Element;

public class Mask
extends Band {
    private final ImageType imageType;
    private final PropertyChangeListener imageConfigListener;
    private final PropertyContainer imageConfig;

    public Mask(String name, int width, int height, ImageType imageType) {
        super(name, 20, width, height);
        Assert.notNull((Object)imageType, (String)"imageType");
        this.imageType = imageType;
        this.imageConfigListener = evt -> {
            if (this.isSourceImageSet()) {
                MultiLevelImage sourceImage = this.getSourceImage();
                this.setSourceImage((MultiLevelImage)null);
                sourceImage.reset();
            }
            this.fireProductNodeChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        };
        this.imageConfig = imageType.createImageConfig();
        this.imageConfig.addPropertyChangeListener(this.imageConfigListener);
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public PropertyContainer getImageConfig() {
        return this.imageConfig;
    }

    public Color getImageColor() {
        return (Color)this.imageConfig.getValue("color");
    }

    public void setImageColor(Color color) {
        this.imageConfig.setValue("color", (Object)color);
    }

    public double getImageTransparency() {
        return (Double)this.imageConfig.getValue("transparency");
    }

    public void setImageTransparency(double transparency) {
        this.imageConfig.setValue("transparency", (Object)transparency);
    }

    @Override
    protected RenderedImage createSourceImage() {
        MultiLevelImage image = this.getImageType().createImage(this);
        if (this.isMaskImageInvalid(image)) {
            throw new IllegalStateException("Invalid mask image.");
        }
        return image;
    }

    private boolean isMaskImageInvalid(MultiLevelImage image) {
        return image.getSampleModel().getDataType() != 0 || image.getNumBands() != 1 || image.getWidth() != this.getRasterWidth() || image.getHeight() != this.getRasterHeight();
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void dispose() {
        this.imageConfig.removePropertyChangeListener(this.imageConfigListener);
        super.dispose();
    }

    private static void setImageStyle(PropertyContainer imageConfig, Color color, double transparency) {
        imageConfig.setValue("color", (Object)color);
        imageConfig.setValue("transparency", (Object)transparency);
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        this.getImageType().handleRename(this, oldExternalName, newExternalName);
        super.updateExpression(oldExternalName, newExternalName);
    }

    @Override
    public Shape getValidShape() {
        return this.getSourceImage().getImageShape(0);
    }

    public static class RangeType
    extends ImageType {
        public static final String TYPE_NAME = "Range";
        public static final String PROPERTY_NAME_MINIMUM = "minimum";
        public static final String PROPERTY_NAME_MAXIMUM = "maximum";
        public static final String PROPERTY_NAME_RASTER = "rasterName";
        public static final RangeType INSTANCE = new RangeType();

        private RangeType() {
            super(TYPE_NAME);
        }

        @Override
        public MultiLevelImage createImage(Mask mask) {
            return VirtualBand.createSourceImage(mask, RangeType.getExpression(mask));
        }

        @Override
        public boolean canTransferMask(Mask mask, Product product) {
            String rasterName = RangeType.getRasterName(mask);
            return !StringUtils.isNullOrEmpty(rasterName) && product.containsRasterDataNode(rasterName);
        }

        @Override
        public Mask transferMask(Mask mask, Product product) {
            if (this.canTransferMask(mask, product)) {
                String originalMaskName = mask.getName();
                String maskName = ProductUtils.getAvailableNodeName(originalMaskName, product.getMaskGroup());
                int w = product.getSceneRasterWidth();
                int h = product.getSceneRasterHeight();
                Mask newMask = new Mask(maskName, w, h, this);
                newMask.setDescription(mask.getDescription());
                Mask.setImageStyle(newMask.getImageConfig(), mask.getImageColor(), mask.getImageTransparency());
                RangeType.setRasterName(newMask, RangeType.getRasterName(mask));
                RangeType.setMinimum(newMask, RangeType.getMinimum(mask));
                RangeType.setMaximum(newMask, RangeType.getMaximum(mask));
                product.getMaskGroup().add(newMask);
                return newMask;
            }
            return null;
        }

        @Override
        public PropertyContainer createImageConfig() {
            PropertyDescriptor minimumDescriptor = new PropertyDescriptor(PROPERTY_NAME_MINIMUM, Double.class);
            minimumDescriptor.setNotNull(true);
            minimumDescriptor.setNotEmpty(true);
            PropertyDescriptor maximumDescriptor = new PropertyDescriptor(PROPERTY_NAME_MAXIMUM, Double.class);
            maximumDescriptor.setNotNull(true);
            maximumDescriptor.setNotEmpty(true);
            PropertyDescriptor rasterDescriptor = new PropertyDescriptor(PROPERTY_NAME_RASTER, String.class);
            rasterDescriptor.setNotNull(true);
            rasterDescriptor.setNotEmpty(true);
            rasterDescriptor.setValidator((property, value) -> {
                String rasterName = String.valueOf(value);
                if (!Tokenizer.isExternalName(rasterName)) {
                    throw new ValidationException(String.format("'%s' is not an external name.", rasterName));
                }
            });
            PropertyContainer imageConfig = super.createImageConfig();
            imageConfig.addProperty(new Property(minimumDescriptor, (PropertyAccessor)new DefaultPropertyAccessor()));
            imageConfig.addProperty(new Property(maximumDescriptor, (PropertyAccessor)new DefaultPropertyAccessor()));
            imageConfig.addProperty(new Property(rasterDescriptor, (PropertyAccessor)new DefaultPropertyAccessor()));
            return imageConfig;
        }

        @Override
        public void handleRename(Mask mask, String oldExternalName, String newExternalName) {
            Property rasterProperty = mask.getImageConfig().getProperty(PROPERTY_NAME_RASTER);
            if (rasterProperty.getValue().equals(oldExternalName)) {
                try {
                    rasterProperty.setValue((Object)newExternalName);
                }
                catch (ValidationException e) {
                    throw new IllegalStateException(e);
                }
            }
            super.handleRename(mask, oldExternalName, newExternalName);
        }

        public static void setRasterName(Mask mask, String rasterName) {
            mask.getImageConfig().setValue(PROPERTY_NAME_RASTER, (Object)rasterName);
        }

        public static String getRasterName(Mask mask) {
            return (String)mask.getImageConfig().getValue(PROPERTY_NAME_RASTER);
        }

        public static void setMinimum(Mask mask, double minimum) {
            mask.getImageConfig().setValue(PROPERTY_NAME_MINIMUM, (Object)minimum);
        }

        public static Double getMinimum(Mask mask) {
            return (Double)mask.getImageConfig().getValue(PROPERTY_NAME_MINIMUM);
        }

        public static void setMaximum(Mask mask, double maximum) {
            mask.getImageConfig().setValue(PROPERTY_NAME_MAXIMUM, (Object)maximum);
        }

        public static Double getMaximum(Mask mask) {
            return (Double)mask.getImageConfig().getValue(PROPERTY_NAME_MAXIMUM);
        }

        public static String getExpression(Mask mask) {
            Double min = RangeType.getMinimum(mask);
            Double max = RangeType.getMaximum(mask);
            String rasterName = RangeType.getRasterName(mask);
            return rasterName + " >= " + min + " && " + rasterName + " <= " + max;
        }
    }

    public static class VectorDataType
    extends ImageType {
        public static final String TYPE_NAME = "Geometry";
        public static final String PROPERTY_NAME_VECTOR_DATA = "vectorData";
        public static final VectorDataType INSTANCE = new VectorDataType();

        private VectorDataType() {
            super(TYPE_NAME);
        }

        @Override
        public boolean canTransferMask(Mask mask, Product product) {
            return false;
        }

        @Override
        public Mask transferMask(Mask mask, Product product) {
            if (this.canTransferMask(mask, product)) {
                String originalMaskName = mask.getName();
                String maskName = ProductUtils.getAvailableNodeName(originalMaskName, product.getMaskGroup());
                int w = mask.getRasterWidth();
                int h = mask.getRasterHeight();
                Mask newMask = new Mask(maskName, w, h, this);
                newMask.setDescription(mask.getDescription());
                Mask.setImageStyle(mask.getImageConfig(), mask.getImageColor(), mask.getImageTransparency());
                VectorDataType.setVectorData(newMask, VectorDataType.getVectorData(mask));
                product.getMaskGroup().add(newMask);
                return newMask;
            }
            return null;
        }

        @Override
        public MultiLevelImage createImage(Mask mask) {
            return VectorDataMultiLevelImage.createMaskImage(VectorDataType.getVectorData(mask), mask);
        }

        @Override
        public PropertyContainer createImageConfig() {
            PropertyDescriptor vectorDataDescriptor = new PropertyDescriptor(PROPERTY_NAME_VECTOR_DATA, VectorDataNode.class);
            vectorDataDescriptor.setNotNull(true);
            PropertyContainer imageConfig = super.createImageConfig();
            imageConfig.addProperty(new Property(vectorDataDescriptor, (PropertyAccessor)new DefaultPropertyAccessor()));
            return imageConfig;
        }

        public static VectorDataNode getVectorData(Mask mask) {
            return (VectorDataNode)((Object)mask.getImageConfig().getValue(PROPERTY_NAME_VECTOR_DATA));
        }

        public static void setVectorData(Mask mask, VectorDataNode vectorDataNode) {
            mask.getImageConfig().setValue(PROPERTY_NAME_VECTOR_DATA, (Object)vectorDataNode);
        }
    }

    public static class BandMathsType
    extends ImageType {
        public static final String TYPE_NAME = "Maths";
        public static final String PROPERTY_NAME_EXPRESSION = "expression";
        public static final BandMathsType INSTANCE = new BandMathsType();

        private BandMathsType() {
            super(TYPE_NAME);
        }

        @Override
        public MultiLevelImage createImage(Mask mask) {
            return VirtualBand.createSourceImage(mask, BandMathsType.getExpression(mask));
        }

        @Override
        public boolean canTransferMask(Mask mask, Product product) {
            String expression = BandMathsType.getExpression(mask);
            if (StringUtils.isNullOrEmpty(expression)) {
                return false;
            }
            try {
                if (mask.getProduct() != null) {
                    for (RasterDataNode raster : BandArithmetic.getRefRasters(expression, mask.getProduct())) {
                        if (raster instanceof Mask) {
                            Mask refMask;
                            if (product.getMaskGroup().contains(raster.getName()) || this.canTransferMask(refMask = (Mask)raster, product)) continue;
                            return false;
                        }
                        BandArithmetic.getRefRasters(expression, product);
                    }
                } else {
                    BandArithmetic.getRefRasters(expression, product);
                }
            }
            catch (ParseException e) {
                return false;
            }
            return true;
        }

        @Override
        public Mask transferMask(Mask mask, Product product) {
            if (this.canTransferMask(mask, product)) {
                String expression = BandMathsType.getExpression(mask);
                Map<Mask, Mask> translationMap = BandMathsType.transferReferredMasks(expression, mask.getProduct(), product);
                expression = BandMathsType.translateExpression(translationMap, expression);
                String originalMaskName = mask.getName();
                String maskName = ProductUtils.getAvailableNodeName(originalMaskName, product.getMaskGroup());
                return product.addMask(maskName, expression, mask.getDescription(), mask.getImageColor(), mask.getImageTransparency());
            }
            return null;
        }

        private static Map<Mask, Mask> transferReferredMasks(String expression, Product sourceProduct, Product targetProduct) {
            RasterDataNode[] rasters;
            HashMap<Mask, Mask> translationMap = new HashMap<Mask, Mask>();
            try {
                rasters = BandArithmetic.getRefRasters(expression, sourceProduct);
            }
            catch (ParseException e) {
                return translationMap;
            }
            for (RasterDataNode raster : rasters) {
                if (!(raster instanceof Mask) || targetProduct.getMaskGroup().contains(raster.getName())) continue;
                Mask refMask = (Mask)raster;
                Mask newMask = refMask.getImageType().transferMask(refMask, targetProduct);
                translationMap.put(refMask, newMask);
            }
            return translationMap;
        }

        private static String translateExpression(Map<Mask, Mask> translationMap, String expression) {
            for (Map.Entry<Mask, Mask> entry : translationMap.entrySet()) {
                String srcName = entry.getKey().getName();
                String targetName = entry.getValue().getName();
                expression = StringUtils.replaceWord(expression, srcName, targetName);
            }
            return expression;
        }

        @Override
        public PropertyContainer createImageConfig() {
            PropertyDescriptor expressionDescriptor = new PropertyDescriptor(PROPERTY_NAME_EXPRESSION, String.class);
            expressionDescriptor.setNotNull(true);
            expressionDescriptor.setNotEmpty(true);
            PropertyContainer imageConfig = super.createImageConfig();
            Property property = new Property(expressionDescriptor, (PropertyAccessor)new DefaultPropertyAccessor());
            imageConfig.addProperty(property);
            return imageConfig;
        }

        @Override
        public void handleRename(Mask mask, String oldExternalName, String newExternalName) {
            String oldExpression = BandMathsType.getExpression(mask);
            String newExpression = StringUtils.replaceWord(oldExpression, oldExternalName, newExternalName);
            BandMathsType.setExpression(mask, newExpression);
            super.handleRename(mask, oldExternalName, newExternalName);
        }

        public static void setExpression(Mask mask, String expression) {
            mask.getImageConfig().setValue(PROPERTY_NAME_EXPRESSION, (Object)expression);
        }

        public static String getExpression(Mask mask) {
            return (String)mask.getImageConfig().getValue(PROPERTY_NAME_EXPRESSION);
        }

        public static Mask create(String name, String description, int width, int height, String expression, Color color, double transparency) {
            Mask mask = new Mask(name, width, height, INSTANCE);
            if (description != null) {
                mask.setDescription(description);
            }
            mask.setImageColor(color);
            mask.setImageTransparency(transparency);
            BandMathsType.setExpression(mask, expression);
            return mask;
        }

        public static Mask createFromBitmaskDef(Element element, int width, int height) {
            String name = element.getAttributeValue("name");
            String description = null;
            Element descElem = element.getChild("DESCRIPTION");
            if (descElem != null) {
                description = descElem.getAttributeValue("value").trim();
            }
            String expression = element.getChild("EXPRESSION").getAttributeValue("value").trim();
            Color color = DimapProductHelpers.createColor(element.getChild("COLOR"));
            String value = element.getChild("TRANSPARENCY").getAttributeValue("value");
            float transparency = 0.5f;
            try {
                transparency = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                Debug.trace(e);
            }
            return BandMathsType.create(name, description, width, height, expression, color, transparency);
        }
    }

    public static abstract class ImageType {
        public static final String PROPERTY_NAME_COLOR = "color";
        public static final String PROPERTY_NAME_TRANSPARENCY = "transparency";
        public static final Color DEFAULT_COLOR = Color.RED;
        public static final double DEFAULT_TRANSPARENCY = 0.5;
        private final String name;

        protected ImageType(String name) {
            this.name = name;
        }

        public abstract MultiLevelImage createImage(Mask var1);

        public boolean canTransferMask(Mask mask, Product product) {
            return false;
        }

        public Mask transferMask(Mask mask, Product product) {
            return null;
        }

        public PropertyContainer createImageConfig() {
            PropertyDescriptor colorType = new PropertyDescriptor(PROPERTY_NAME_COLOR, Color.class);
            colorType.setNotNull(true);
            colorType.setDefaultValue((Object)DEFAULT_COLOR);
            PropertyDescriptor transparencyType = new PropertyDescriptor(PROPERTY_NAME_TRANSPARENCY, Double.TYPE);
            transparencyType.setDefaultValue((Object)0.5);
            PropertyContainer imageConfig = new PropertyContainer();
            imageConfig.addProperty(new Property(colorType, (PropertyAccessor)new DefaultPropertyAccessor()));
            imageConfig.addProperty(new Property(transparencyType, (PropertyAccessor)new DefaultPropertyAccessor()));
            Mask.setImageStyle(imageConfig, ImageType.DEFAULT_COLOR, 0.5);
            return imageConfig;
        }

        public void handleRename(Mask mask, String oldExternalName, String newExternalName) {
        }

        public String getName() {
            return this.name;
        }
    }
}

