/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.awt.geom.Point2D;
import java.util.Arrays;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.RationalFunctionModel;
import org.esa.snap.core.datamodel.Rotator;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.dataop.maptransf.Datum;

public class GcpGeoCoding
extends AbstractGeoCoding {
    private double[] x;
    private double[] y;
    private double[] lons;
    private double[] lats;
    private int sceneWidth;
    private int sceneHeight;
    private RationalFunctionMap2D forwardMap;
    private RationalFunctionMap2D inverseMap;
    private Rotator rotator;
    private GeoCoding originalGeoCoding;
    private Datum datum;
    private boolean boundaryCrossingMeridianAt180;
    private Method method;

    public GcpGeoCoding(Method method, Placemark[] gcps, int sceneWidth, int sceneHeight, Datum datum) {
        this.sceneWidth = sceneWidth;
        this.sceneHeight = sceneHeight;
        this.datum = datum;
        this.method = method;
        this.initCoordinates(gcps);
        this.initTransformations(method);
        this.boundaryCrossingMeridianAt180 = this.isBoundaryCrossingMeridianAt180();
    }

    public GcpGeoCoding(Method method, double[] x, double[] y, double[] lons, double[] lats, int sceneWidth, int sceneHeight, Datum datum) {
        this.x = Arrays.copyOf(x, x.length);
        this.y = Arrays.copyOf(y, y.length);
        this.lons = Arrays.copyOf(lons, lons.length);
        this.lats = Arrays.copyOf(lats, lats.length);
        this.sceneWidth = sceneWidth;
        this.sceneHeight = sceneHeight;
        this.datum = datum;
        this.method = method;
        this.initTransformations(method);
        this.boundaryCrossingMeridianAt180 = this.isBoundaryCrossingMeridianAt180();
    }

    @Override
    public boolean transferGeoCoding(Scene sourceScene, Scene targetScene, ProductSubsetDef subsetDef) {
        double[] x2 = new double[this.x.length];
        double[] y2 = new double[this.y.length];
        int offsetX = 0;
        int offsetY = 0;
        if (subsetDef != null && subsetDef.getRegion() != null) {
            offsetX = subsetDef.getRegion().x;
            offsetY = subsetDef.getRegion().y;
        }
        int subSamplingX = 1;
        int subSamplingY = 1;
        if (subsetDef != null) {
            subSamplingX = subsetDef.getSubSamplingX();
            subSamplingY = subsetDef.getSubSamplingY();
        }
        int sceneWidth = targetScene.getRasterWidth();
        int sceneHeight = targetScene.getRasterHeight();
        for (int i = 0; i < x2.length; ++i) {
            x2[i] = (this.x[i] - (double)offsetX) / (double)subSamplingX;
            y2[i] = (this.y[i] - (double)offsetY) / (double)subSamplingY;
        }
        targetScene.setGeoCoding(new GcpGeoCoding(this.getMethod(), x2, y2, this.lons, this.lats, sceneWidth, sceneHeight, this.datum));
        return true;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return this.boundaryCrossingMeridianAt180;
    }

    @Override
    public boolean canGetPixelPos() {
        return this.inverseMap != null;
    }

    @Override
    public boolean canGetGeoPos() {
        return this.forwardMap != null;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        Point2D.Double point = new Point2D.Double(geoPos.lon, geoPos.lat);
        this.rotator.transform(point);
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        pixelPos.setLocation(this.inverseMap.getValue(point));
        if (!pixelPos.isValid() || pixelPos.x < 0.0 || pixelPos.x >= (double)this.sceneWidth || pixelPos.y < 0.0 || pixelPos.y >= (double)this.sceneHeight) {
            pixelPos.x = -1.0;
            pixelPos.y = -1.0;
        }
        return pixelPos;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        Point2D point = this.forwardMap.getValue(pixelPos);
        this.rotator.transformInversely(point);
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setLocation(point.getY(), point.getX());
        return geoPos;
    }

    @Override
    public Datum getDatum() {
        return this.datum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcpGeoCoding that = (GcpGeoCoding)o;
        if (!Arrays.equals(this.lats, that.lats)) {
            return false;
        }
        if (!Arrays.equals(this.lons, that.lons)) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (!Arrays.equals(this.x, that.x)) {
            return false;
        }
        return Arrays.equals(this.y, that.y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        result = 31 * result + Arrays.hashCode(this.lons);
        result = 31 * result + Arrays.hashCode(this.lats);
        result = 31 * result + this.method.hashCode();
        return result;
    }

    @Override
    public void dispose() {
        this.rotator = null;
        this.datum = null;
        this.forwardMap = null;
        this.inverseMap = null;
    }

    public double getRmseLon() {
        return this.forwardMap.getRmseU();
    }

    public double getRmseLat() {
        return this.forwardMap.getRmseV();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setOriginalGeoCoding(GeoCoding geoCoding) {
        this.originalGeoCoding = geoCoding;
    }

    public GeoCoding getOriginalGeoCoding() {
        return this.originalGeoCoding;
    }

    public void setGcps(Placemark[] gcps) {
        this.initCoordinates(gcps);
        this.initTransformations(this.method);
        this.boundaryCrossingMeridianAt180 = this.isBoundaryCrossingMeridianAt180();
    }

    private boolean isBoundaryCrossingMeridianAt180() {
        int i;
        GeoPos geoPos1 = null;
        GeoPos geoPos2 = null;
        GeoPos geoPos3 = null;
        GeoPos geoPos4 = null;
        for (i = 0; i < this.sceneWidth; ++i) {
            geoPos1 = this.getGeoPos(new PixelPos((float)i + 0.5f, 0.0), geoPos1);
            geoPos2 = this.getGeoPos(new PixelPos((float)i + 1.5f, 0.0), geoPos2);
            geoPos3 = this.getGeoPos(new PixelPos((float)i + 0.5f, this.sceneHeight), geoPos3);
            geoPos4 = this.getGeoPos(new PixelPos((float)i + 1.5f, this.sceneHeight), geoPos4);
            if (!GcpGeoCoding.isSegmentCrossingMeridianAt180(geoPos1.lon, geoPos2.lon) && !GcpGeoCoding.isSegmentCrossingMeridianAt180(geoPos3.lon, geoPos4.lon)) continue;
            return true;
        }
        for (i = 0; i < this.sceneHeight; ++i) {
            geoPos1 = this.getGeoPos(new PixelPos(0.0, (float)i + 0.5f), geoPos1);
            geoPos2 = this.getGeoPos(new PixelPos(0.0, (float)i + 1.5f), geoPos2);
            geoPos3 = this.getGeoPos(new PixelPos(this.sceneWidth, (float)i + 0.5f), geoPos3);
            geoPos4 = this.getGeoPos(new PixelPos(this.sceneWidth, (float)i + 1.5f), geoPos4);
            if (!GcpGeoCoding.isSegmentCrossingMeridianAt180(geoPos1.lon, geoPos2.lon) && !GcpGeoCoding.isSegmentCrossingMeridianAt180(geoPos3.lon, geoPos4.lon)) continue;
            return true;
        }
        return false;
    }

    private void initTransformations(Method type) {
        GeoPos center = GcpGeoCoding.calculateCentralGeoPos(this.lons, this.lats);
        double[] lons2 = Arrays.copyOf(this.lons, this.lons.length);
        double[] lats2 = Arrays.copyOf(this.lats, this.lats.length);
        this.rotator = new Rotator(center.lon, center.lat);
        this.rotator.transform(lons2, lats2);
        this.forwardMap = new RationalFunctionMap2D(type.getDegreeP(), type.getDegreeQ(), this.x, this.y, lons2, lats2);
        this.inverseMap = new RationalFunctionMap2D(type.getDegreeP(), type.getDegreeQ(), lons2, lats2, this.x, this.y);
    }

    private static boolean isSegmentCrossingMeridianAt180(double lon, double lon2) {
        return Math.abs(lon) > 90.0 && Math.abs(lon2) > 90.0 && lon * lon2 < 0.0;
    }

    private static void calculateXYZ(double[] lons, double[] lats, double[] x, double[] y, double[] z) {
        for (int i = 0; i < lats.length; ++i) {
            double u = Math.toRadians(lons[i]);
            double v = Math.toRadians(lats[i]);
            double w = Math.cos(v);
            x[i] = Math.cos(u) * w;
            y[i] = Math.sin(u) * w;
            z[i] = Math.sin(v);
        }
    }

    static GeoPos calculateCentralGeoPos(double[] lons, double[] lats) {
        int size = lats.length;
        double[] x = new double[size];
        double[] y = new double[size];
        double[] z = new double[size];
        GcpGeoCoding.calculateXYZ(lons, lats, x, y, z);
        double xc = 0.0;
        double yc = 0.0;
        double zc = 0.0;
        for (int i = 0; i < size; ++i) {
            xc += x[i];
            yc += y[i];
            zc += z[i];
        }
        double length = Math.sqrt(xc * xc + yc * yc + zc * zc);
        double lat = Math.toDegrees(Math.asin(zc /= length));
        double lon = Math.toDegrees(Math.atan2(yc /= length, xc /= length));
        return new GeoPos(lat, lon);
    }

    private void initCoordinates(Placemark[] gcps) {
        for (Placemark gcp : gcps) {
            PixelPos pixelPos = gcp.getPixelPos();
            GeoPos geoPos = gcp.getGeoPos();
            if (pixelPos != null && pixelPos.isValid() && geoPos != null && geoPos.isValid()) continue;
            throw new IllegalArgumentException("Invalid ground control point.");
        }
        this.x = new double[gcps.length];
        this.y = new double[gcps.length];
        this.lons = new double[gcps.length];
        this.lats = new double[gcps.length];
        for (int i = 0; i < gcps.length; ++i) {
            PixelPos pixelPos = gcps[i].getPixelPos();
            this.x[i] = pixelPos.getX();
            this.y[i] = pixelPos.getY();
            GeoPos geoPos = gcps[i].getGeoPos();
            this.lons[i] = geoPos.getLon();
            this.lats[i] = geoPos.getLat();
        }
    }

    public static enum Method {
        POLYNOMIAL1("Linear Polynomial", 1),
        POLYNOMIAL2("Quadratic Polynomial", 2),
        POLYNOMIAL3("Cubic Polynomial", 3);

        private String name;
        private int degreeP;
        private int degreeQ;

        private Method(String name, int degreeP) {
            this(name, degreeP, 0);
        }

        private Method(String name, int degreeP, int degreeQ) {
            this.name = name;
            this.degreeP = degreeP;
            this.degreeQ = degreeQ;
        }

        public String getName() {
            return this.name;
        }

        public int getDegreeP() {
            return this.degreeP;
        }

        private int getDegreeQ() {
            return this.degreeQ;
        }

        public int getTermCountP() {
            return (this.getDegreeP() + 1) * (this.getDegreeP() + 2) / 2;
        }

        private int getTermCountQ() {
            return (this.getDegreeQ() + 1) * (this.getDegreeQ() + 2) / 2 - 1;
        }

        public String toString() {
            return this.name;
        }
    }

    static class RationalFunctionMap2D {
        private final RationalFunctionModel um;
        private final RationalFunctionModel vm;

        RationalFunctionMap2D(int degreeP, int degreeQ, double[] x, double[] y, double[] u, double[] v) {
            this.um = new RationalFunctionModel(degreeP, degreeQ, x, y, u);
            this.vm = new RationalFunctionModel(degreeP, degreeQ, x, y, v);
        }

        public final Point2D getValue(Point2D point) {
            return this.getValue(point.getX(), point.getY());
        }

        public final Point2D getValue(double x, double y) {
            return new Point2D.Double(this.um.getValue(x, y), this.vm.getValue(x, y));
        }

        public double getRmseU() {
            return this.um.getRmse();
        }

        public double getRmseV() {
            return this.vm.getRmse();
        }
    }
}

