/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.util.math.FXYSum;

public class FXYGeoCoding
extends AbstractGeoCoding {
    private final float _pixelOffsetX;
    private final float _pixelOffsetY;
    private final float _pixelSizeX;
    private final float _pixelSizeY;
    private final FXYSum _pixelXFunction;
    private final FXYSum _pixelYFunction;
    private final FXYSum _latFunction;
    private final FXYSum _lonFunction;
    private final Datum _datum;

    public FXYGeoCoding(float pixelOffsetX, float pixelOffsetY, float pixelSizeX, float pixelSizeY, FXYSum xFunction, FXYSum yFunction, FXYSum latFunction, FXYSum lonFunction, Datum datum) {
        this._pixelOffsetX = pixelOffsetX;
        this._pixelOffsetY = pixelOffsetY;
        this._pixelSizeX = pixelSizeX;
        this._pixelSizeY = pixelSizeY;
        this._pixelXFunction = xFunction;
        this._pixelYFunction = yFunction;
        this._latFunction = latFunction;
        this._lonFunction = lonFunction;
        this._datum = datum;
    }

    public float getPixelOffsetX() {
        return this._pixelOffsetX;
    }

    public float getPixelOffsetY() {
        return this._pixelOffsetY;
    }

    public float getPixelSizeX() {
        return this._pixelSizeX;
    }

    public float getPixelSizeY() {
        return this._pixelSizeY;
    }

    public FXYSum getPixelXFunction() {
        return this._pixelXFunction;
    }

    public FXYSum getPixelYFunction() {
        return this._pixelYFunction;
    }

    public FXYSum getLatFunction() {
        return this._latFunction;
    }

    public FXYSum getLonFunction() {
        return this._lonFunction;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return false;
    }

    @Override
    public boolean canGetPixelPos() {
        return true;
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        pixelPos.setInvalid();
        double x = this._pixelXFunction.computeZ(geoPos.getLat(), geoPos.getLon());
        double y = this._pixelYFunction.computeZ(geoPos.getLat(), geoPos.getLon());
        pixelPos.setLocation((x - (double)this._pixelOffsetX) / (double)this._pixelSizeX, (y - (double)this._pixelOffsetY) / (double)this._pixelSizeY);
        return pixelPos;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos(0.0, 0.0);
        }
        double x = (double)this._pixelOffsetX + (double)this._pixelSizeX * pixelPos.x;
        double y = (double)this._pixelOffsetY + (double)this._pixelSizeY * pixelPos.y;
        double lat = this._latFunction.computeZ(x, y);
        double lon = this._lonFunction.computeZ(x, y);
        geoPos.setLocation(lat, lon);
        return geoPos;
    }

    @Override
    public Datum getDatum() {
        return this._datum;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        float pixelOffsetX = this.getPixelOffsetX();
        float pixelOffsetY = this.getPixelOffsetY();
        float pixelSizeX = this.getPixelSizeX();
        float pixelSizeY = this.getPixelSizeY();
        if (subsetDef != null) {
            if (subsetDef.getRegion() != null) {
                pixelOffsetX = (float)((double)pixelOffsetX + subsetDef.getRegion().getX() * (double)pixelSizeX);
                pixelOffsetY = (float)((double)pixelOffsetY + subsetDef.getRegion().getY() * (double)pixelSizeY);
            }
            pixelSizeX *= (float)subsetDef.getSubSamplingX();
            pixelSizeY *= (float)subsetDef.getSubSamplingY();
        }
        destScene.setGeoCoding(this.createCloneWithNewOffsetAndSize(pixelOffsetX, pixelOffsetY, pixelSizeX, pixelSizeY));
        return true;
    }

    public FXYGeoCoding createCloneWithNewOffsetAndSize(float pixelOffsetX, float pixelOffsetY, float pixelSizeX, float pixelSizeY) {
        FXYSum pixelXFunction = FXYSum.createCopy(this._pixelXFunction);
        FXYSum pixelYFunction = FXYSum.createCopy(this._pixelYFunction);
        FXYSum latFunction = FXYSum.createCopy(this._latFunction);
        FXYSum lonFunction = FXYSum.createCopy(this._lonFunction);
        return new FXYGeoCoding(pixelOffsetX, pixelOffsetY, pixelSizeX, pixelSizeY, pixelXFunction, pixelYFunction, latFunction, lonFunction, this._datum);
    }
}

