/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.text.MessageFormat;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;

public abstract class DataNode
extends ProductNode {
    public static final String PROPERTY_NAME_DATA = "data";
    public static final String PROPERTY_NAME_READ_ONLY = "readOnly";
    public static final String PROPERTY_NAME_SYNTHETIC = "synthetic";
    public static final String PROPERTY_NAME_UNIT = "unit";
    private final int dataType;
    private final long numElems;
    private ProductData data;
    private boolean readOnly;
    private String unit;
    private boolean synthetic;

    public DataNode(String name, int dataType, long numElems) {
        super(name);
        if (dataType != 10 && dataType != 11 && dataType != 12 && dataType != 20 && dataType != 21 && dataType != 22 && dataType != 30 && dataType != 31 && dataType != 41 && dataType != 51) {
            throw new IllegalArgumentException("dataType is invalid");
        }
        this.dataType = dataType;
        this.numElems = numElems;
        this.data = null;
        this.readOnly = false;
    }

    public DataNode(String name, ProductData data, boolean readOnly) {
        super(name);
        Guardian.assertNotNull(PROPERTY_NAME_DATA, data);
        this.dataType = data.getType();
        this.numElems = data.getNumElems();
        this.data = data;
        this.readOnly = readOnly;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isFloatingPointType() {
        return ProductData.isFloatingPointType(this.dataType);
    }

    public long getNumDataElems() {
        this.checkState();
        return this.numElems;
    }

    public void setData(ProductData data) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("data node '" + this.getName() + "' is read-only");
        }
        if (this.data == data) {
            return;
        }
        if (data != null) {
            this.checkDataCompatibility(data);
        }
        ProductData oldData = this.data;
        this.data = data;
        this.fireProductNodeChanged(PROPERTY_NAME_DATA, oldData, data);
        this.fireProductNodeDataChanged();
        if (oldData != null) {
            this.setModified(true);
        }
    }

    public ProductData getData() {
        return this.data;
    }

    public void setDataElems(Object elems) {
        Object oldData;
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("attribute is read-only");
        }
        this.checkState();
        if (this.data == null) {
            if (this.numElems > Integer.MAX_VALUE) {
                throw new IllegalStateException("number of elements must be less than 21474836471");
            }
            this.data = this.createCompatibleProductData((int)this.numElems);
        }
        if (!ObjectUtils.equalObjects(oldData = this.data.getElems(), elems)) {
            this.data.setElems(elems);
            this.fireProductNodeDataChanged();
            this.setModified(true);
        }
    }

    public Object getDataElems() {
        return this.getData() == null ? null : this.getData().getElems();
    }

    public int getDataElemSize() {
        return ProductData.getElemSize(this.getDataType());
    }

    public void setReadOnly(boolean readOnly) {
        boolean oldValue = this.readOnly;
        if (oldValue != readOnly) {
            this.readOnly = readOnly;
            this.fireProductNodeChanged(PROPERTY_NAME_READ_ONLY, oldValue, readOnly);
            this.setModified(true);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setUnit(String unit) {
        String oldValue = this.unit;
        if (!ObjectUtils.equalObjects(oldValue, unit)) {
            this.unit = unit;
            this.fireProductNodeChanged(PROPERTY_NAME_UNIT, oldValue, unit);
            this.setModified(true);
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        boolean oldValue = this.synthetic;
        if (oldValue != synthetic) {
            this.synthetic = synthetic;
            this.fireProductNodeChanged(PROPERTY_NAME_SYNTHETIC, oldValue, synthetic);
            this.setModified(true);
        }
    }

    public void fireProductNodeDataChanged() {
        Product product = this.getProduct();
        if (product != null) {
            product.fireNodeDataChanged(this);
        }
    }

    protected void checkDataCompatibility(ProductData data) throws IllegalArgumentException {
        Debug.assertNotNull(data);
        if (data.getType() != this.getDataType()) {
            String msgPattern = "Illegal data for data node ''{0}'', type {1} expected";
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, this.getName(), ProductData.getTypeString(this.getDataType())));
        }
        if ((long)data.getNumElems() != this.getNumDataElems()) {
            String msgPattern = "Illegal number of data elements for data node ''{0}'', {1} elements expected but was {2}";
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, this.getName(), this.getNumDataElems(), data.getNumElems()));
        }
    }

    @Override
    public abstract void acceptVisitor(ProductVisitor var1);

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        long size = 0L;
        if (this.isPartOfSubset(subsetDef)) {
            size += 256L;
            size += (long)ProductData.getElemSize(this.getDataType()) * this.getNumDataElems();
        }
        return size;
    }

    @Override
    public void dispose() {
        if (this.data != null) {
            this.data.dispose();
            this.data = null;
        }
        super.dispose();
    }

    public ProductData createCompatibleProductData(int numElems) {
        return ProductData.createInstance(this.getDataType(), numElems);
    }

    private void checkState() {
        if (this.numElems < 0L) {
            throw new IllegalStateException("number of elements must be at last 1");
        }
    }
}

