/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geometry;

import com.bc.ceres.binding.ConversionException;
import java.io.IOException;
import org.esa.snap.core.dataio.geometry.AbstractInterpretationStrategy;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class GeometryAndFeatureTypeStrategy
extends AbstractInterpretationStrategy {
    private String geometryName;
    private String featureTypeName;

    GeometryAndFeatureTypeStrategy(String geometryName, String featureTypeName) {
        this.geometryName = geometryName;
        this.featureTypeName = featureTypeName;
    }

    @Override
    public void setDefaultGeometry(String defaultGeometry, CoordinateReferenceSystem featureCrs, SimpleFeatureTypeBuilder builder) {
        if (defaultGeometry != null) {
            builder.setDefaultGeometry(defaultGeometry);
        }
        builder.setDefaultGeometry(this.geometryName);
    }

    @Override
    public void setName(SimpleFeatureTypeBuilder builder) {
        builder.setName(this.featureTypeName);
    }

    @Override
    public int getExpectedTokenCount(int attributeCount) {
        return attributeCount + 1;
    }

    @Override
    public SimpleFeature interpretLine(String[] tokens, SimpleFeatureBuilder builder, SimpleFeatureType simpleFeatureType) throws IOException, ConversionException {
        for (int columnIndex = 1; columnIndex < tokens.length; ++columnIndex) {
            String token = tokens[columnIndex];
            this.setAttributeValue(builder, simpleFeatureType, columnIndex - 1, token);
        }
        String featureId = this.getFeatureId(tokens);
        return builder.buildFeature(featureId);
    }

    @Override
    public String getFeatureId(String[] tokens) {
        return tokens[0];
    }

    @Override
    public int getStartColumn() {
        return 1;
    }
}

