/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap.spi;

import com.bc.ceres.binding.PropertyContainer;
import java.awt.Color;
import org.esa.snap.core.dataio.dimap.spi.RasterDataNodePersistable;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.jdom.Content;
import org.jdom.Element;

public abstract class MaskPersistable
extends RasterDataNodePersistable {
    @Override
    public final Mask createObjectFromXml(Element element, Product product) {
        int height;
        int width;
        String name = MaskPersistable.getChildAttributeValue(element, "NAME", "value");
        if (element.getChild("MASK_RASTER_WIDTH") != null && element.getChild("MASK_RASTER_HEIGHT") != null) {
            width = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "MASK_RASTER_WIDTH", "value"));
            height = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "MASK_RASTER_HEIGHT", "value"));
        } else {
            width = product.getSceneRasterWidth();
            height = product.getSceneRasterHeight();
        }
        Mask mask = new Mask(name, width, height, this.createImageType());
        mask.setDescription(MaskPersistable.getChildAttributeValue(element, "DESCRIPTION", "value"));
        mask.setImageTransparency(Double.parseDouble(MaskPersistable.getChildAttributeValue(element, "TRANSPARENCY", "value")));
        this.setImageColor(element, mask);
        this.setImageToModelTransform(element, mask);
        this.setAncillaryRelations(element, mask);
        this.setAncillaryVariables(element, mask, product);
        this.configureMask(mask, element);
        return mask;
    }

    private void setImageColor(Element element, Mask mask) {
        int r = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "red"));
        int g = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "green"));
        int b = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "blue"));
        int a = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "alpha"));
        mask.setImageColor(new Color(r, g, b, a));
    }

    @Override
    public final Element createXmlFromObject(Object object) {
        Mask mask = (Mask)object;
        Element root = new Element("Mask");
        root.setAttribute("type", mask.getImageType().getName());
        root.addContent((Content)MaskPersistable.createValueAttributeElement("NAME", mask.getName()));
        root.addContent((Content)MaskPersistable.createValueAttributeElement("MASK_RASTER_WIDTH", String.valueOf(mask.getRasterWidth())));
        root.addContent((Content)MaskPersistable.createValueAttributeElement("MASK_RASTER_HEIGHT", String.valueOf(mask.getRasterHeight())));
        root.addContent((Content)MaskPersistable.createValueAttributeElement("DESCRIPTION", mask.getDescription()));
        this.addAncillaryElements(root, mask);
        this.addImageConfigElements(root, mask);
        this.addImageToModelTransformElement(root, mask);
        this.configureElement(root, mask);
        return root;
    }

    private void addImageConfigElements(Element root, Mask mask) {
        Element colorElement = new Element("COLOR");
        PropertyContainer config = mask.getImageConfig();
        Color color = (Color)config.getValue("color");
        colorElement.setAttribute("red", String.valueOf(color.getRed()));
        colorElement.setAttribute("green", String.valueOf(color.getGreen()));
        colorElement.setAttribute("blue", String.valueOf(color.getBlue()));
        colorElement.setAttribute("alpha", String.valueOf(color.getAlpha()));
        root.addContent((Content)colorElement);
        Object transparencyValue = config.getValue("transparency");
        String transparency = String.valueOf(transparencyValue);
        root.addContent((Content)MaskPersistable.createValueAttributeElement("TRANSPARENCY", transparency));
    }

    protected abstract Mask.ImageType createImageType();

    protected abstract void configureMask(Mask var1, Element var2);

    protected abstract void configureElement(Element var1, Mask var2);

    protected static String getChildAttributeValue(Element element, String childName, String attributeName) {
        return element.getChild(childName).getAttribute(attributeName).getValue();
    }
}

