/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.esa.snap.core.dataio.dimap.DimapProductHelpers;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistable;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistence;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FXYGeoCoding;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.Ellipsoid;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.XmlWriter;
import org.jdom.Element;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public final class DimapHeaderWriter
extends XmlWriter {
    private final Product product;
    private final String dataDirectory;

    public DimapHeaderWriter(Product product, File file, String dataDirectory) throws IOException {
        super(file);
        this.product = product;
        this.dataDirectory = dataDirectory;
    }

    public DimapHeaderWriter(Product product, Writer writer, String dataDirectory) {
        super(writer, true);
        this.product = product;
        this.dataDirectory = dataDirectory;
    }

    public void writeHeader() {
        int indent = 0;
        String[][] attributes = new String[1][];
        String documentName = this.product.getName() + ".dim";
        attributes[0] = new String[]{"name", documentName};
        String[] tags = DimapHeaderWriter.createTags(indent, "Dimap_Document", attributes);
        this.println(tags[0]);
        this.writeMetadataId(++indent);
        this.writeDatasetId(indent);
        this.writeDatasetUse(indent);
        this.writeProductionElements(indent);
        this.writeGeoCoding(indent);
        this.writeFlagCoding(indent);
        this.writeIndexCoding(indent);
        this.writeRasterDimensionElements(indent);
        this.writeDataAccessElements(indent);
        this.writeTiePointGridElements(indent);
        this.writeImageDisplayElements(indent);
        this.writeMasks(indent);
        this.writeImageInterpretationElements(indent);
        this.writeAnnotatonDataSet(indent);
        this.print(tags[1]);
        this.close();
    }

    protected void writeAnnotatonDataSet(int indent) {
        MetadataElement metadataRoot = this.product.getMetadataRoot();
        if (metadataRoot != null && metadataRoot.getNumElements() > 0) {
            String[] dsTags = DimapHeaderWriter.createTags(indent, "Dataset_Sources");
            this.println(dsTags[0]);
            this.writeMetadataElements(indent + 1, new MetadataElement[]{metadataRoot});
            this.println(dsTags[1]);
        }
    }

    protected void writeMetadataElements(int indent, MetadataElement[] elementes) {
        if (elementes == null) {
            return;
        }
        for (MetadataElement element : elementes) {
            String[][] attributes;
            String description = element.getDescription();
            if (description != null) {
                attributes = new String[2][];
                attributes[1] = new String[]{"desc", description};
            } else {
                attributes = new String[][]{{"name", element.getName()}};
            }
            String[] meTags = DimapHeaderWriter.createTags(indent, "MDElem", attributes);
            if (element.getNumElements() == 0 && element.getNumAttributes() == 0) {
                this.printLine(meTags, null);
                continue;
            }
            this.println(meTags[0]);
            this.writeMetadataAttributes(indent + 1, element.getAttributes());
            this.writeMetadataElements(indent + 1, element.getElements());
            this.println(meTags[1]);
        }
    }

    protected void writeMetadataAttributes(int indent, MetadataAttribute[] attributes) {
        if (attributes == null) {
            return;
        }
        for (MetadataAttribute attribute : attributes) {
            String unit;
            Vector<String[]> xmlAttribs = new Vector<String[]>();
            xmlAttribs.add(new String[]{"name", attribute.getName()});
            String description = attribute.getDescription();
            if (description != null) {
                xmlAttribs.add(new String[]{"desc", description});
            }
            if ((unit = attribute.getUnit()) != null) {
                xmlAttribs.add(new String[]{"unit", unit});
            }
            String dataTypeString = attribute.getData().getTypeString();
            xmlAttribs.add(new String[]{"type", dataTypeString});
            if (!attribute.isReadOnly()) {
                xmlAttribs.add(new String[]{"mode", "rw"});
            }
            if (attribute.getNumDataElems() > 1L && !"ascii".equals(dataTypeString) && !"utc".equals(dataTypeString)) {
                xmlAttribs.add(new String[]{"elems", String.valueOf(attribute.getNumDataElems())});
            }
            String text = attribute.getData().getElemString();
            String[][] attribs = (String[][])xmlAttribs.toArray((T[])new String[0][]);
            this.printLine(indent, "MDATTR", attribs, text);
        }
    }

    protected void writeImageInterpretationElements(int indent) {
        boolean hasBands;
        Band[] bands = this.product.getBands();
        boolean bl = hasBands = bands != null && bands.length > 0;
        if (hasBands) {
            String[] iiTags = DimapHeaderWriter.createTags(indent, "Image_Interpretation");
            this.println(iiTags[0]);
            for (int i = 0; i < bands.length; ++i) {
                String validMaskExpression;
                IndexCoding indexCoding;
                Band band = bands[i];
                if (band instanceof FilterBand) {
                    DimapPersistable persistable = DimapPersistence.getPersistable(band);
                    if (persistable == null) continue;
                    Element xmlFromObject = persistable.createXmlFromObject(band);
                    this.printElement(indent + 1, xmlFromObject);
                    continue;
                }
                String[] sbiTags = DimapHeaderWriter.createTags(indent + 1, "Spectral_Band_Info");
                this.println(sbiTags[0]);
                this.printLine(indent + 2, "BAND_INDEX", i);
                this.printLine(indent + 2, "BAND_DESCRIPTION", band.getDescription());
                this.printLine(indent + 2, "BAND_NAME", band.getName());
                this.printLine(indent + 2, "BAND_RASTER_WIDTH", band.getRasterWidth());
                this.printLine(indent + 2, "BAND_RASTER_HEIGHT", band.getRasterHeight());
                this.printLine(indent + 2, "DATA_TYPE", ProductData.getTypeString(band.getDataType()));
                String unit = band.getUnit();
                if (unit != null && unit.length() > 0) {
                    this.printLine(indent + 2, "PHYSICAL_UNIT", unit);
                }
                this.printLine(indent + 2, "SOLAR_FLUX", band.getSolarFlux());
                if (band.getSpectralBandIndex() > -1) {
                    this.printLine(indent + 2, "SPECTRAL_BAND_INDEX", band.getSpectralBandIndex());
                }
                this.printLine(indent + 2, "BAND_WAVELEN", band.getSpectralWavelength());
                this.printLine(indent + 2, "BANDWIDTH", band.getSpectralBandwidth());
                FlagCoding flagCoding = band.getFlagCoding();
                if (flagCoding != null) {
                    this.printLine(indent + 2, "FLAG_CODING_NAME", flagCoding.getName());
                }
                if ((indexCoding = band.getIndexCoding()) != null) {
                    this.printLine(indent + 2, "INDEX_CODING_NAME", indexCoding.getName());
                }
                this.printLine(indent + 2, "SCALING_FACTOR", band.getScalingFactor());
                this.printLine(indent + 2, "SCALING_OFFSET", band.getScalingOffset());
                this.printLine(indent + 2, "LOG10_SCALED", band.isLog10Scaled());
                this.printLine(indent + 2, "NO_DATA_VALUE_USED", band.isNoDataValueUsed());
                this.printLine(indent + 2, "NO_DATA_VALUE", band.getNoDataValue());
                if (band instanceof VirtualBand) {
                    VirtualBand vb = (VirtualBand)band;
                    this.printLine(indent + 2, "VIRTUAL_BAND", true);
                    this.printLine(indent + 2, "EXPRESSION", vb.getExpression());
                }
                if ((validMaskExpression = band.getValidPixelExpression()) != null) {
                    this.printLine(indent + 2, "VALID_MASK_TERM", validMaskExpression);
                }
                this.writeAncillaryInformation(band, indent);
                this.writeImageToModelTransform(band, indent);
                this.println(sbiTags[1]);
            }
            this.println(iiTags[1]);
        }
    }

    private void writeAncillaryInformation(RasterDataNode rasterDataNode, int indent) {
        RasterDataNode[] ancillaryVariables;
        String[] ancillaryRelations;
        for (String ancillaryRelation : ancillaryRelations = rasterDataNode.getAncillaryRelations()) {
            this.printLine(indent + 2, "ANCILLARY_RELATION", ancillaryRelation);
        }
        for (RasterDataNode ancillaryVariable : ancillaryVariables = rasterDataNode.getAncillaryVariables(new String[0])) {
            this.printLine(indent + 2, "ANCILLARY_VARIABLE", ancillaryVariable.getName());
        }
    }

    private void writeImageToModelTransform(RasterDataNode rasterDataNode, int indent) {
        AffineTransform imageToModelTransform = rasterDataNode.getImageToModelTransform();
        if (!imageToModelTransform.isIdentity()) {
            double[] matrix = new double[6];
            imageToModelTransform.getMatrix(matrix);
            this.printLine(indent + 2, "IMAGE_TO_MODEL_TRANSFORM", StringUtils.arrayToCsv(matrix));
        }
    }

    protected void writeMasks(int indent) {
        Mask[] masks = (Mask[])this.product.getMaskGroup().toArray(new Mask[this.product.getMaskGroup().getNodeCount()]);
        int persistableMaskCount = 0;
        for (Mask mask : masks) {
            DimapPersistable persistable = DimapPersistence.getPersistable(mask);
            if (persistable == null) continue;
            ++persistableMaskCount;
        }
        if (persistableMaskCount > 0) {
            String[] bdTags = DimapHeaderWriter.createTags(indent, "Masks");
            this.println(bdTags[0]);
            for (Mask mask : masks) {
                DimapPersistable persistable = DimapPersistence.getPersistable(mask);
                if (persistable == null) continue;
                Element element = persistable.createXmlFromObject(mask);
                this.printElement(indent + 1, element);
            }
            this.println(bdTags[1]);
        }
    }

    protected void writeImageDisplayElements(int indent) {
        StringWriter stringWriter = new StringWriter();
        XmlWriter sXmlW = new XmlWriter(stringWriter, false);
        RasterDataNode[] bands = this.product.getBands();
        String[] idTags = DimapHeaderWriter.createTags(indent, "Image_Display");
        this.writeBandStatistics(sXmlW, indent, (Band[])bands);
        this.writeMaskUsages(sXmlW, indent + 1, bands);
        this.writeMaskUsages(sXmlW, indent + 1, this.product.getTiePointGrids());
        sXmlW.close();
        String childTags = stringWriter.toString();
        if (childTags != null && childTags.length() > 0) {
            this.println(idTags[0]);
            this.print(childTags);
            this.println(idTags[1]);
        }
    }

    protected void writeBandStatistics(XmlWriter sXmlW, int indent, Band[] bands) {
        Debug.assertNotNull(sXmlW);
        Debug.assertNotNull(bands);
        for (int i = 0; i < bands.length; ++i) {
            Band band = bands[i];
            if (band.getImageInfo() == null) continue;
            String[] bsTags = DimapHeaderWriter.createTags(indent + 1, "Band_Statistics");
            sXmlW.println(bsTags[0]);
            sXmlW.printLine(indent + 2, "BAND_INDEX", i);
            if (band.isStxSet()) {
                sXmlW.printLine(indent + 2, "STX_MIN", band.getStx().getMinimum());
                sXmlW.printLine(indent + 2, "STX_MAX", band.getStx().getMaximum());
                sXmlW.printLine(indent + 2, "STX_MEAN", band.getStx().getMean());
                sXmlW.printLine(indent + 2, "STX_STD_DEV", band.getStx().getStandardDeviation());
                sXmlW.printLine(indent + 2, "STX_RES_LEVEL", band.getStx().getResolutionLevel());
                int[] bins = band.getStx().getHistogramBins();
                if (bins != null && bins.length > 0) {
                    sXmlW.printLine(indent + 2, "HISTOGRAM", StringUtils.arrayToCsv(bins));
                }
            }
            if (band.getImageInfo() != null) {
                ColorPaletteDef paletteDefinition = band.getImageInfo().getColorPaletteDef();
                sXmlW.printLine(indent + 2, "NUM_COLORS", paletteDefinition.getNumColors());
                Iterator iterator = paletteDefinition.getIterator();
                while (iterator.hasNext()) {
                    ColorPaletteDef.Point point = (ColorPaletteDef.Point)iterator.next();
                    String[] cppTags = DimapHeaderWriter.createTags(indent + 2, "Color_Palette_Point");
                    sXmlW.println(cppTags[0]);
                    sXmlW.printLine(indent + 3, "SAMPLE", point.getSample());
                    if (StringUtils.isNotNullAndNotEmpty(point.getLabel())) {
                        sXmlW.printLine(indent + 3, "LABEL", point.getLabel());
                    }
                    DimapProductHelpers.printColorTag(indent + 3, "COLOR", point.getColor(), sXmlW);
                    sXmlW.println(cppTags[1]);
                }
                DimapProductHelpers.printColorTag(indent + 2, "NO_DATA_COLOR", band.getImageInfo().getNoDataColor(), sXmlW);
                sXmlW.printLine(indent + 2, "HISTOGRAM_MATCHING", band.getImageInfo().getHistogramMatching().toString());
            }
            sXmlW.println(bsTags[1]);
        }
    }

    protected void writeMaskUsages(XmlWriter pw, int indent, RasterDataNode[] rasterDataNodes) {
        Guardian.assertNotNull("pw", pw);
        Guardian.assertNotNull("rasterDataNodes", rasterDataNodes);
        for (int i = 0; i < rasterDataNodes.length; ++i) {
            RasterDataNode rasterDataNode = rasterDataNodes[i];
            ProductNodeGroup<Mask> overlayMaskGroup = rasterDataNode.getOverlayMaskGroup();
            if (overlayMaskGroup.getNodeCount() <= 0) continue;
            String[] boTags = DimapHeaderWriter.createTags(indent, "Mask_Usage");
            pw.println(boTags[0]);
            if (rasterDataNode instanceof Band) {
                pw.printLine(indent + 1, "BAND_INDEX", i);
            } else {
                pw.printLine(indent + 1, "TIE_POINT_GRID_INDEX", i);
            }
            String[][] attributes = new String[1][];
            if (overlayMaskGroup.getNodeCount() > 0) {
                attributes[0] = new String[]{"names", StringUtils.arrayToCsv(overlayMaskGroup.getNodeNames())};
                pw.printLine(indent + 1, "OVERLAY", attributes, null);
            }
            pw.println(boTags[1]);
        }
    }

    protected void writeTiePointGridElements(int indent) {
        TiePointGrid[] tiePointGrids = this.product.getTiePointGrids();
        if (tiePointGrids != null && tiePointGrids.length > 0) {
            String[] tpgTags = DimapHeaderWriter.createTags(indent, "Tie_Point_Grids");
            this.println(tpgTags[0]);
            this.printLine(indent + 1, "NUM_TIE_POINT_GRIDS", tiePointGrids.length);
            for (int i = 0; i < tiePointGrids.length; ++i) {
                TiePointGrid tiePointGrid = tiePointGrids[i];
                String[] tpgInfoTags = DimapHeaderWriter.createTags(indent + 1, "Tie_Point_Grid_Info");
                this.println(tpgInfoTags[0]);
                this.printLine(indent + 2, "TIE_POINT_GRID_INDEX", i);
                this.printLine(indent + 2, "TIE_POINT_DESCRIPTION", tiePointGrid.getDescription());
                this.printLine(indent + 2, "PHYSICAL_UNIT", tiePointGrid.getUnit());
                this.printLine(indent + 2, "TIE_POINT_GRID_NAME", tiePointGrid.getName());
                this.printLine(indent + 2, "DATA_TYPE", ProductData.getTypeString(tiePointGrid.getDataType()));
                this.printLine(indent + 2, "NCOLS", tiePointGrid.getGridWidth());
                this.printLine(indent + 2, "NROWS", tiePointGrid.getGridHeight());
                this.printLine(indent + 2, "OFFSET_X", tiePointGrid.getOffsetX());
                this.printLine(indent + 2, "OFFSET_Y", tiePointGrid.getOffsetY());
                this.printLine(indent + 2, "STEP_X", tiePointGrid.getSubSamplingX());
                this.printLine(indent + 2, "STEP_Y", tiePointGrid.getSubSamplingY());
                boolean cyclic = tiePointGrid.getDiscontinuity() != 0;
                this.printLine(indent + 2, "CYCLIC", cyclic);
                this.writeAncillaryInformation(tiePointGrid, indent);
                this.writeImageToModelTransform(tiePointGrid, indent);
                this.println(tpgInfoTags[1]);
            }
            this.println(tpgTags[1]);
        }
    }

    protected void writeDataAccessElements(int indent) {
        if (this.product.getNumBands() > 0 || this.product.getNumTiePointGrids() > 0) {
            String[][] attributes;
            String href;
            String[] daTags = DimapHeaderWriter.createTags(indent, "Data_Access");
            this.println(daTags[0]);
            this.printLine(indent + 1, "DATA_FILE_FORMAT", "ENVI");
            this.printLine(indent + 1, "DATA_FILE_FORMAT_DESC", "ENVI File Format");
            this.printLine(indent + 1, "DATA_FILE_ORGANISATION", "BAND_SEPARATE");
            Band[] bands = this.product.getBands();
            for (int i = 0; i < bands.length; ++i) {
                Band band = bands[i];
                if (band instanceof VirtualBand || band instanceof FilterBand) continue;
                String[] dfTags = DimapHeaderWriter.createTags(indent + 1, "Data_File");
                this.println(dfTags[0]);
                href = this.dataDirectory + "/" + band.getName() + ".hdr";
                attributes = new String[][]{{"href", href}};
                this.printLine(indent + 2, "DATA_FILE_PATH", attributes, null);
                this.printLine(indent + 2, "BAND_INDEX", i);
                this.println(dfTags[1]);
            }
            String[] tpgNames = this.product.getTiePointGridNames();
            for (int i = 0; i < tpgNames.length; ++i) {
                String[] tpgfTags = DimapHeaderWriter.createTags(indent + 1, "Tie_Point_Grid_File");
                this.println(tpgfTags[0]);
                href = this.dataDirectory + "/" + "tie_point_grids" + "/" + tpgNames[i] + ".hdr";
                attributes = new String[][]{{"href", href}};
                this.printLine(indent + 2, "TIE_POINT_GRID_FILE_PATH", attributes, null);
                this.printLine(indent + 2, "TIE_POINT_GRID_INDEX", i);
                this.println(tpgfTags[1]);
            }
            this.println(daTags[1]);
        }
    }

    protected void writeRasterDimensionElements(int indent) {
        String[] rdTags = DimapHeaderWriter.createTags(indent, "Raster_Dimensions");
        this.println(rdTags[0]);
        this.printLine(indent + 1, "NCOLS", this.product.getSceneRasterWidth());
        this.printLine(indent + 1, "NROWS", this.product.getSceneRasterHeight());
        this.printLine(indent + 1, "NBANDS", this.product.getNumBands());
        this.println(rdTags[1]);
    }

    protected void writeFlagCoding(int indent) {
        SampleCoding[] a = (SampleCoding[])this.product.getFlagCodingGroup().toArray(new FlagCoding[0]);
        this.writeSampleCodings(indent, a, "Flag_Coding", "Flag", "Flag_Name", "Flag_Index", "Flag_description");
    }

    protected void writeIndexCoding(int indent) {
        SampleCoding[] a = (SampleCoding[])this.product.getIndexCodingGroup().toArray(new IndexCoding[0]);
        this.writeSampleCodings(indent, a, "Index_Coding", "Index", "INDEX_NAME", "INDEX_VALUE", "INDEX_DESCRIPTION");
    }

    private void writeSampleCodings(int indent, SampleCoding[] a, String tagCoding, String tagFlag, String tagName, String tagIndex, String tagDescription) {
        for (SampleCoding sampleCoding : a) {
            String[][] attributes = new String[][]{{"name", sampleCoding.getName()}};
            String[] fcTags = DimapHeaderWriter.createTags(indent, tagCoding, attributes);
            this.println(fcTags[0]);
            this.writeSampleCoding(indent, sampleCoding, fcTags, tagFlag, tagName, tagIndex, tagDescription);
        }
    }

    private void writeSampleCoding(int indent, SampleCoding sampleCoding, String[] fcTags, String tagFlag, String tagName, String tagIndex, String tagDescription) {
        String[] names;
        for (String name : names = sampleCoding.getAttributeNames()) {
            MetadataAttribute attribute = sampleCoding.getAttribute(name);
            String[] fTags = DimapHeaderWriter.createTags(indent + 1, tagFlag);
            this.println(fTags[0]);
            this.printLine(indent + 2, tagName, attribute.getName());
            this.printLine(indent + 2, tagIndex, attribute.getData().getElemInt());
            this.printLine(indent + 2, tagDescription, attribute.getDescription());
            this.println(fTags[1]);
        }
        this.println(fcTags[1]);
    }

    protected void writeGeoCoding(int indent) {
        if (this.product.isUsingSingleGeoCoding()) {
            this.writeGeoCoding(this.product.getSceneGeoCoding(), indent, -1);
        } else {
            Band[] bands = this.product.getBands();
            for (int i = 0; i < bands.length; ++i) {
                Band band = bands[i];
                this.writeGeoCoding(band.getGeoCoding(), indent, i);
            }
        }
    }

    private void writeGeoCoding(GeoCoding geoCoding, int indent, int index) {
        if (geoCoding != null) {
            DimapPersistable persistable = DimapPersistence.getPersistable(geoCoding);
            if (persistable != null) {
                String[] geopositionTags = DimapHeaderWriter.createTags(indent, "Geoposition");
                this.println(geopositionTags[0]);
                this.writeBandIndexIf(index >= 0, index, indent + 1);
                this.printElement(indent + 1, persistable.createXmlFromObject(geoCoding));
                this.println(geopositionTags[1]);
            } else if (geoCoding instanceof TiePointGeoCoding) {
                this.writeGeoCoding((TiePointGeoCoding)geoCoding, indent, index);
            } else if (geoCoding instanceof MapGeoCoding) {
                this.writeGeoCoding((MapGeoCoding)geoCoding, indent);
            } else if (geoCoding instanceof BasicPixelGeoCoding) {
                this.writeGeoCoding((BasicPixelGeoCoding)geoCoding, indent, index);
            } else if (geoCoding instanceof FXYGeoCoding) {
                this.writeGeoCoding((FXYGeoCoding)geoCoding, indent, index);
            } else if (geoCoding instanceof GcpGeoCoding) {
                this.writeGeoCoding((GcpGeoCoding)geoCoding, indent, index);
            } else if (geoCoding instanceof CrsGeoCoding) {
                this.writeGeoCoding((CrsGeoCoding)geoCoding, indent, index);
            }
        }
    }

    private void writeGeoCoding(CrsGeoCoding crsGeoCoding, int indent, int index) {
        CoordinateReferenceSystem crs = crsGeoCoding.getMapCRS();
        double[] matrix = new double[6];
        MathTransform transform = crsGeoCoding.getImageToMapTransform();
        if (transform instanceof AffineTransform) {
            ((AffineTransform)transform).getMatrix(matrix);
        }
        String[] crsTags = DimapHeaderWriter.createTags(indent, "Coordinate_Reference_System");
        this.println(crsTags[0]);
        String[] wktTags = DimapHeaderWriter.createTags(indent + 1, "WKT");
        this.println(wktTags[0]);
        char[] wsChars = new char[wktTags[0].length()];
        Arrays.fill(wsChars, ' ');
        String ws = new String(wsChars);
        for (String wktLine : crs.toString().split(SystemUtils.LS)) {
            this.print(ws);
            this.println(wktLine);
        }
        this.println(wktTags[1]);
        this.println(crsTags[1]);
        String[] geopositionTags = DimapHeaderWriter.createTags(indent, "Geoposition");
        this.println(geopositionTags[0]);
        this.writeBandIndexIf(index >= 0, index, indent + 1);
        this.printLine(indent + 1, "IMAGE_TO_MODEL_TRANSFORM", StringUtils.arrayToCsv(matrix));
        this.println(geopositionTags[1]);
    }

    private void writeGeoCoding(GcpGeoCoding gcpPointGeoCoding, int indent, int index) {
        String[] crsTags = DimapHeaderWriter.createTags(indent, "Coordinate_Reference_System");
        this.println(crsTags[0]);
        this.writeDatum(gcpPointGeoCoding.getDatum(), indent + 1);
        this.println(crsTags[1]);
        String[] posTags = DimapHeaderWriter.createTags(indent, "Geoposition");
        this.println(posTags[0]);
        String[] gcpTags = DimapHeaderWriter.createTags(indent + 1, "Geoposition_Points");
        this.println(gcpTags[0]);
        this.printLine(indent + 2, "INTERPOLATION_METHOD", gcpPointGeoCoding.getMethod().name());
        GeoCoding originalGeoCoding = gcpPointGeoCoding.getOriginalGeoCoding();
        if (originalGeoCoding != null && !(originalGeoCoding instanceof GcpGeoCoding)) {
            String[] ogcTags = DimapHeaderWriter.createTags(indent + 2, "Original_Geocoding");
            this.println(ogcTags[0]);
            this.writeGeoCoding(originalGeoCoding, indent + 3, index);
            this.println(ogcTags[1]);
        }
        this.println(gcpTags[1]);
        this.println(posTags[1]);
    }

    private void writeGeoCoding(TiePointGeoCoding tiePointGeoCoding, int indent, int index) {
        String[] crsTags = DimapHeaderWriter.createTags(indent, "Coordinate_Reference_System");
        this.println(crsTags[0]);
        this.writeDatum(tiePointGeoCoding.getDatum(), indent + 1);
        this.println(crsTags[1]);
        String latGridName = tiePointGeoCoding.getLatGrid().getName();
        String lonGridName = tiePointGeoCoding.getLonGrid().getName();
        if (latGridName == null || lonGridName == null) {
            return;
        }
        String[] geopositionTags = DimapHeaderWriter.createTags(indent, "Geoposition");
        this.println(geopositionTags[0]);
        this.writeBandIndexIf(index >= 0, index, indent + 1);
        String[] pointsTags = DimapHeaderWriter.createTags(indent + 1, "Geoposition_Points");
        this.println(pointsTags[0]);
        this.printLine(indent + 2, "TIE_POINT_GRID_NAME_LAT", latGridName);
        this.printLine(indent + 2, "TIE_POINT_GRID_NAME_LON", lonGridName);
        this.println(pointsTags[1]);
        this.println(geopositionTags[1]);
    }

    private void writeBandIndexIf(boolean condition, int index, int indent) {
        if (condition) {
            this.printLine(indent, "BAND_INDEX", String.valueOf(index));
        }
    }

    private void writeGeoCoding(MapGeoCoding mapGeoCoding, int indent) {
        MapInfo info = mapGeoCoding.getMapInfo();
        if (info == null) {
            return;
        }
        String[] crsTags = DimapHeaderWriter.createTags(indent, "Coordinate_Reference_System");
        this.println(crsTags[0]);
        ++indent;
        Datum datum = info.getDatum();
        MapProjection projection = info.getMapProjection();
        Ellipsoid ellipsoid = datum.getEllipsoid();
        MapTransform mapTransform = projection.getMapTransform();
        double[] parameterValues = mapTransform.getParameterValues();
        MapTransformDescriptor descriptor = mapTransform.getDescriptor();
        String datumName = datum.getName();
        String projectionName = projection.getName();
        String ellipsoidName = ellipsoid.getName();
        double semiMajor = ellipsoid.getSemiMajor();
        double semiMinor = ellipsoid.getSemiMinor();
        String typeID = descriptor.getTypeID();
        Parameter[] parameters = descriptor.getParameters();
        this.printLine(indent, "GEO_TABLES", new String[][]{{"version", "1.0"}}, "CUSTOM");
        String[] horizontalCsTags = DimapHeaderWriter.createTags(indent, "Horizontal_CS");
        this.println(horizontalCsTags[0]);
        this.printLine(++indent, "HORIZONTAL_CS_TYPE", "PROJECTED");
        this.printLine(indent, "HORIZONTAL_CS_NAME", projectionName);
        String[] geographicCsTags = DimapHeaderWriter.createTags(indent, "Geographic_CS");
        this.println(geographicCsTags[0]);
        this.printLine(++indent, "GEOGRAPHIC_CS_NAME", projectionName);
        String[] horizontalDatumTags = DimapHeaderWriter.createTags(indent, "Horizontal_Datum");
        this.println(horizontalDatumTags[0]);
        this.printLine(++indent, "HORIZONTAL_DATUM_NAME", datumName);
        String[] ellipsoidTags = DimapHeaderWriter.createTags(indent, "Ellipsoid");
        this.println(ellipsoidTags[0]);
        this.printLine(++indent, "ELLIPSOID_NAME", ellipsoidName);
        String[] ellipsoidParametersTags = DimapHeaderWriter.createTags(indent, "Ellipsoid_Parameters");
        this.println(ellipsoidParametersTags[0]);
        String[][] attributes = new String[][]{{"unit", "meter"}};
        this.printLine(++indent, "ELLIPSOID_MAJ_AXIS", attributes, String.valueOf(semiMajor));
        this.printLine(indent, "ELLIPSOID_MIN_AXIS", attributes, String.valueOf(semiMinor));
        this.println(ellipsoidParametersTags[1]);
        --indent;
        this.println(ellipsoidTags[1]);
        --indent;
        this.println(horizontalDatumTags[1]);
        --indent;
        this.println(geographicCsTags[1]);
        String[] projectionTags = DimapHeaderWriter.createTags(--indent, "Projection");
        this.println(projectionTags[0]);
        this.printLine(++indent, "NAME", projectionName);
        String[] projectionCtMethodTags = DimapHeaderWriter.createTags(indent, "Projection_CT_Method");
        this.println(projectionCtMethodTags[0]);
        this.printLine(++indent, "PROJECTION_CT_NAME", typeID);
        String[] projectionParametersTags = DimapHeaderWriter.createTags(indent, "Projection_Parameters");
        this.println(projectionParametersTags[0]);
        String[] projectionParameterTags = DimapHeaderWriter.createTags(++indent, "Projection_Parameter");
        ++indent;
        String[][] paramUnitAttributes = new String[1][2];
        paramUnitAttributes[0][0] = "unit";
        for (int i = 0; i < parameters.length; ++i) {
            this.println(projectionParameterTags[0]);
            this.printLine(indent, "PROJECTION_PARAMETER_NAME", parameters[i].getName());
            paramUnitAttributes[0][1] = parameters[i].getProperties().getPhysicalUnit();
            this.printLine(indent, "PROJECTION_PARAMETER_VALUE", paramUnitAttributes, String.valueOf(parameterValues[i]));
            this.println(projectionParameterTags[1]);
        }
        --indent;
        this.println(projectionParametersTags[1]);
        --indent;
        this.println(projectionCtMethodTags[1]);
        --indent;
        this.println(projectionTags[1]);
        String[] mi2Tags = DimapHeaderWriter.createTags(--indent, "MAP_INFO");
        this.println(mi2Tags[0]);
        String[][] mapAttrib = new String[][]{{"value", ""}};
        mapAttrib[0][1] = String.valueOf(info.getPixelX());
        this.printLine(++indent, "PIXEL_X", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getPixelY());
        this.printLine(indent, "PIXEL_Y", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getEasting());
        this.printLine(indent, "EASTING", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getNorthing());
        this.printLine(indent, "NORTHING", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getOrientation());
        this.printLine(indent, "ORIENTATION", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getPixelSizeX());
        this.printLine(indent, "PIXELSIZE_X", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getPixelSizeY());
        this.printLine(indent, "PIXELSIZE_Y", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getNoDataValue());
        this.printLine(indent, "NODATA_VALUE", mapAttrib, null);
        mapAttrib[0][1] = info.getMapProjection().getMapUnit();
        this.printLine(indent, "MAPUNIT", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.isOrthorectified());
        this.printLine(indent, "ORTHORECTIFIED", mapAttrib, null);
        mapAttrib[0][1] = info.getElevationModelName();
        this.printLine(indent, "ELEVATION_MODEL", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.isSceneSizeFitted());
        this.printLine(indent, "SCENE_FITTED", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getSceneWidth());
        this.printLine(indent, "SCENE_WIDTH", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getSceneHeight());
        this.printLine(indent, "SCENE_HEIGHT", mapAttrib, null);
        mapAttrib[0][1] = String.valueOf(info.getResampling().getName());
        this.printLine(indent, "RESAMPLING", mapAttrib, null);
        --indent;
        this.println(mi2Tags[1]);
        --indent;
        this.println(horizontalCsTags[1]);
        --indent;
        this.println(crsTags[1]);
    }

    private void writeGeoCoding(BasicPixelGeoCoding pixelGeoCoding, int indent, int index) {
        String latBandName = pixelGeoCoding.getLatBand().getName();
        String lonBandName = pixelGeoCoding.getLonBand().getName();
        String validMask = pixelGeoCoding.getValidMask();
        int searchRadius = pixelGeoCoding.getSearchRadius();
        GeoCoding posEstimator = pixelGeoCoding.getPixelPosEstimator();
        String[] geopositionTags = DimapHeaderWriter.createTags(indent, "Geoposition");
        this.println(geopositionTags[0]);
        this.printLine(indent + 1, "LATITUDE_BAND", latBandName);
        this.printLine(indent + 1, "LONGITUDE_BAND", lonBandName);
        if (validMask != null && !validMask.trim().isEmpty()) {
            this.printLine(indent + 1, "VALID_MASK_EXPRESSION", validMask);
        }
        this.printLine(indent + 1, "SEARCH_RADIUS", searchRadius);
        if (posEstimator != null) {
            String[] pixelPosEstimatorTags = DimapHeaderWriter.createTags(indent + 1, "Pixel_Position_Estimator");
            this.println(pixelPosEstimatorTags[0]);
            this.writeGeoCoding(posEstimator, indent + 2, index);
            this.println(pixelPosEstimatorTags[1]);
        }
        this.println(geopositionTags[1]);
    }

    private void writeGeoCoding(FXYGeoCoding fxyGeoCoding, int indent, int index) {
        if (index <= 0) {
            indent = this.writeFXYCoordRefSystem(fxyGeoCoding, indent);
        }
        String[] gpTags = DimapHeaderWriter.createTags(indent, "Geoposition");
        this.println(gpTags[0]);
        this.writeBandIndexIf(index >= 0, index, ++indent);
        String[] gpiTags = DimapHeaderWriter.createTags(indent, "Geoposition_Insert");
        this.println(gpiTags[0]);
        this.printLine(++indent, "ULXMAP", fxyGeoCoding.getPixelOffsetX());
        this.printLine(indent, "ULYMAP", fxyGeoCoding.getPixelOffsetY());
        this.printLine(indent, "XDIM", fxyGeoCoding.getPixelSizeX());
        this.printLine(indent, "YDIM", fxyGeoCoding.getPixelSizeY());
        this.println(gpiTags[1]);
        String[] slmTags = DimapHeaderWriter.createTags(--indent, "Simplified_Location_Model");
        this.println(slmTags[0]);
        int directOrder = fxyGeoCoding.getLatFunction().getOrder();
        int reverseOrder = fxyGeoCoding.getPixelXFunction().getOrder();
        double[] lambdaCoeffs = fxyGeoCoding.getLonFunction().getCoefficients();
        double[] phiCoeffs = fxyGeoCoding.getLatFunction().getCoefficients();
        double[] xCoeffs = fxyGeoCoding.getPixelXFunction().getCoefficients();
        double[] yCoeffs = fxyGeoCoding.getPixelYFunction().getCoefficients();
        this.writeDirectLocationModel(++indent, directOrder, lambdaCoeffs, phiCoeffs);
        this.writeReverseLocationModel(indent, reverseOrder, xCoeffs, yCoeffs);
        --indent;
        this.println(slmTags[1]);
        --indent;
        this.println(gpTags[1]);
    }

    private int writeFXYCoordRefSystem(FXYGeoCoding fxyGeoCoding, int indent) {
        String[] crsTags = DimapHeaderWriter.createTags(indent, "Coordinate_Reference_System");
        this.println(crsTags[0]);
        ++indent;
        indent = this.writeDatum(fxyGeoCoding.getDatum(), indent);
        --indent;
        this.println(crsTags[1]);
        return --indent;
    }

    private int writeDatum(Datum datum, int indent) {
        String[] horizontalCsTags = DimapHeaderWriter.createTags(indent, "Horizontal_CS");
        this.println(horizontalCsTags[0]);
        this.printLine(++indent, "HORIZONTAL_CS_TYPE", "GEOGRAPHIC");
        String[] geographicCsTags = DimapHeaderWriter.createTags(indent, "Geographic_CS");
        this.println(geographicCsTags[0]);
        String[] horizontalDatumTags = DimapHeaderWriter.createTags(++indent, "Horizontal_Datum");
        this.println(horizontalDatumTags[0]);
        this.printLine(++indent, "HORIZONTAL_DATUM_NAME", datum.getName());
        String[] ellipsoidTags = DimapHeaderWriter.createTags(indent, "Ellipsoid");
        this.println(ellipsoidTags[0]);
        Ellipsoid ellipsoid = datum.getEllipsoid();
        this.printLine(++indent, "ELLIPSOID_NAME", ellipsoid.getName());
        String[] ellipsoidParametersTags = DimapHeaderWriter.createTags(indent, "Ellipsoid_Parameters");
        this.println(ellipsoidParametersTags[0]);
        String[][] ellipsoidAttrib = new String[][]{{"unit", "M"}};
        this.printLine(++indent, "ELLIPSOID_MAJ_AXIS", ellipsoidAttrib, String.valueOf(ellipsoid.getSemiMajor()));
        this.printLine(indent, "ELLIPSOID_MIN_AXIS", ellipsoidAttrib, String.valueOf(ellipsoid.getSemiMinor()));
        this.println(ellipsoidParametersTags[1]);
        --indent;
        this.println(ellipsoidTags[1]);
        --indent;
        this.println(horizontalDatumTags[1]);
        --indent;
        this.println(geographicCsTags[1]);
        this.println(horizontalCsTags[1]);
        return --indent;
    }

    private void writeDirectLocationModel(int indent, int order, double[] lambdaCoeffs, double[] phiCoeffs) {
        String[][] attributes = new String[][]{{"order", String.valueOf(order)}};
        String[] dlmTags = DimapHeaderWriter.createTags(indent, "Direct_Location_Model", attributes);
        this.println(dlmTags[0]);
        String[] lclTags = DimapHeaderWriter.createTags(++indent, "lc_List");
        this.println(lclTags[0]);
        this.writeCoeffsToList(++indent, lambdaCoeffs, "lc");
        this.println(lclTags[1]);
        String[] pclTags = DimapHeaderWriter.createTags(--indent, "pc_List");
        this.println(pclTags[0]);
        this.writeCoeffsToList(++indent, phiCoeffs, "pc");
        --indent;
        this.println(pclTags[1]);
        --indent;
        this.println(dlmTags[1]);
    }

    private void writeReverseLocationModel(int indent, int order, double[] xCoeffs, double[] yCoeffs) {
        String[][] attributes = new String[][]{{"order", String.valueOf(order)}};
        String[] rlmTags = DimapHeaderWriter.createTags(indent, "Reverse_Location_Model", attributes);
        this.println(rlmTags[0]);
        String[] iclTags = DimapHeaderWriter.createTags(++indent, "ic_List");
        this.println(iclTags[0]);
        this.writeCoeffsToList(++indent, xCoeffs, "ic");
        this.println(iclTags[1]);
        String[] jclTags = DimapHeaderWriter.createTags(--indent, "jc_List");
        this.println(jclTags[0]);
        this.writeCoeffsToList(++indent, yCoeffs, "jc");
        --indent;
        this.println(jclTags[1]);
        --indent;
        this.println(rlmTags[1]);
    }

    private void writeCoeffsToList(int indent, double[] phiCoeffs, String tagListElement) {
        String[][] attributes = new String[][]{{"index", ""}};
        for (int i = 0; i < phiCoeffs.length; ++i) {
            attributes[0][1] = String.valueOf(i);
            this.printLine(indent, tagListElement, attributes, String.valueOf(phiCoeffs[i]));
        }
    }

    protected void writeProductionElements(int indent) {
        ProductData.UTC sceneRasterStopTime;
        String[] productionTags = DimapHeaderWriter.createTags(indent, "Production");
        this.println(productionTags[0]);
        this.printLine(indent + 1, "DATASET_PRODUCER_NAME", " ");
        this.printLine(indent + 1, "PRODUCT_TYPE", this.product.getProductType());
        ProductData.UTC sceneRasterStartTime = this.product.getStartTime();
        if (sceneRasterStartTime != null) {
            this.printLine(indent + 1, "PRODUCT_SCENE_RASTER_START_TIME", sceneRasterStartTime.format());
        }
        if ((sceneRasterStopTime = this.product.getEndTime()) != null) {
            this.printLine(indent + 1, "PRODUCT_SCENE_RASTER_STOP_TIME", sceneRasterStopTime.format());
        }
        if (this.product.getQuicklookBandName() != null) {
            this.printLine(indent + 1, "QUICKLOOK_BAND_NAME", this.product.getQuicklookBandName());
        }
        this.println(productionTags[1]);
    }

    protected void writeMetadataId(int indent) {
        String[] idTags = DimapHeaderWriter.createTags(indent, "Metadata_Id");
        this.println(idTags[0]);
        String[][] attributes = new String[][]{{"version", "2.12.1"}};
        this.printLine(indent + 1, "METADATA_FORMAT", attributes, "DIMAP");
        this.printLine(indent + 1, "METADATA_PROFILE", "BEAM-DATAMODEL-V1");
        this.println(idTags[1]);
    }

    protected void writeDatasetId(int indent) {
        String[] idTags = DimapHeaderWriter.createTags(indent, "Dataset_Id");
        this.println(idTags[0]);
        this.printLine(indent + 1, "DATASET_SERIES", "BEAM-PRODUCT");
        this.printLine(indent + 1, "DATASET_NAME", this.product.getName());
        this.println(idTags[1]);
    }

    protected void writeDatasetUse(int indent) {
        String description = this.product.getDescription();
        Product.AutoGrouping autoGrouping = this.product.getAutoGrouping();
        if (description != null && description.length() > 0 || autoGrouping != null) {
            String[] idTags = DimapHeaderWriter.createTags(indent, "Dataset_Use");
            this.println(idTags[0]);
            if (description != null && description.length() > 0) {
                this.printLine(indent + 1, "DATASET_COMMENTS", description);
            }
            if (autoGrouping != null) {
                this.printLine(indent + 1, "DATASET_AUTO_GROUPING", autoGrouping.toString());
            }
            this.println(idTags[1]);
        }
    }
}

