/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.util.Guardian;

public class ProductSubsetDef {
    private String subsetName = null;
    private Rectangle region = null;
    private int subSamplingX = 1;
    private int subSamplingY = 1;
    private List nodeNameList = null;
    private boolean ignoreMetadata = false;
    private boolean treatVirtualBandsAsRealBands = false;

    public ProductSubsetDef() {
        this(null);
    }

    public ProductSubsetDef(String subsetName) {
        this.subsetName = subsetName;
    }

    public String getSubsetName() {
        return this.subsetName;
    }

    public void setSubsetName(String subsetName) {
        this.subsetName = subsetName;
    }

    public void setTreatVirtualBandsAsRealBands(boolean flag) {
        this.treatVirtualBandsAsRealBands = flag;
    }

    public boolean getTreatVirtualBandsAsRealBands() {
        return this.treatVirtualBandsAsRealBands;
    }

    public String[] getNodeNames() {
        if (this.nodeNameList == null) {
            return null;
        }
        String[] result = new String[this.nodeNameList.size()];
        for (int i = 0; i < this.nodeNameList.size(); ++i) {
            result[i] = (String)this.nodeNameList.get(i);
        }
        return result;
    }

    public void setNodeNames(String[] names) {
        if (names != null) {
            if (this.nodeNameList != null) {
                this.nodeNameList.clear();
            }
            this.addNodeNames(names);
        } else {
            this.nodeNameList = null;
        }
    }

    public void addNodeName(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        if (this.containsNodeName(name)) {
            return;
        }
        if (this.nodeNameList == null) {
            this.nodeNameList = new ArrayList();
        }
        this.nodeNameList.add(name);
    }

    public void addNodeNames(String[] names) {
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            this.addNodeName(names[i]);
        }
    }

    public boolean removeNodeName(String name) {
        int index = this.getNodeNameIndex(name);
        if (index < 0) {
            return false;
        }
        this.nodeNameList.remove(index);
        if (this.nodeNameList.size() == 0) {
            this.nodeNameList = null;
        }
        return true;
    }

    public boolean containsNodeName(String name) {
        return this.getNodeNameIndex(name) >= 0;
    }

    public boolean isNodeAccepted(String name) {
        return this.nodeNameList == null || this.containsNodeName(name);
    }

    public Rectangle getRegion() {
        return this.region != null ? new Rectangle(this.region) : null;
    }

    public void setRegion(Rectangle region) {
        if (region == null) {
            this.region = null;
        } else {
            this.setRegion(region.x, region.y, region.width, region.height);
        }
    }

    public void setRegion(int x, int y, int w, int h) {
        if (x < 0 || y < 0 || w < 1 || h < 1) {
            throw new IllegalArgumentException("invalid region");
        }
        this.region = new Rectangle(x, y, w, h);
    }

    public void setSubSampling(int subSamplingX, int subSamplingY) {
        if (subSamplingX < 1 || subSamplingY < 1) {
            throw new IllegalArgumentException("invalid sub-sampling");
        }
        this.subSamplingX = subSamplingX;
        this.subSamplingY = subSamplingY;
    }

    public int getSubSamplingX() {
        return this.subSamplingX;
    }

    public int getSubSamplingY() {
        return this.subSamplingY;
    }

    public Dimension getSceneRasterSize(int maxWidth, int maxHeight) {
        int width = maxWidth;
        int height = maxHeight;
        if (this.region != null) {
            width = this.region.width;
            height = this.region.height;
        }
        return new Dimension((width - 1) / this.subSamplingX + 1, (height - 1) / this.subSamplingY + 1);
    }

    public void setIgnoreMetadata(boolean ignoreMetadata) {
        this.ignoreMetadata = ignoreMetadata;
    }

    public boolean isIgnoreMetadata() {
        return this.ignoreMetadata;
    }

    public boolean isEntireProductSelected() {
        return this.region == null && this.subSamplingX == 1 && this.subSamplingY == 1 && this.nodeNameList == null && !this.ignoreMetadata;
    }

    private int getNodeNameIndex(String name) {
        if (this.nodeNameList != null) {
            for (int i = 0; i < this.nodeNameList.size(); ++i) {
                String nodeName = (String)this.nodeNameList.get(i);
                if (!nodeName.equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }
}

