/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;

public class ProductIO {
    public static final String DEFAULT_FORMAT_NAME = "BEAM-DIMAP";

    public static ProductReader getProductReader(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
        if (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            return plugIn.createReaderInstance();
        }
        return null;
    }

    public static String[] getProductWriterExtensions(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.getDefaultFileExtensions();
        }
        return null;
    }

    public static ProductWriter getProductWriter(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.createWriterInstance();
        }
        return null;
    }

    public static Product readProduct(File file, String ... formatNames) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        for (String formatName : formatNames) {
            ProductReader productReader;
            ProductReaderPlugIn selectedPlugIn = null;
            if (formatName != null) {
                Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
                selectedPlugIn = null;
                while (it.hasNext()) {
                    ProductReaderPlugIn plugIn = it.next();
                    DecodeQualification decodeQualification = plugIn.getDecodeQualification(file);
                    if (decodeQualification == DecodeQualification.INTENDED) {
                        selectedPlugIn = plugIn;
                        break;
                    }
                    if (decodeQualification != DecodeQualification.SUITABLE) continue;
                    selectedPlugIn = plugIn;
                }
            }
            if (selectedPlugIn == null || (productReader = selectedPlugIn.createReaderInstance()) == null) continue;
            return productReader.readProductNodes(file, null);
        }
        return ProductIO.readProductImpl(file, null);
    }

    public static Product readProduct(String filePath) throws IOException {
        return ProductIO.readProductImpl(new File(filePath), null);
    }

    public static Product readProduct(File file) throws IOException {
        return ProductIO.readProductImpl(file, null);
    }

    private static Product readProductImpl(File file, ProductSubsetDef subsetDef) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductReader productReader = ProductIO.getProductReaderForInput(file);
        if (productReader != null) {
            return productReader.readProductNodes(file, subsetDef);
        }
        return null;
    }

    @Deprecated
    public static ProductReader getProductReaderForFile(File file) {
        return ProductIO.getProductReaderForInput(file);
    }

    public static ProductReader getProductReaderForInput(Object input) {
        long startTimeTotal = System.currentTimeMillis();
        Logger logger = SystemUtils.LOG;
        logger.fine("Searching reader plugin for '" + input + "'");
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getAllReaderPlugIns();
        Object selectedPlugIn = null;
        while (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            try {
                long startTime = System.currentTimeMillis();
                DecodeQualification decodeQualification = plugIn.getDecodeQualification(input);
                long endTime = System.currentTimeMillis();
                logger.fine(String.format("Checking reader plugin %s (took %d ms)", plugIn.getClass().getName(), endTime - startTime));
                if (decodeQualification == DecodeQualification.INTENDED) {
                    selectedPlugIn = plugIn;
                    break;
                }
                if (decodeQualification != DecodeQualification.SUITABLE) continue;
                selectedPlugIn = plugIn;
            }
            catch (Exception e) {
                logger.severe("Error attempting to read " + input + " with plugin reader " + plugIn.toString() + ": " + e.getMessage());
            }
        }
        long endTimeTotal = System.currentTimeMillis();
        logger.fine(String.format("Searching reader plugin took %d ms", endTimeTotal - startTimeTotal));
        if (selectedPlugIn != null) {
            logger.fine("Selected " + selectedPlugIn.getClass().getName());
            return selectedPlugIn.createReaderInstance();
        }
        logger.fine("No suitable reader plugin found");
        return null;
    }

    public static void writeProduct(Product product, String filePath, String formatName) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, ProgressMonitor.NULL);
    }

    public static void writeProduct(Product product, String filePath, String formatName, ProgressMonitor pm) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, pm);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental) throws IOException {
        ProductIO.writeProduct(product, file, formatName, incremental, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProduct(Product product, File file, String formatName, boolean incremental, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter;
        Guardian.assertNotNull("product", (Object)product);
        Guardian.assertNotNull("file", file);
        if (formatName == null) {
            formatName = DEFAULT_FORMAT_NAME;
        }
        if ((productWriter = ProductIO.getProductWriter(formatName)) == null) {
            throw new ProductIOException("No product writer for the '" + formatName + "' format available.");
        }
        EncodeQualification encodeQualification = productWriter.getWriterPlugIn().getEncodeQualification(product);
        if (encodeQualification.getPreservation() == EncodeQualification.Preservation.UNABLE) {
            throw new ProductIOException("Product writer is unable to write product:\n" + encodeQualification.getInfoString());
        }
        productWriter.setIncrementalMode(incremental);
        ProductWriter productWriterOld = product.getProductWriter();
        product.setProductWriter(productWriter);
        IOException ioException = null;
        try {
            productWriter.writeProductNodes(product, file);
            ProductIO.writeAllBands(product, pm);
        }
        catch (IOException e) {
            ioException = e;
        }
        finally {
            block16: {
                try {
                    productWriter.flush();
                    productWriter.close();
                }
                catch (IOException e) {
                    if (ioException != null) break block16;
                    ioException = e;
                }
            }
            product.setProductWriter(productWriterOld);
            product.setFileLocation(file);
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAllBands(Product product, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter = product.getProductWriter();
        ArrayList<Band> bandsToWrite = new ArrayList<Band>();
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            if (!productWriter.shouldWrite(band)) continue;
            bandsToWrite.add(band);
        }
        if (!bandsToWrite.isEmpty()) {
            pm.beginTask("Writing bands of product '" + product.getName() + "'...", bandsToWrite.size());
            try {
                for (Band band : bandsToWrite) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    pm.setSubTaskName("Writing band '" + band.getName() + "'");
                    band.writeRasterDataFully(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private ProductIO() {
    }
}

