/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.util.Debug;
import org.esa.snap.dataio.envisat.DSD;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordInfo;

public class RecordReader {
    private final ProductFile _productFile;
    private final DSD _dsd;
    private final RecordInfo _recordInfo;

    RecordReader(ProductFile productFile, DSD dsd, RecordInfo recordInfo) {
        Debug.assertNotNull((Object)productFile);
        Debug.assertNotNull((Object)dsd);
        Debug.assertNotNull((Object)recordInfo);
        this._productFile = productFile;
        this._dsd = dsd;
        this._recordInfo = recordInfo;
    }

    public final ProductFile getProductFile() {
        return this._productFile;
    }

    public final DSD getDSD() {
        return this._dsd;
    }

    public final RecordInfo getRecordInfo() {
        return this._recordInfo;
    }

    public final int getNumRecords() {
        return this.getDSD().getNumRecords();
    }

    public final Record readRecord() throws IOException {
        return this.readRecord(0, null);
    }

    public final Record readRecord(int index) throws IOException {
        return this.readRecord(index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record readRecord(int index, Record record) throws IOException {
        ImageInputStream istream;
        if (record == null) {
            record = this.createCompatibleRecord();
        }
        Debug.assertTrue((record.getInfo() == this._recordInfo ? 1 : 0) != 0);
        if (this._dsd.getDatasetType() == 'M') {
            index = this._productFile.getMappedMDSRIndex(index);
        }
        long pos = this._dsd.getDatasetOffset() + (long)(index * this._dsd.getRecordSize());
        ImageInputStream imageInputStream = istream = this._productFile.getDataInputStream();
        synchronized (imageInputStream) {
            istream.seek(pos);
            record.readFrom(istream);
        }
        return record;
    }

    public Record createCompatibleRecord() {
        return this.getRecordInfo().createRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFieldSegment(int sourceY, long fieldOffset, int dataFieldSampleSize, int minX, int maxX, Field field) throws IOException {
        ImageInputStream istream;
        if (this._dsd.getDatasetType() == 'M' || this._dsd.getDatasetType() == 'A') {
            sourceY = this._productFile.getMappedMDSRIndex(sourceY);
        }
        long pos = this._dsd.getDatasetOffset() + (long)(sourceY * this._dsd.getRecordSize()) + fieldOffset + (long)(minX * dataFieldSampleSize * field.getData().getElemSize());
        ImageInputStream imageInputStream = istream = this._productFile.getDataInputStream();
        synchronized (imageInputStream) {
            istream.seek(pos);
            field.getData().readFrom(minX * dataFieldSampleSize, (maxX - minX + 1) * dataFieldSampleSize, istream);
        }
    }
}

