/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.FieldInfo;
import org.esa.snap.dataio.envisat.Header;
import org.esa.snap.dataio.envisat.HeaderParseException;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordInfo;

public class HeaderParser {
    public static HeaderParser getInstance() {
        return Holder.instance;
    }

    public Header parseHeader(String headerName, byte[] sourceBytes) throws HeaderParseException {
        Guardian.assertNotNullOrEmpty((String)"headerName", (String)headerName);
        Guardian.assertNotNullOrEmpty((String)"sourceBytes", (byte[])sourceBytes);
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new IllegalArgumentException("sourceBytes array must not be null or empty");
        }
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(sourceBytes)));
        RecordInfo recordInfo = new RecordInfo(headerName);
        ArrayList<String> recordTokens = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                int assignPos = line.indexOf(61);
                if (assignPos <= 0) {
                    this.error(headerName, reader, "invalid header entry found: " + line);
                }
                String name = line.substring(0, assignPos).trim();
                String value = line.substring(assignPos + 1).trim();
                String unit = null;
                int unitStartPos = value.lastIndexOf(60);
                int unitEndPos = value.lastIndexOf(62);
                if (unitStartPos > 0 && unitEndPos == value.length() - 1 && unitStartPos < unitEndPos) {
                    unit = value.substring(unitStartPos + 1, unitEndPos);
                    value = value.substring(0, unitStartPos);
                }
                FieldInfo fieldInfo = this.createFieldInfo(name, value, unit);
                recordInfo.add(fieldInfo);
                recordTokens.add(value);
            }
        }
        catch (HeaderParseException e) {
            this.error(headerName, reader, e.getMessage());
        }
        catch (IOException e) {
            this.error(headerName, reader, e.getMessage());
        }
        reader = null;
        Record record = recordInfo.createRecord();
        for (int i = 0; i < record.getNumFields(); ++i) {
            Field field = record.getFieldAt(i);
            String token = (String)recordTokens.get(i);
            try {
                this.setFieldData(field, token);
                continue;
            }
            catch (NumberFormatException e) {
                this.error(headerName, null, "invalid header entry found: " + field.getName() + "=" + token);
            }
        }
        return new Header(record);
    }

    private FieldInfo createFieldInfo(String name, String value, String unit) {
        int dataType = 0;
        int numElems = -1;
        if (value.length() == 1 && HeaderParser.isBooleanDigit(value.charAt(0))) {
            dataType = 10;
            numElems = 1;
        } else if (value.length() == 1) {
            dataType = 41;
            numElems = value.length();
        } else if (value.length() >= 2 && HeaderParser.isQuote(value.charAt(0)) && HeaderParser.isQuote(value.charAt(value.length() - 1))) {
            dataType = 41;
            numElems = value.length() - 2;
        } else if (value.length() >= 2 && HeaderParser.isSign(value.charAt(0)) && (HeaderParser.isDigit(value.charAt(1)) || HeaderParser.isDot(value.charAt(1)))) {
            numElems = 1;
            int pos = 0;
            int numDigitsMax = -1;
            boolean minusSeen = false;
            boolean dotSeen = false;
            boolean expPartSeen = false;
            boolean notANumber = false;
            long intNum = 0L;
            long intNumMax = 0L;
            do {
                if (value.charAt(pos) == '-') {
                    minusSeen = true;
                }
                ++pos;
                int numDigits = 0;
                while (pos < value.length()) {
                    char ch = value.charAt(pos);
                    if (Character.isDigit(ch)) {
                        ++pos;
                        numDigitsMax = Math.max(numDigitsMax, ++numDigits);
                        intNum *= 10L;
                        intNumMax = Math.max(intNumMax, intNum += (long)(ch - 48));
                        continue;
                    }
                    if (HeaderParser.isDot(ch)) {
                        ++pos;
                        dotSeen = true;
                        continue;
                    }
                    if (HeaderParser.isExponentPrefix(ch)) {
                        if (++pos < value.length() - 2 && HeaderParser.isSign(value.charAt(pos)) && HeaderParser.isDigit(value.charAt(pos + 1))) {
                            pos += 2;
                            expPartSeen = true;
                            continue;
                        }
                        notANumber = true;
                        break;
                    }
                    if (HeaderParser.isSign(ch)) {
                        intNum = 0L;
                        ++numElems;
                        break;
                    }
                    notANumber = true;
                    break;
                }
                if (numDigits != 0) continue;
                notANumber = true;
                break;
            } while (pos < value.length() && HeaderParser.isSign(value.charAt(pos)));
            if (!notANumber) {
                dataType = dotSeen || expPartSeen ? 31 : (!minusSeen && (intNumMax > Integer.MAX_VALUE || numDigitsMax > 10) ? 22 : 12);
            }
        }
        if (dataType == 0) {
            Debug.trace((String)("WARNING: header parameter with unknown value type seen: " + name + "='" + value + "' (assuming type string)"));
            dataType = 41;
            numElems = value.length();
        }
        Debug.assertTrue((numElems >= 0 ? 1 : 0) != 0);
        return new FieldInfo(name, dataType, numElems, unit, null);
    }

    private void setFieldData(Field field, String token) throws NumberFormatException {
        Debug.assertNotNull((Object)field);
        Debug.assertNotNull((Object)token);
        switch (field.getInfo().getDataType()) {
            case 10: 
            case 20: {
                int pos1 = 0;
                byte[] values = (byte[])field.getElems();
                for (int i = 0; i < values.length; ++i) {
                    int pos2 = this.getNextNumberSeparatorPos(token, pos1 + 1);
                    values[i] = (byte)this.parseLong(token.substring(pos1, pos2));
                    pos1 = pos2;
                }
                break;
            }
            case 11: 
            case 21: {
                int pos1 = 0;
                short[] values = (short[])field.getElems();
                for (int i = 0; i < values.length; ++i) {
                    int pos2 = this.getNextNumberSeparatorPos(token, pos1 + 1);
                    values[i] = (short)this.parseLong(token.substring(pos1, pos2));
                    pos1 = pos2;
                }
                break;
            }
            case 12: 
            case 22: {
                int pos1 = 0;
                int[] values = (int[])field.getElems();
                for (int i = 0; i < values.length; ++i) {
                    int pos2 = this.getNextNumberSeparatorPos(token, pos1 + 1);
                    values[i] = (int)this.parseLong(token.substring(pos1, pos2));
                    pos1 = pos2;
                }
                break;
            }
            case 30: {
                int pos1 = 0;
                float[] values = (float[])field.getElems();
                for (int i = 0; i < values.length; ++i) {
                    int pos2 = this.getNextNumberSeparatorPos(token, pos1 + 1);
                    values[i] = (float)this.parseDouble(token.substring(pos1, pos2));
                    pos1 = pos2;
                }
                break;
            }
            case 31: {
                int pos1 = 0;
                double[] values = (double[])field.getElems();
                for (int i = 0; i < values.length; ++i) {
                    int pos2 = this.getNextNumberSeparatorPos(token, pos1 + 1);
                    values[i] = this.parseDouble(token.substring(pos1, pos2));
                    pos1 = pos2;
                }
                break;
            }
            case 41: {
                byte[] values = (byte[])field.getElems();
                if (token.length() >= 2 && HeaderParser.isQuote(token.charAt(0)) && HeaderParser.isQuote(token.charAt(token.length() - 1))) {
                    System.arraycopy(token.getBytes(), 1, values, 0, values.length);
                    break;
                }
                if (token.length() < 1) break;
                System.arraycopy(token.getBytes(), 0, values, 0, values.length);
                break;
            }
            default: {
                throw new IllegalStateException("invalid field data type");
            }
        }
    }

    private long parseLong(String value) throws NumberFormatException {
        long sign = 1L;
        int pos = 0;
        if (value.charAt(0) == '+' || value.charAt(0) == '-') {
            sign = value.charAt(0) == '+' ? 1L : -1L;
            ++pos;
        }
        if ((pos = this.getFirstButNotLastNonZeroPos(value, pos)) > 0) {
            value = value.substring(pos);
        }
        return sign * Long.parseLong(value);
    }

    private double parseDouble(String value) throws NumberFormatException {
        double sign = 1.0;
        int pos = 0;
        if (value.charAt(0) == '+' || value.charAt(0) == '-') {
            sign = value.charAt(0) == '+' ? 1.0 : -1.0;
            ++pos;
        }
        if ((pos = this.getFirstButNotLastNonZeroPos(value, pos)) > 0) {
            value = value.substring(pos);
        }
        return sign * Double.parseDouble(value);
    }

    private int getFirstButNotLastNonZeroPos(String value, int pos) {
        while (pos < value.length() - 1 && value.charAt(pos) == '0') {
            ++pos;
        }
        return pos;
    }

    private int getNextNumberSeparatorPos(String value, int pos) {
        while (pos < value.length() && (!HeaderParser.isSign(value.charAt(pos)) || pos > 0 && HeaderParser.isExponentPrefix(value.charAt(pos - 1)))) {
            ++pos;
        }
        return pos;
    }

    private static boolean isSign(char ch) {
        return ch == '+' || ch == '-';
    }

    private static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    private static boolean isExponentPrefix(char ch) {
        return ch == 'e' || ch == 'E';
    }

    private static boolean isBooleanDigit(char ch) {
        return ch == '0' || ch == '1';
    }

    private static boolean isDot(char ch) {
        return ch == '.';
    }

    private static boolean isQuote(char ch) {
        return ch == '\"';
    }

    private void error(String headerName, LineNumberReader reader, String msg) throws HeaderParseException {
        StringBuffer sb = new StringBuffer();
        sb.append("ENVISAT header '");
        sb.append(headerName);
        sb.append("'");
        if (reader != null) {
            sb.append(", line ");
            sb.append(reader.getLineNumber());
        }
        sb.append(": ");
        sb.append(msg);
        throw new HeaderParseException(sb.toString());
    }

    private HeaderParser() {
    }

    private static class Holder {
        private static final HeaderParser instance = new HeaderParser();

        private Holder() {
        }
    }
}

