/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envisat.BandLineReader;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class AuxProductFile
extends ProductFile {
    public AuxProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        return null;
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        return null;
    }

    @Override
    public int getSceneRasterWidth() {
        switch (this.getProductType()) {
            case "AUX_LSM_AX": {
                return 360;
            }
            case "AUX_DEM_AX": {
                return 2160;
            }
        }
        return 0;
    }

    @Override
    public int getSceneRasterHeight() {
        switch (this.getProductType()) {
            case "AUX_LSM_AX": {
                return 180;
            }
            case "AUX_DEM_AX": {
                return 4320;
            }
        }
        return 0;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return 1.0f;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return 1.0f;
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return false;
    }

    @Override
    public Mask[] createDefaultMasks(String flagDsName) {
        return new Mask[0];
    }

    @Override
    void setInvalidPixelExpression(Band band) {
    }

    @Override
    public String getGADSName() {
        return null;
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        return new float[0];
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        return new float[0];
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        return new float[0];
    }

    @Override
    int getMappedMDSRIndex(int lineIndex) {
        if ("AUX_LSM_AX".equals(this.getProductType())) {
            return this.getSceneRasterHeight() - 1 - lineIndex;
        }
        return super.getMappedMDSRIndex(lineIndex);
    }

    @Override
    protected void addCustomMetadata(Product product) throws IOException {
        try {
            int width = this.getSceneRasterWidth();
            int height = this.getSceneRasterHeight();
            switch (this.getProductType()) {
                case "AUX_LSM_AX": {
                    product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, width, height, -180.0, 90.0, 1.0, 1.0));
                    break;
                }
                case "AUX_DEM_AX": {
                    product.setSceneGeoCoding((GeoCoding)AuxProductFile.creatDemGeoCoding(width, height));
                }
            }
        }
        catch (FactoryException | TransformException e) {
            SystemUtils.LOG.log(Level.SEVERE, String.format("Could not create GeoCoding for product '%s'", product.getName()), e);
        }
    }

    static CrsGeoCoding creatDemGeoCoding(int width, int height) throws FactoryException, TransformException {
        AffineTransform i2m = new AffineTransform();
        i2m.rotate(Math.toRadians(90.0));
        int easting = 180;
        int northing = -90;
        i2m.translate(-90.0, 180.0);
        double sizeX = 360.0 / (double)height;
        double sizeY = 180.0 / (double)width;
        i2m.scale(sizeX, -sizeY);
        return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, new Rectangle(width, height), i2m);
    }

    @Override
    protected BandLineReader[] createBandLineReaders() {
        BandLineReader[] tempReaders = super.createBandLineReaders();
        BandLineReader[] readers = new BandLineReader[tempReaders.length];
        for (int i = 0; i < tempReaders.length; ++i) {
            readers[i] = new AuxBandLineReader(tempReaders[i]);
        }
        return readers;
    }

    private static final class AuxBandLineReader
    extends BandLineReader {
        AuxBandLineReader(BandLineReader reader) {
            super(reader.getBandInfo(), reader.getPixelDataReader(), AuxBandLineReader.getFieldIndex(reader));
        }

        private static int getFieldIndex(BandLineReader reader) {
            RecordReader pixelDataReader = reader.getPixelDataReader();
            Record pixelDataRecord = pixelDataReader.createCompatibleRecord();
            Field pixelDatafield = reader.getPixelDataField();
            return pixelDataRecord.getFieldIndex(pixelDatafield.getName());
        }

        @Override
        public boolean isTiePointBased() {
            return false;
        }
    }
}

