/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.envisat.DSD;
import org.esa.snap.dataio.envisat.EnvisatConstants;
import org.esa.snap.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.snap.dataio.envisat.HeaderParseException;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;

public class AatsrProductFile
extends ProductFile {
    private static final String FIRST_LINE_TIME = "FIRST_LINE_TIME";
    private static final String LAST_LINE_TIME = "LAST_LINE_TIME";
    private int _sceneRasterHeight;
    private float _locTiePointGridOffsetX;
    private float _locTiePointGridOffsetY;
    private int _locTiePointSubSamplingX;
    private int _locTiePointSubSamplingY;
    private int _solTiePointGridWidth;
    private float _solTiePointGridOffsetX;
    private float _solTiePointGridOffsetY;
    private int _solTiePointSubSamplingX;
    private int _solTiePointSubSamplingY;
    private int[] mdsMapIndex;

    protected AatsrProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        try {
            return this.getSPH().getParamUTC(FIRST_LINE_TIME);
        }
        catch (HeaderEntryNotFoundException | HeaderParseException e) {
            this.getLogger().warning(MessageFormat.format("failed to parse specific header parameter ''{0}'': {1}", FIRST_LINE_TIME, ((Throwable)e).getMessage()));
            return null;
        }
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        try {
            return this.getSPH().getParamUTC(LAST_LINE_TIME);
        }
        catch (HeaderEntryNotFoundException | HeaderParseException e) {
            this.getLogger().warning(MessageFormat.format("failed to parse specific header parameter ''{0}'': {1}", LAST_LINE_TIME, ((Throwable)e).getMessage()));
            return null;
        }
    }

    @Override
    public int getSceneRasterWidth() {
        return 512;
    }

    @Override
    public int getSceneRasterHeight() {
        return this._sceneRasterHeight;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return gridWidth == this._solTiePointGridWidth ? this._solTiePointGridOffsetX : this._locTiePointGridOffsetX;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return gridWidth == this._solTiePointGridWidth ? this._solTiePointGridOffsetY : this._locTiePointGridOffsetY;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return gridWidth == this._solTiePointGridWidth ? (float)this._solTiePointSubSamplingX : (float)this._locTiePointSubSamplingX;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return gridWidth == this._solTiePointGridWidth ? (float)this._solTiePointSubSamplingY : (float)this._locTiePointSubSamplingY;
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return true;
    }

    @Override
    public String getGADSName() {
        return this.getProductType().equalsIgnoreCase("ATS_TOA_1P") ? "VISIBLE_CALIB_COEFS_GADS" : null;
    }

    @Override
    protected void postProcessSPH(Map parameters) throws IOException {
        DSD[] mdsDsds = this.getValidDSDs('M');
        int numMDSR = mdsDsds.length == 0 ? 0 : mdsDsds[0].getNumRecords();
        DSD dsdGeoLocationAds = this.getDSD("GEOLOCATION_ADS");
        if (dsdGeoLocationAds == null) {
            throw new IllegalFileFormatException("invalid product: missing DSD for dataset 'GEOLOCATION_ADS'");
        }
        DSD dsdNadirViewSolarAnglesAds = this.getDSD("NADIR_VIEW_SOLAR_ANGLES_ADS");
        if (dsdNadirViewSolarAnglesAds == null) {
            throw new IllegalFileFormatException("invalid product: missing DSD for dataset 'NADIR_VIEW_SOLAR_ANGLES_ADS'");
        }
        this._sceneRasterHeight = AatsrProductFile.calculateSceneRasterHeight(dsdGeoLocationAds, numMDSR);
        int sceneRasterWidth = 512;
        int locTiePointGridWidth = 23;
        int locTiePointGridHeight = dsdGeoLocationAds.getNumRecords();
        this._locTiePointGridOffsetX = -19.0f;
        this._locTiePointGridOffsetY = 0.0f;
        this._locTiePointSubSamplingX = 25;
        this._locTiePointSubSamplingY = 32;
        this._solTiePointGridWidth = 11;
        int solTiePointGridHeight = dsdNadirViewSolarAnglesAds.getNumRecords();
        this._solTiePointGridOffsetX = 6.0f;
        this._solTiePointGridOffsetY = 0.0f;
        this._solTiePointSubSamplingX = 50;
        this._solTiePointSubSamplingY = 32;
        parameters.put("sceneRasterWidth", sceneRasterWidth);
        parameters.put("sceneRasterHeight", this._sceneRasterHeight);
        parameters.put("locTiePointGridWidth", locTiePointGridWidth);
        parameters.put("locTiePointGridHeight", locTiePointGridHeight);
        parameters.put("locTiePointGridOffsetX", Float.valueOf(this._locTiePointGridOffsetX));
        parameters.put("locTiePointGridOffsetY", Float.valueOf(this._locTiePointGridOffsetY));
        parameters.put("locTiePointSubSamplingX", this._locTiePointSubSamplingX);
        parameters.put("locTiePointSubSamplingY", this._locTiePointSubSamplingY);
        parameters.put("solTiePointGridWidth", this._solTiePointGridWidth);
        parameters.put("solTiePointGridHeight", solTiePointGridHeight);
        parameters.put("solTiePointGridOffsetX", Float.valueOf(this._solTiePointGridOffsetX));
        parameters.put("solTiePointGridOffsetY", Float.valueOf(this._solTiePointGridOffsetY));
        parameters.put("solTiePointSubSamplingX", this._solTiePointSubSamplingX);
        parameters.put("solTiePointSubSamplingY", this._solTiePointSubSamplingY);
        if (this._sceneRasterHeight > numMDSR) {
            this.mdsMapIndex = new int[this.getSceneRasterHeight()];
            RecordReader recordReader = this.getRecordReader("GEOLOCATION_ADS");
            int records = recordReader.getNumRecords() - 1;
            int mdsIndex = 0;
            for (int geoADSIndex = 0; geoADSIndex < records; ++geoADSIndex) {
                Record record = recordReader.readRecord(geoADSIndex);
                int attachFlag = record.getField("attach_flag").getElemInt(0);
                for (int line = 0; line < 32; ++line) {
                    int i = geoADSIndex * 32 + line;
                    this.mdsMapIndex[i] = attachFlag == 0 ? mdsIndex++ : -1;
                }
            }
        }
    }

    @Override
    int getMappedMDSRIndex(int lineIndex) {
        if (this.mdsMapIndex == null) {
            return lineIndex;
        }
        return this.mdsMapIndex[lineIndex];
    }

    @Override
    double getMissingMDSRPixelValue() {
        return -2.0;
    }

    @Override
    void setInvalidPixelExpression(Band band) {
        if (band.isFlagBand()) {
            band.setNoDataValueUsed(false);
        } else {
            band.setNoDataValueUsed(true);
            band.setNoDataValue(-2.0);
        }
    }

    @Override
    public String getAutoGroupingPattern() {
        return "nadir:fward";
    }

    @Override
    public DSD[] getValidDSDs(char datasetType) {
        ArrayList<DSD> dsdList = new ArrayList<DSD>();
        for (int i = 0; i < this.getNumDSDs(); ++i) {
            DSD dsd = this.getDSDAt(i);
            if (dsd.getDatasetType() != datasetType || StringUtils.isNullOrEmpty((String)dsd.getDatasetName())) continue;
            dsdList.add(dsd);
        }
        return dsdList.toArray(new DSD[dsdList.size()]);
    }

    static int calculateSceneRasterHeight(DSD dsdGeoLocationAds, int numMDSR) {
        int linesFromADS = (dsdGeoLocationAds.getNumRecords() - 1) * 32;
        if (numMDSR > linesFromADS) {
            return numMDSR;
        }
        return linesFromADS;
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        return EnvisatConstants.AATSR_WAVELENGTHS;
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        return EnvisatConstants.AATSR_BANDWIDTHS;
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        return EnvisatConstants.AATSR_SOLAR_FLUXES;
    }

    @Override
    protected void addCustomMetadata(Product product) throws IOException {
        String nadirBand = "btemp_nadir_0370";
        String fwardBand = "btemp_fward_0370";
        ProductNodeGroup maskGroup = product.getMaskGroup();
        if (product.containsBand("btemp_nadir_0370")) {
            maskGroup.add((ProductNode)this.mask("fire_nadir_1", "ATSR active fire (ALGO1)", "btemp_nadir_0370 > 312.0", Color.RED, 0.5f));
            maskGroup.add((ProductNode)this.mask("fire_nadir_2", "ATSR active fire (ALGO2)", "btemp_nadir_0370 > 308.0", Color.RED.darker(), 0.5f));
        }
        if (product.containsBand("btemp_fward_0370")) {
            maskGroup.add((ProductNode)this.mask("fire_fward_1", "ATSR active fire (ALGO1)", "btemp_fward_0370 > 312.0", Color.RED, 0.5f));
            maskGroup.add((ProductNode)this.mask("fire_fward_2", "ATSR active fire (ALGO2)", "btemp_fward_0370 > 308.0", Color.RED.darker(), 0.5f));
        }
    }

    @Override
    public Mask[] createDefaultMasks(String dsName) {
        if (this.getProductType().endsWith("1P")) {
            if ("confid_flags_nadir".equalsIgnoreCase(dsName) || "confid_flags_fward".equalsIgnoreCase(dsName)) {
                String prefix = "qln_";
                if ("confid_flags_fward".equalsIgnoreCase(dsName)) {
                    prefix = "qlf_";
                }
                return this.createL1bConfidBMDs(prefix, dsName);
            }
            if ("cloud_flags_nadir".equalsIgnoreCase(dsName) || "cloud_flags_fward".equalsIgnoreCase(dsName)) {
                String prefix = "clf_";
                if ("cloud_flags_nadir".equalsIgnoreCase(dsName)) {
                    prefix = "cln_";
                }
                return this.createL1bCloudBMDs(prefix, dsName);
            }
        } else if (this.getProductType().endsWith("2P") && "flags".equalsIgnoreCase(dsName)) {
            return this.createL2BMDs();
        }
        return new Mask[0];
    }

    private Mask[] createL1bCloudBMDs(String prefix, String dsName) {
        return new Mask[]{this.mask(this.mkBMDNm(prefix, "LAND"), null, dsName + ".LAND", Color.green, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY"), null, dsName + ".CLOUDY", Color.cyan, 0.5f), this.mask(this.mkBMDNm(prefix, "SUN_GLINT"), null, dsName + ".SUN_GLINT", Color.yellow, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_REFL_HIST"), null, dsName + ".CLOUDY_REFL_HIST", Color.orange, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_SPAT_COHER_16"), null, dsName + ".CLOUDY_SPAT_COHER_16", Color.red, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_SPAT_COHER_11"), null, dsName + ".CLOUDY_SPAT_COHER_11", Color.blue, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_GROSS_12"), null, dsName + ".CLOUDY_GROSS_12", Color.magenta, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_CIRRUS_11_12"), null, dsName + ".CLOUDY_CIRRUS_11_12", Color.pink, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_MED_HI_LEVEL_37_12"), null, dsName + ".CLOUDY_MED_HI_LEVEL_37_12", Color.yellow, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_FOG_LOW_STRATUS_11_37"), null, dsName + ".CLOUDY_FOG_LOW_STRATUS_11_37", Color.orange, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_VW_DIFF_11_12"), null, dsName + ".CLOUDY_VW_DIFF_11_12", Color.red, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_VW_DIFF_37_11"), null, dsName + ".CLOUDY_VW_DIFF_37_11", Color.green, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_THERM_HIST_11_12"), null, dsName + ".CLOUDY_THERM_HIST_11_12", Color.blue, 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_VIS_CHANNEL"), null, dsName + ".CLOUDY_VIS_CHANNEL", Color.yellow.darker(), 0.5f), this.mask(this.mkBMDNm(prefix, "CLOUDY_NDSI"), null, dsName + ".CLOUDY_NDSI", Color.gray, 0.5f)};
    }

    private Mask[] createL1bConfidBMDs(String prefix, String dsName) {
        return new Mask[]{this.mask(this.mkBMDNm(prefix, "BLANKING"), null, dsName + ".BLANKING", Color.red, 0.5f), this.mask(this.mkBMDNm(prefix, "COSMETIC"), null, dsName + ".COSMETIC", Color.yellow, 0.5f), this.mask(this.mkBMDNm(prefix, "SCAN_ABSENT"), null, dsName + ".SCAN_ABSENT", Color.orange, 0.5f), this.mask(this.mkBMDNm(prefix, "ABSENT"), null, dsName + ".ABSENT", Color.green, 0.5f), this.mask(this.mkBMDNm(prefix, "NOT_DECOMPR"), null, dsName + ".NOT_DECOMPR", Color.blue, 0.5f), this.mask(this.mkBMDNm(prefix, "NO_SIGNAL"), null, dsName + ".NO_SIGNAL", Color.magenta, 0.5f), this.mask(this.mkBMDNm(prefix, "SATURATION"), null, dsName + ".SATURATION", Color.green, 0.5f), this.mask(this.mkBMDNm(prefix, "OUT_OF_RANGE"), null, dsName + ".OUT_OF_RANGE", Color.red, 0.5f), this.mask(this.mkBMDNm(prefix, "NO_CALIB_PARAM"), null, dsName + ".NO_CALIB_PARAM", Color.cyan, 0.5f), this.mask(this.mkBMDNm(prefix, "UNFILLED"), null, dsName + ".UNFILLED", Color.yellow, 0.5f)};
    }

    private Mask[] createL2BMDs() {
        return new Mask[]{this.mask(this.mkBMDNm("LAND"), null, "flags.LAND", Color.green, 0.5f), this.mask(this.mkBMDNm("WATER"), null, "!flags.LAND AND !(flags.NADIR_CLOUD OR flags.FWARD_CLOUD)", Color.blue, 0.5f), this.mask(this.mkBMDNm("CLOUD"), null, "flags.NADIR_CLOUD OR flags.FWARD_CLOUD", Color.cyan, 0.5f), this.mask(this.mkBMDNm("NADIR_CLOUD"), null, "flags.NADIR_CLOUD", Color.cyan, 0.5f), this.mask(this.mkBMDNm("NADIR_BLANKING"), null, "flags.NADIR_BLANKING", Color.orange, 0.5f), this.mask(this.mkBMDNm("NADIR_COSMETIC"), null, "flags.NADIR_COSMETIC", Color.red, 0.5f), this.mask(this.mkBMDNm("FWARD_CLOUD"), null, "flags.FWARD_CLOUD", Color.cyan, 0.5f), this.mask(this.mkBMDNm("FWARD_BLANKING"), null, "flags.FWARD_BLANKING", Color.orange, 0.5f), this.mask(this.mkBMDNm("FWARD_COSMETIC"), null, "flags.FWARD_COSMETIC", Color.red, 0.5f), this.mask(this.mkBMDNm("CLOUDY_16_MY"), null, "flags.CLOUDY_16_MY", Color.cyan, 0.5f), this.mask(this.mkBMDNm("CLOUDY_11_12_MY"), null, "flags.CLOUDY_11_12_MY", Color.cyan, 0.5f), this.mask(this.mkBMDNm("CLOUDY_HISTO"), null, "flags.CLOUDY_HISTO", Color.cyan, 0.5f), this.mask(this.mkBMDNm("NADIR_SST_ONLY_VALID"), null, "flags.NADIR_SST_ONLY_VALID", Color.red, 0.5f), this.mask(this.mkBMDNm("NADIR_SST_ONLY_37_MY_VALID"), null, "flags.NADIR_SST_ONLY_37_MY_VALID", Color.orange, 0.5f), this.mask(this.mkBMDNm("DUAL_SST_VALID"), null, "flags.DUAL_SST_VALID", Color.red, 0.5f), this.mask(this.mkBMDNm("DUAL_SST_VALID_37_MY"), null, "flags.DUAL_SST_VALID_37_MY", Color.orange, 0.5f)};
    }

    private String mkBMDNm(String base) {
        return this.mkBMDNm("", base);
    }

    private String mkBMDNm(String prefix, String base) {
        return (prefix + base).toLowerCase();
    }
}

