/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.ows.AbstractGetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.data.wms.WMSSpecification;
import org.geotools.data.wms.request.AbstractGetFeatureInfoRequest;
import org.geotools.data.wms.request.AbstractGetMapRequest;
import org.geotools.data.wms.request.AbstractGetStylesRequest;
import org.geotools.data.wms.request.DescribeLayerRequest;
import org.geotools.data.wms.request.GetLegendGraphicRequest;
import org.geotools.data.wms.request.GetStylesRequest;
import org.geotools.data.wms.request.PutStylesRequest;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.data.wms.response.GetStylesResponse;
import org.geotools.data.wms.response.WMSGetCapabilitiesResponse;
import org.geotools.ows.ServiceException;

public class WMS1_0_0
extends WMSSpecification {
    static final Map formatMimeTypes = new HashMap();
    static final Map exceptionMimeTypes = new HashMap();

    public String getVersion() {
        return "1.0.0";
    }

    public static final String toFormatMIME(String format) {
        return WMS1_0_0.getMimeType(format, formatMimeTypes);
    }

    public static final String toExceptionMimeType(String exception) {
        return WMS1_0_0.getMimeType(exception, exceptionMimeTypes);
    }

    private static final String getMimeType(String key, Map map) {
        if (map.containsKey(key)) {
            return (String)map.get(key);
        }
        return null;
    }

    public static final String getFormatValue(String mimeType) {
        return WMS1_0_0.getParameterValue(mimeType, formatMimeTypes);
    }

    public static final String getExceptionValue(String mimeType) {
        return WMS1_0_0.getParameterValue(mimeType, exceptionMimeTypes);
    }

    private static final String getParameterValue(String mimeType, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (!mimeType.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public GetCapabilitiesRequest createGetCapabilitiesRequest(URL server) {
        return new GetCapsRequest(server);
    }

    private static String processKey(String key) {
        return key.trim().toLowerCase();
    }

    @Override
    public org.geotools.data.wms.request.GetMapRequest createGetMapRequest(URL get) {
        return new GetMapRequest(get);
    }

    @Override
    public org.geotools.data.wms.request.GetFeatureInfoRequest createGetFeatureInfoRequest(URL onlineResource, org.geotools.data.wms.request.GetMapRequest getMapRequest) {
        return new GetFeatureInfoRequest(onlineResource, getMapRequest);
    }

    @Override
    public DescribeLayerRequest createDescribeLayerRequest(URL onlineResource) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("WMS 1.0.0 does not support DescribeLayer");
    }

    @Override
    public GetLegendGraphicRequest createGetLegendGraphicRequest(URL onlineResource) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("WMS 1.0.0 does not support GetLegendGraphic");
    }

    @Override
    public GetStylesRequest createGetStylesRequest(URL onlineResource) throws UnsupportedOperationException {
        return new InternalGetStylesRequest(onlineResource);
    }

    @Override
    public PutStylesRequest createPutStylesRequest(URL onlineResource) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("WMS 1.0.0 does not support PutStyles");
    }

    static {
        exceptionMimeTypes.put("WMS_XML", "application/vnd.ogc.se_xml");
        exceptionMimeTypes.put("INIMAGE", "application/vnd.ogc.se_inimage");
        exceptionMimeTypes.put("BLANK", "application/vnd.ogc.se_blank");
        formatMimeTypes.put("GIF", "image/gif");
        formatMimeTypes.put("PNG", "image/png");
        formatMimeTypes.put("JPEG", "image/jpeg");
        formatMimeTypes.put("BMP", "image/bmp");
        formatMimeTypes.put("WebCGM", "image/cgm;Version=4;ProfileId=WebCGM");
        formatMimeTypes.put("SVG", "image/svg+xml");
        formatMimeTypes.put("GML.1", "text/xml");
        formatMimeTypes.put("GML.2", "text/xml");
        formatMimeTypes.put("GML.3", "text/xml");
        formatMimeTypes.put("WBMP", "image/vnd.wap.wbmp");
        formatMimeTypes.put("WMS_XML", "application/vnd.ogc.wms_xml");
        formatMimeTypes.put("MIME", "mime");
        formatMimeTypes.put("INIMAGE", "application/vnd.ogc.se_inimage");
        formatMimeTypes.put("TIFF", "image/tiff");
        formatMimeTypes.put("GeoTIFF", "image/tiff");
        formatMimeTypes.put("PPM", "image/x-portable-pixmap");
        formatMimeTypes.put("BLANK", "application/vnd.ogc.se_blank");
        formatMimeTypes.put("CW_WKB", "application/x-cubestor-wkb");
    }

    public static class InternalGetStylesRequest
    extends AbstractGetStylesRequest {
        public InternalGetStylesRequest(URL onlineResource) {
            super(onlineResource, null);
        }

        @Override
        protected void initVersion() {
            this.setProperty("VERSION", "1.1.0");
        }

        public Response createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new GetStylesResponse(httpResponse);
        }
    }

    public static class GetFeatureInfoRequest
    extends AbstractGetFeatureInfoRequest {
        public GetFeatureInfoRequest(URL onlineResource, org.geotools.data.wms.request.GetMapRequest request) {
            super(onlineResource, request);
        }

        @Override
        protected void initVersion() {
            this.setProperty("WMTVER", "1.0.0");
        }

        protected String processKey(String key) {
            return WMS1_0_0.processKey(key);
        }

        public Response createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new GetFeatureInfoResponse(httpResponse);
        }
    }

    public static class GetMapRequest
    extends AbstractGetMapRequest {
        public GetMapRequest(URL onlineResource) {
            super(onlineResource, null);
        }

        @Override
        protected void initRequest() {
            this.setProperty("REQUEST", "map");
            this.setProperty("EXCEPTIONS", "application/vnd.ogc.se_xml");
        }

        @Override
        protected void initVersion() {
            this.setProperty("VERSION", "1.0.0");
        }

        public void setProperty(String name, String value) {
            if (name.equals("FORMAT")) {
                value = this.getRequestFormat(value);
            } else if (name.equals("EXCEPTIONS")) {
                value = this.getRequestException(value);
            }
            super.setProperty(name, value);
        }

        @Override
        public void setFormat(String value) {
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Could not url encode the format", e);
            }
            super.setFormat(value);
        }

        @Override
        public void setExceptions(String exceptions) {
            this.setProperty("EXCEPTIONS", exceptions);
        }

        protected String getRequestException(String exception) {
            return WMS1_0_0.getExceptionValue(exception);
        }

        protected String getRequestFormat(String format) {
            return WMS1_0_0.getFormatValue(format);
        }

        protected String processKey(String key) {
            return WMS1_0_0.processKey(key);
        }

        public Response createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new GetMapResponse(httpResponse);
        }
    }

    public static class GetCapsRequest
    extends AbstractGetCapabilitiesRequest {
        public GetCapsRequest(URL urlGetCapabilities) {
            super(urlGetCapabilities);
        }

        protected void initVersion() {
            this.setProperty("WMTVER", "1.0.0");
            this.properties.remove("VERSION");
        }

        protected void initRequest() {
            this.setProperty("REQUEST", "capabilities");
        }

        protected void initService() {
        }

        protected String processKey(String key) {
            return WMS1_0_0.processKey(key);
        }

        public Response createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new WMSGetCapabilitiesResponse(httpResponse, this.hints);
        }
    }
}

