/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.netcdf;

import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhFileWriter;
import edu.ucar.ral.nujan.netcdf.NhGroup;
import java.lang.reflect.Array;
import java.util.Arrays;

public class NhVariable {
    public static final int TP_SBYTE = 1;
    public static final int TP_UBYTE = 2;
    public static final int TP_SHORT = 3;
    public static final int TP_INT = 4;
    public static final int TP_LONG = 5;
    public static final int TP_FLOAT = 6;
    public static final int TP_DOUBLE = 7;
    public static final int TP_CHAR = 8;
    public static final int TP_STRING_VAR = 9;
    public static final String[] nhTypeNames = new String[]{"UNKNOWN", "SBYTE", "UBYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "CHAR", "STRING_VAR"};
    String varName;
    int nhType;
    NhDimension[] nhDims;
    Object fillValue;
    int compressionLevel;
    NhGroup parentGroup;
    NhFileWriter nhFile;
    int rank;
    int dtype;
    int[] dimLens;
    HdfGroup hdfVar;

    NhVariable(String varName, int nhType, NhDimension[] nhDims, int[] chunkLens, Object fillValue, int compressionLevel, NhGroup parentGroup, NhFileWriter nhFile) throws NhException {
        this.varName = varName;
        this.nhType = nhType;
        this.nhDims = nhDims == null ? null : Arrays.copyOf(nhDims, nhDims.length);
        this.fillValue = fillValue;
        this.compressionLevel = compressionLevel;
        this.parentGroup = parentGroup;
        this.nhFile = nhFile;
        if (nhFile.bugs >= 1) {
            String msg = "NhVariable.const:  var name: \"" + varName + "\"\n" + "  nhType: " + nhTypeNames[nhType] + "\n" + "  dims: ";
            if (nhDims == null) {
                msg = msg + "(null)";
            } else {
                for (NhDimension dm : nhDims) {
                    msg = msg + "  \"" + dm.dimName + "\"(" + dm.dimLen + ")";
                }
            }
            msg = msg + "\n";
            msg = msg + "  chunkLens: " + NhGroup.formatInts(chunkLens) + "\n";
            msg = msg + "  fill: " + fillValue + "\n";
            msg = msg + "  compressionLevel: " + compressionLevel;
            NhVariable.prtf(msg, new Object[0]);
        }
        this.rank = nhDims == null ? 0 : nhDims.length;
        boolean isScalar = false;
        if (nhDims != null && nhDims.length == 0) {
            isScalar = true;
        }
        this.dtype = NhVariable.findDtype(varName, nhType);
        int stgFieldLen = 0;
        Object hdfFillValue = fillValue;
        if (this.dtype == 9 && nhType == 8) {
            stgFieldLen = 1;
            if (hdfFillValue != null) {
                if (hdfFillValue instanceof Character) {
                    char cc = ((Character)hdfFillValue).charValue();
                    hdfFillValue = new String(new char[]{cc});
                } else if (hdfFillValue instanceof String) {
                    String stg = (String)hdfFillValue;
                    if (stg.length() > 1) {
                        NhVariable.throwerr("char fillValue is String len > 1", new Object[0]);
                    }
                } else {
                    NhVariable.throwerr("unknown char fillValue class: " + hdfFillValue.getClass(), new Object[0]);
                }
            }
        }
        if (nhDims == null) {
            this.dimLens = null;
        } else {
            this.dimLens = new int[this.rank];
            for (int ii = 0; ii < this.rank; ++ii) {
                int dlen;
                NhDimension tdim = parentGroup.findAncestorDimension(nhDims[ii].getName());
                if (tdim != nhDims[ii]) {
                    NhVariable.throwerr("dimension not found.  var: %s  dim: %s", varName, nhDims[ii]);
                }
                if ((dlen = nhDims[ii].dimLen) <= 0 || dlen >= Integer.MAX_VALUE) {
                    NhVariable.throwerr("NhVariable: variable \"%s\", dimension %d, has illegal value: %d", varName, ii, dlen);
                }
                this.dimLens[ii] = dlen;
            }
        }
        NhDimension tdim = parentGroup.findAncestorDimension(varName);
        if (tdim != null) {
            if (nhFile.bugs >= 1) {
                NhVariable.prtf("NhVariable: coordVar: %s  dim: %s", this, tdim);
            }
            tdim.coordVar = this;
        }
        if (compressionLevel > 0 && nhType == 9) {
            NhVariable.throwerr("cannot use compression with TP_STRING_*", new Object[0]);
        }
        if ((this.dimLens == null || this.dimLens.length == 0) && compressionLevel > 0) {
            NhVariable.throwerr("cannot use compression with scalar data", new Object[0]);
        }
        try {
            this.hdfVar = parentGroup.hdfGroup.addVariable(varName, this.dtype, stgFieldLen, this.dimLens, chunkLens, hdfFillValue, compressionLevel);
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhVariable.throwerr("caught: " + exc, new Object[0]);
        }
        if (nhDims != null) {
            for (NhDimension nhDim : nhDims) {
                nhDim.refList.add(this);
            }
        }
    }

    public String toString() {
        String res = String.format("path: \"%s\"  type: %s  compress: %d  rank: %d  dims: (", this.getPath(), nhTypeNames[this.nhType], this.compressionLevel, this.rank);
        for (NhDimension nd : this.nhDims) {
            res = res + "  " + nd.dimName + "(" + nd.dimLen + ")";
        }
        res = res + ")";
        return res;
    }

    public int getType() {
        return this.nhType;
    }

    public NhDimension[] getDimensions() {
        return this.nhDims;
    }

    public Object getFillValue() {
        return this.fillValue;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public NhGroup getParentGroup() {
        return this.parentGroup;
    }

    public NhFileWriter getFileWriter() {
        return this.nhFile;
    }

    public String getName() {
        return this.varName;
    }

    public String getPath() {
        return this.parentGroup.getPath() + "/" + this.varName;
    }

    public boolean attributeExists(String attrName) {
        boolean bres = false;
        if (this.hdfVar.findAttribute(attrName) != null) {
            bres = true;
        }
        return bres;
    }

    public void addAttribute(String attrName, int atType, Object attrValue) throws NhException {
        if (this.nhFile.bugs >= 1) {
            NhVariable.prtf("NhVariable.addAttribute: var: \"" + this.varName + "\"" + "  nm: \"" + attrName + "\"" + "  type: " + nhTypeNames[atType], new Object[0]);
        }
        if (this.nhFile.bugs >= 10) {
            NhVariable.prtf("  attrValue: \"%s\"", attrValue);
        }
        NhGroup.checkName(attrName, "attribute in variable \"" + this.varName + "\"");
        attrValue = NhVariable.getAttrValue(attrName, attrValue, "variable \"" + this.varName + "\"", this.nhFile.bugs);
        int dtype = NhVariable.findDtype(attrName, atType);
        if (dtype == 10 && NhVariable.testScalar(attrValue)) {
            dtype = 9;
        }
        int stgFieldLen = 0;
        try {
            this.hdfVar.addAttribute(attrName, dtype, stgFieldLen, attrValue, false);
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhVariable.throwerr("caught: " + exc, new Object[0]);
        }
    }

    public void writeData(int[] startIxs, Object rawData) throws NhException {
        this.writeData(startIxs, rawData, false);
    }

    public void writeData(int[] startIxs, Object rawData, boolean useLinear) throws NhException {
        if (this.nhFile.bugs >= 1) {
            NhVariable.prtf("NhVariable.writeData: nhType: " + nhTypeNames[this.nhType] + "\n" + "  startIxs: " + NhGroup.formatInts(startIxs) + "\n" + "  useLinear: " + useLinear + "\n" + "  rawData class: " + rawData.getClass(), new Object[0]);
        }
        if (rawData == null) {
            NhVariable.throwerr("rawData is null", new Object[0]);
        }
        if (rawData instanceof ucar.ma2.Array) {
            ucar.ma2.Array arr = (ucar.ma2.Array)rawData;
            if (arr.getRank() == 0) {
                if (arr.getSize() != 1L) {
                    NhVariable.throwerr("unknown array size", new Object[0]);
                }
                Object copy1d = arr.copyTo1DJavaArray();
                rawData = Array.get(copy1d, 0);
            } else {
                rawData = useLinear ? arr.copyTo1DJavaArray() : ((ucar.ma2.Array)rawData).copyToNDJavaArray();
            }
        }
        Object vdata = null;
        vdata = this.nhType == 8 ? NhVariable.convertCharsToStrings(this.dimLens, rawData, this.nhFile.bugs) : rawData;
        try {
            this.hdfVar.writeData(startIxs, vdata, useLinear);
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhVariable.throwerr("caught: " + exc, new Object[0]);
        }
    }

    static Object getAttrValue(String attrName, Object attrValue, String loc, int bugs) throws NhException {
        Object resValue = null;
        boolean valOk = true;
        if (attrValue == null) {
            resValue = null;
        } else if (attrValue instanceof Byte) {
            resValue = new byte[]{(Byte)attrValue};
        } else if (attrValue instanceof Short) {
            resValue = new short[]{(Short)attrValue};
        } else if (attrValue instanceof Integer) {
            resValue = new int[]{(Integer)attrValue};
        } else if (attrValue instanceof Long) {
            resValue = new long[]{(Long)attrValue};
        } else if (attrValue instanceof Float) {
            resValue = new float[]{((Float)attrValue).floatValue()};
        } else if (attrValue instanceof Double) {
            resValue = new double[]{(Double)attrValue};
        } else if (attrValue instanceof Character) {
            resValue = new String(new char[]{((Character)attrValue).charValue()});
        } else if (attrValue instanceof String[]) {
            resValue = attrValue;
        } else if (attrValue instanceof byte[] || attrValue instanceof short[] || attrValue instanceof int[] || attrValue instanceof long[] || attrValue instanceof float[] || attrValue instanceof double[]) {
            resValue = attrValue;
        } else if (attrValue instanceof char[]) {
            char[] vals = (char[])attrValue;
            resValue = vals.length == 0 ? (Object)new String[0] : (Object)new String(vals);
        } else if (attrValue instanceof Object[]) {
            Object[] objs;
            for (Object obj : objs = (Object[])attrValue) {
                if (obj != null && obj instanceof String) continue;
                valOk = false;
            }
            resValue = attrValue;
        } else if (attrValue instanceof String) {
            resValue = attrValue;
        } else {
            valOk = false;
        }
        if (!valOk) {
            NhVariable.throwerr("Invalid type for the value of attribute \"%s\" in %s.  Type: %s", attrName, loc, attrValue.getClass().toString());
        }
        if (bugs >= 10) {
            NhVariable.prtf("getAttrValue: loc: " + loc + "  attrName: " + attrName, new Object[0]);
            NhVariable.prtf("  specd attrValue: \"%s\"", attrValue);
            NhVariable.prtf("  final resValue:  %s", resValue);
        }
        return resValue;
    }

    static Object convertCharsToStrings(int[] dlens, Object rawData, int bugs) throws NhException {
        if (rawData == null) {
            NhVariable.throwerr("rawData is null", new Object[0]);
        }
        Object[] vdata = null;
        if (dlens.length == 0) {
            if (rawData instanceof Character) {
                Character spec = (Character)rawData;
                vdata = new String(new char[]{spec.charValue()});
            } else if (rawData instanceof String) {
                String[] rawStg = (String[])rawData;
                if (rawStg.length() > 1) {
                    NhVariable.throwerr("scalar data has len > 1", new Object[0]);
                }
                vdata = rawStg;
            } else {
                NhVariable.throwerr("unknown rawData class: " + rawData.getClass(), new Object[0]);
            }
        } else if (dlens.length == 1) {
            if (rawData instanceof char[]) {
                char[] rawChars = (char[])rawData;
                int nn = dlens[0];
                if (rawChars.length > nn) {
                    NhVariable.throwerr("data len exceeds bounds", new Object[0]);
                }
                String[] stgs = new String[nn];
                for (int ii = 0; ii < nn; ++ii) {
                    stgs[ii] = ii < rawChars.length ? new String(rawChars, ii, 1) : "";
                }
                vdata = stgs;
            } else if (rawData instanceof String) {
                int nn = dlens[0];
                String rawStg = (String)rawData;
                if (rawStg.length() > nn) {
                    NhVariable.throwerr("data len exceeds bounds", new Object[0]);
                }
                String[] stgs = new String[nn];
                for (int ii = 0; ii < nn; ++ii) {
                    stgs[ii] = ii < rawStg.length() ? rawStg.substring(ii, ii + 1) : "";
                }
                vdata = stgs;
            } else {
                NhVariable.throwerr("unknown rawData class: " + rawData.getClass(), new Object[0]);
            }
        } else {
            Object[] rawObjs;
            int nn = dlens[0];
            int[] subDlens = Arrays.copyOfRange(dlens, 1, dlens.length);
            if (!(rawData instanceof Object[])) {
                NhVariable.throwerr("rawData wrong class: " + rawData.getClass(), new Object[0]);
            }
            if ((rawObjs = (Object[])rawData).length > dlens[0]) {
                NhVariable.throwerr("data len exceeds bounds", new Object[0]);
            }
            Object[] objs = new Object[nn];
            for (int ii = 0; ii < nn; ++ii) {
                objs[ii] = NhVariable.convertCharsToStrings(subDlens, rawObjs[ii], bugs);
            }
            vdata = objs;
        }
        if (bugs >= 1) {
            NhVariable.prtf("convertCharsToStrings: new vdata: " + vdata, new Object[0]);
        }
        return vdata;
    }

    static int findDtype(String nm, int nhTp) throws NhException {
        int dtype = 0;
        if (nhTp == 1) {
            dtype = 1;
        } else if (nhTp == 2) {
            dtype = 2;
        } else if (nhTp == 3) {
            dtype = 3;
        } else if (nhTp == 4) {
            dtype = 4;
        } else if (nhTp == 5) {
            dtype = 5;
        } else if (nhTp == 6) {
            dtype = 6;
        } else if (nhTp == 7) {
            dtype = 7;
        } else if (nhTp == 8) {
            dtype = 9;
        } else if (nhTp == 9) {
            dtype = 10;
        } else {
            NhVariable.throwerr("NhVariable: variable or attr \"%s\" has unknown type: %d", nm, nhTp);
        }
        return dtype;
    }

    static boolean testScalar(Object val) {
        boolean bres = false;
        if (val != null && (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long || val instanceof Float || val instanceof Double || val instanceof Character || val instanceof String)) {
            bres = true;
        }
        return bres;
    }

    static void throwerr(String msg, Object ... args) throws NhException {
        throw new NhException(String.format(msg, args));
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }
}

