/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.netcdf;

import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhGroup;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.util.ArrayList;

public class NhFileWriter {
    public static final int OPT_OVERWRITE = 1;
    public static final int ST_DEFINING = 1;
    public static final int ST_WRITEDATA = 2;
    public static final int ST_CLOSED = 3;
    public static final String[] statusNames = new String[]{"UNKNOWN", "DEFINING", "WRITEDATA", "CLOSED"};
    String path;
    int optFlag;
    int fileStatus;
    private HdfFileWriter hdfFile;
    NhGroup rootGroup;
    int bugs;

    public NhFileWriter(String path) throws NhException {
        this(path, 0, 0, 0, 0L, null, null);
    }

    public NhFileWriter(String path, int optFlag) throws NhException {
        this(path, optFlag, 0, 0, 0L, null, null);
    }

    public NhFileWriter(String path, int optFlag, String logDir, String statTag) throws NhException {
        this(path, optFlag, 0, 0, 0L, logDir, statTag);
    }

    public NhFileWriter(String path, int optFlag, int nhDebugLevel, int hdfDebugLevel, long utcModTime, String logDir, String statTag) throws NhException {
        this.path = path;
        this.optFlag = optFlag;
        this.bugs = nhDebugLevel;
        if (this.bugs >= 1) {
            NhFileWriter.prtf("NhFileWriter.const: path: \"%s\"\n  optFlag: %d  softwareVersion: %s", path, optFlag, HdfFileWriter.getSoftwareVersion());
        }
        this.fileStatus = 1;
        try {
            int hdfOptFlag = 0;
            if ((optFlag & 1) != 0) {
                hdfOptFlag |= 1;
            }
            this.hdfFile = new HdfFileWriter(path, hdfOptFlag, hdfDebugLevel, utcModTime, logDir, statTag);
            this.rootGroup = new NhGroup("", null, this);
            this.rootGroup.hdfGroup = this.hdfFile.getRootGroup();
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhFileWriter.throwerr("caught: " + exc, new Object[0]);
        }
    }

    public String toString() {
        String res = "path: \"" + this.path + "\"" + "  status: " + statusNames[this.fileStatus] + "  softwareVersion: " + HdfFileWriter.getSoftwareVersion();
        return res;
    }

    public static String getSoftwareVersion() {
        return HdfFileWriter.getSoftwareVersion();
    }

    public void setDebugLevel(int bugs) {
        this.bugs = bugs;
    }

    public void setHdfDebugLevel(int bugs) {
        this.hdfFile.setDebugLevel(bugs);
    }

    public String getPath() {
        return this.path;
    }

    public int getOptFlag() {
        return this.optFlag;
    }

    public int getStatus() {
        return this.fileStatus;
    }

    public NhGroup getRootGroup() {
        return this.rootGroup;
    }

    public void endDefine() throws NhException {
        if (this.bugs >= 1) {
            NhFileWriter.prtf("NhFileWriter.endDefine: path: \"%s\"", this.path);
        }
        if (this.fileStatus != 1) {
            NhFileWriter.throwerr("already called endDefine", new Object[0]);
        }
        this.fileStatus = 2;
        ArrayList<NhGroup> groupList = new ArrayList<NhGroup>();
        ArrayList<NhVariable> variableList = new ArrayList<NhVariable>();
        this.findGroupsAndVars(this.rootGroup, groupList, variableList);
        for (NhGroup grp : groupList) {
            for (NhDimension dim : grp.dimensionList) {
                try {
                    String nameAttrValue;
                    if (dim.coordVar == null) {
                        dim.hdfDimVar = dim.parentGroup.hdfGroup.addVariable(dim.dimName, 6, 0, new int[]{dim.dimLen}, null, new Float(0.0f), 0);
                        nameAttrValue = String.format("%s%10d\u0000", "This is a netCDF dimension but not a netCDF variable.", dim.dimLen);
                    } else {
                        dim.hdfDimVar = dim.coordVar.hdfVar;
                        nameAttrValue = dim.dimName;
                    }
                    dim.hdfDimVar.addAttribute("CLASS", 9, 0, "DIMENSION_SCALE\u0000", false);
                    dim.hdfDimVar.addAttribute("NAME", 9, 0, nameAttrValue, false);
                    NhVariable[] nhRefVars = new NhVariable[dim.refList.size()];
                    HdfGroup[] hdfRefVars = new HdfGroup[dim.refList.size()];
                    for (int ii = 0; ii < hdfRefVars.length; ++ii) {
                        nhRefVars[ii] = dim.refList.get(ii);
                        hdfRefVars[ii] = nhRefVars[ii].hdfVar;
                    }
                    if (nhRefVars.length == 0 || nhRefVars.length == 1 && nhRefVars[0].varName.equals(dim.dimName)) continue;
                    dim.hdfDimVar.addAttribute("REFERENCE_LIST", 13, 0, hdfRefVars, false);
                }
                catch (HdfException exc) {
                    exc.printStackTrace();
                    NhFileWriter.throwerr("caught: " + exc, new Object[0]);
                }
            }
        }
        for (NhVariable nhvar : variableList) {
            if (nhvar.rank <= 0) continue;
            HdfGroup[][] dimVarMat = new HdfGroup[nhvar.rank][1];
            NhDimension coordDim = null;
            for (int ii = 0; ii < nhvar.rank; ++ii) {
                NhDimension dim = nhvar.nhDims[ii];
                if (dim.coordVar != null) {
                    coordDim = dim;
                }
                dimVarMat[ii][0] = dim.hdfDimVar;
            }
            if (dimVarMat.length == 1 && coordDim != null && coordDim.dimName.equals(nhvar.varName)) continue;
            try {
                nhvar.hdfVar.addAttribute("DIMENSION_LIST", 11, 0, dimVarMat, true);
            }
            catch (HdfException exc) {
                exc.printStackTrace();
                NhFileWriter.throwerr("caught: " + exc, new Object[0]);
            }
        }
        try {
            this.hdfFile.endDefine();
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhFileWriter.throwerr("caught: " + exc, new Object[0]);
        }
        this.writeTreeDimData(this.rootGroup);
    }

    void findGroupsAndVars(NhGroup grp, ArrayList<NhGroup> groupList, ArrayList<NhVariable> variableList) {
        groupList.add(grp);
        variableList.addAll(grp.variableList);
        for (NhGroup subGrp : grp.subGroupList) {
            this.findGroupsAndVars(subGrp, groupList, variableList);
        }
    }

    void writeTreeDimData(NhGroup nhGroup) throws NhException {
        int[] startIxs = null;
        for (NhDimension nhdim : nhGroup.dimensionList) {
            if (nhdim.coordVar == null) {
                float[] dimData = new float[nhdim.dimLen];
                try {
                    nhdim.hdfDimVar.writeData(startIxs, dimData, false);
                }
                catch (HdfException exc) {
                    exc.printStackTrace();
                    NhFileWriter.throwerr("caught: " + exc, new Object[0]);
                }
            }
            for (NhGroup subGroup : nhGroup.subGroupList) {
                this.writeTreeDimData(subGroup);
            }
        }
    }

    public void close() throws NhException {
        if (this.bugs >= 1) {
            NhFileWriter.prtf("NhFileWriter.close: path: \"%s\"", this.path);
        }
        if (this.fileStatus == 1) {
            NhFileWriter.throwerr("must call endDefine before calling close", new Object[0]);
        } else if (this.fileStatus == 3) {
            NhFileWriter.throwerr("file is already closed", new Object[0]);
        } else if (this.fileStatus != 2) {
            NhFileWriter.throwerr("invalid fileStatus", new Object[0]);
        }
        this.fileStatus = 3;
        try {
            this.hdfFile.close();
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhFileWriter.throwerr("caught: " + exc, new Object[0]);
        }
    }

    static void throwerr(String msg, Object ... args) throws NhException {
        throw new NhException(String.format(msg, args));
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }
}

