/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.netcdf;

import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.netcdf.FieldSpec;
import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhFileWriter;
import edu.ucar.ral.nujan.netcdf.NhGroup;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NhCopy {
    static final int SCALE_MISSING = -999999;

    public static void main(String[] args) {
        try {
            NhCopy.copyIt(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            NhCopy.prtf("main: caught: %s", exc);
            System.exit(1);
        }
    }

    static void badparms(int bugs, String msg) {
        NhCopy.prtf("Error: " + msg, new Object[0]);
        NhCopy.prtf("Parms:", new Object[0]);
        NhCopy.prtf("  -bugs       debug level.  Default is 0.", new Object[0]);
        NhCopy.prtf("  -compress   compressionLevel for outFile.  0: none,  9: max", new Object[0]);
        NhCopy.prtf("  -inFile     input file name.", new Object[0]);
        NhCopy.prtf("  -outFile    output file name.", new Object[0]);
        NhCopy.prtf("", new Object[0]);
        NhCopy.prtf("  -field      name", new Object[0]);
        NhCopy.prtf("              or", new Object[0]);
        NhCopy.prtf("              name:iscale.", new Object[0]);
        NhCopy.prtf("              or", new Object[0]);
        NhCopy.prtf("              name:iscale:chunkLen,chunkLen,... (one len per dim).", new Object[0]);
        NhCopy.prtf("              The -field arg may be repeated.", new Object[0]);
        NhCopy.prtf("                name: fully qualified field name.", new Object[0]);
        NhCopy.prtf("                iscale: \"none\" or int scaling value, like grib2:", new Object[0]);
        NhCopy.prtf("                  iscale == num digits to right of dec point.", new Object[0]);
        NhCopy.prtf("                  mfact = 10^iscale", new Object[0]);
        NhCopy.prtf("                  encodedVal = (int) (mfact * trueVal)", new Object[0]);
        NhCopy.prtf("                  If iscale is followed by \"d\", like \"2d\",", new Object[0]);
        NhCopy.prtf("                  we use spatial differencing.", new Object[0]);
        NhCopy.prtf("                chunkLens: The chunkLen for each dimension,", new Object[0]);
        NhCopy.prtf("                  or omitted.", new Object[0]);
        NhCopy.prtf("                Note: this feature is for testing only,", new Object[0]);
        NhCopy.prtf("                works on float vars having 1 <= rank <= 4.", new Object[0]);
        if (bugs > 1) {
            NhCopy.prtf("", new Object[0]);
            NhCopy.prtf("  -utcModTime  0: now, or yyyy-mm-dd or yyyy-mm-ddThh:mm:ss", new Object[0]);
            NhCopy.prtf("  -useLinear   use linear mode (not with chunks)", new Object[0]);
            NhCopy.prtf("  -useArray    pass netcdf Array to writeData (not with chunks)", new Object[0]);
        }
        NhCopy.prtf("", new Object[0]);
        NhCopy.prtf("Example:", new Object[0]);
        NhCopy.prtf("java -cp tdcls:netcdfAll-4.2.jar testpk.NhCopy -compress 0 -inFile ta.nc -outFile tb.nc", new Object[0]);
        System.exit(1);
    }

    static void copyIt(String[] args) throws NhException {
        FieldSpec fspec;
        int bugs = 0;
        String logDir = null;
        String statTag = null;
        int compressionLevel = -1;
        String inFile = null;
        String outFile = null;
        int numFieldSpec = 0;
        HashMap<String, FieldSpec> fieldMap = new HashMap<String, FieldSpec>();
        long utcModTime = 0L;
        boolean useLinear = false;
        boolean useArray = false;
        int iarg = 0;
        while (iarg < args.length) {
            String key = args[iarg++];
            if (iarg >= args.length) {
                NhCopy.badparms(bugs, "no value for the last key");
            }
            String val = args[iarg++];
            if (key.equals("-bugs")) {
                bugs = NhCopy.parseInt("-bugs", val);
                continue;
            }
            if (key.equals("-compress")) {
                compressionLevel = NhCopy.parseInt("-compress", val);
                if (compressionLevel >= 0 && compressionLevel <= 9) continue;
                NhCopy.badparms(bugs, "invalid compress: " + compressionLevel);
                continue;
            }
            if (key.equals("-inFile")) {
                inFile = val;
                continue;
            }
            if (key.equals("-outFile")) {
                outFile = val;
                continue;
            }
            if (key.equals("-field")) {
                ++numFieldSpec;
                String[] toks = val.split(":");
                String name = toks[0];
                int iscale = -999999;
                boolean useDiff = false;
                double mfact = 0.0;
                if (toks.length == 0) {
                    NhCopy.badparms(bugs, "invalid -field spec");
                } else if (toks.length == 1 || toks.length == 2 && toks[1].equals("none")) {
                    iscale = -999999;
                    useDiff = false;
                    mfact = 0.0;
                } else {
                    if (toks.length < 2) {
                        NhCopy.badparms(bugs, "invalid -field spec");
                    }
                    if (toks[1].endsWith("d")) {
                        toks[1] = toks[1].substring(0, toks[1].length() - 1);
                        useDiff = true;
                    }
                    iscale = NhCopy.parseInt("scale", toks[1]);
                    mfact = 1.0;
                    if (iscale < 0) {
                        for (int ii = 0; ii < -iscale; ++ii) {
                            mfact *= 0.1;
                        }
                    } else if (iscale > 0) {
                        for (int ii = 0; ii < iscale; ++ii) {
                            mfact *= 10.0;
                        }
                    }
                }
                fspec = new FieldSpec(true, name, iscale, useDiff, mfact);
                fieldMap.put(name, fspec);
                if (toks.length <= 2) continue;
                fspec.chunkLens = new int[toks.length - 2];
                for (int ii = 0; ii < fspec.chunkLens.length; ++ii) {
                    fspec.chunkLens[ii] = NhCopy.parseInt("chunkLen", toks[2 + ii]);
                }
                continue;
            }
            if (key.equals("-testValLog")) {
                logDir = val;
                statTag = "stats";
                continue;
            }
            if (key.equals("-utcModTime")) {
                try {
                    utcModTime = HdfUtil.parseUtcTime(val);
                }
                catch (HdfException exc) {
                    exc.printStackTrace();
                    NhCopy.badparms(bugs, "invalid -utcModTime: \"" + val + "\"");
                }
                continue;
            }
            if (key.equals("-useLinear")) {
                useLinear = NhCopy.parseBoolean("-useLinear", val);
                continue;
            }
            if (key.equals("-useArray")) {
                useArray = NhCopy.parseBoolean("-useArray", val);
                continue;
            }
            NhCopy.badparms(bugs, "unknown parm: \"" + key + "\"");
        }
        if (compressionLevel < 0) {
            NhCopy.badparms(bugs, "parm not specified: -compress");
        }
        if (inFile == null) {
            NhCopy.badparms(bugs, "parm not specified: -inFile");
        }
        if (outFile == null) {
            NhCopy.badparms(bugs, "parm not specified: -outFile");
        }
        for (FieldSpec fspec2 : fieldMap.values()) {
            if (fspec2.chunkLens != null) {
                if (useLinear) {
                    NhCopy.throwerr("Sorry, useLinear with chunkLens not yet implemented.", new Object[0]);
                }
                if (useArray) {
                    NhCopy.throwerr("Sorry, useArray with chunkLens not yet implemented.", new Object[0]);
                }
            }
            if (fspec2.iscale == -999999 || useLinear) continue;
            NhCopy.throwerr("Sorry, scaling requires useLinear.", new Object[0]);
        }
        if (bugs >= 1) {
            NhCopy.prtf("copyIt: compress: %d", compressionLevel);
            NhCopy.prtf("copyIt: inFile: \"%s\"", inFile);
            NhCopy.prtf("copyIt: outFile: \"%s\"", outFile);
            if (numFieldSpec == 0) {
                NhCopy.prtf("copyIt: fields: (all)", new Object[0]);
            } else {
                Object[] keys = fieldMap.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    FieldSpec fspec3 = fieldMap.get(key);
                    String tmsg = "none";
                    if (fspec3.iscale != -999999) {
                        tmsg = "" + fspec3.iscale;
                    }
                    NhCopy.prtf("copyIt: field: \"" + fspec3.name + "\"  iscale: " + tmsg, new Object[0]);
                    if (fspec3.chunkLens == null) continue;
                    NhCopy.prtf("  chunkLens: " + NhCopy.formatInts(fspec3.chunkLens), new Object[0]);
                }
            }
        }
        NetcdfFile inCdf = null;
        NhFileWriter outCdf = null;
        try {
            inCdf = NetcdfFile.open(inFile);
            outCdf = new NhFileWriter(outFile, 1, bugs, bugs, utcModTime, logDir, statTag);
            Group inGroup = inCdf.getRootGroup();
            NhGroup outGroup = outCdf.getRootGroup();
            NhCopy.copyGroup(1, numFieldSpec, fieldMap, compressionLevel, inGroup, outGroup, useLinear, useArray, bugs);
            outCdf.endDefine();
            NhCopy.copyGroup(2, numFieldSpec, fieldMap, compressionLevel, inGroup, outGroup, useLinear, useArray, bugs);
            inCdf.close();
            inCdf = null;
            outCdf.close();
            outCdf = null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            NhCopy.badparms(bugs, "const: caught: " + exc);
        }
        boolean allOk = true;
        Object[] keys = fieldMap.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            fspec = fieldMap.get(key);
            if (fspec.isFound) continue;
            allOk = false;
            NhCopy.prtf("Error: field not found: \"" + fspec.name + "\"", new Object[0]);
        }
        if (!allOk) {
            NhCopy.throwerr("at least one field not found", new Object[0]);
        }
    }

    static void copyGroup(int pass, int numFieldSpec, HashMap<String, FieldSpec> fieldMap, int compressionLevel, Group inGroup, NhGroup outGroup, boolean useLinear, boolean useArray, int bugs) throws NhException {
        if (bugs >= 1) {
            NhCopy.prtf("copyGroup: pass: %d  inGroup: %s", pass, inGroup);
        }
        if (pass == 1) {
            for (Attribute attr : inGroup.getAttributes()) {
                NhCopy.copyAttribute(attr, outGroup.getName(), outGroup, useLinear, bugs);
            }
            for (Dimension dim : inGroup.getDimensions()) {
                outGroup.addDimension(dim.getName(), dim.getLength());
            }
        }
        for (Variable var : inGroup.getVariables()) {
            FieldSpec fspec;
            if (bugs >= 2) {
                NhCopy.prtf("NhCopy.copyGroup: pass: " + pass + "  var: " + var.getName(), new Object[0]);
            }
            if ((fspec = fieldMap.get(var.getName())) == null) {
                fspec = new FieldSpec(false, var.getName(), -999999, false, 0.0);
                fieldMap.put(var.getName(), fspec);
            }
            fspec.isFound = true;
            if (numFieldSpec != 0 && !fspec.isSpec) continue;
            if (var.getDataType() == DataType.STRUCTURE) {
                if (pass != 1) continue;
                NhCopy.prtf("Warning: skipping structure: " + var, new Object[0]);
                continue;
            }
            if (pass == 1) {
                NhCopy.copyVarDef(fspec, compressionLevel, var, outGroup, useLinear, bugs);
                continue;
            }
            NhCopy.copyData(fspec, var, outGroup, useLinear, useArray, bugs);
        }
        for (Group inSub : inGroup.getGroups()) {
            NhGroup outSub = pass == 1 ? outGroup.addGroup(inSub.getShortName()) : outGroup.findSubGroup(inSub.getShortName());
            NhCopy.copyGroup(pass, numFieldSpec, fieldMap, compressionLevel, inSub, outSub, useLinear, useArray, bugs);
        }
    }

    static void copyVarDef(FieldSpec fspec, int compressionLevel, Variable inVar, NhGroup outGroup, boolean useLinear, int bugs) throws NhException {
        if (bugs >= 1) {
            NhCopy.prtf("copyVarDef: inVar: %s", inVar);
            NhCopy.prtf("  name: \"%s\"", inVar.getName());
            NhCopy.prtf("  type: %s", inVar.getDataType());
            NhCopy.prtf("  isUnsigned: %s", inVar.isUnsigned());
            NhCopy.prtf("  isScalar: %s", inVar.isScalar());
            NhCopy.prtf("  rank: %d", inVar.getRank());
            String tmsg = "";
            for (int ii : inVar.getShape()) {
                tmsg = tmsg + "  " + ii;
            }
            NhCopy.prtf("  shape: %s", tmsg);
        }
        DataType tp = inVar.getDataType();
        int nhType = 0;
        if (tp == DataType.BYTE) {
            nhType = inVar.isUnsigned() ? 2 : 1;
        } else if (tp == DataType.SHORT) {
            nhType = 3;
        } else if (tp == DataType.INT) {
            nhType = 4;
        } else if (tp == DataType.LONG) {
            nhType = 5;
        } else if (tp == DataType.FLOAT) {
            nhType = 6;
        } else if (tp == DataType.DOUBLE) {
            nhType = 7;
        } else if (tp == DataType.CHAR) {
            nhType = 8;
        } else if (tp == DataType.STRING) {
            nhType = 9;
        } else {
            NhCopy.throwerr("unknown type \"%s\" for variable \"%s\"", tp, inVar.getName());
        }
        if (fspec.iscale != -999999) {
            if (tp != DataType.FLOAT && tp != DataType.DOUBLE && tp != DataType.BYTE && tp != DataType.INT && tp != DataType.LONG && tp != DataType.SHORT) {
                NhCopy.throwerr("cannot scale a non-numeric type", new Object[0]);
            }
            Array arr = null;
            try {
                arr = inVar.read();
            }
            catch (IOException exc) {
                exc.printStackTrace();
                NhCopy.throwerr("caught: " + exc, new Object[0]);
            }
            NhCopy.getStatistics(tp, arr, fspec);
            double range = (fspec.maxVal - fspec.minVal) * fspec.mfact;
            if (range < 250.0) {
                fspec.nhPackType = 1;
                fspec.offset = fspec.minVal + 125.0;
                fspec.packFillValue = -126;
            } else if (range < 64000.0) {
                fspec.nhPackType = 3;
                fspec.offset = fspec.minVal + 32000.0;
                fspec.packFillValue = -32001;
            } else if (range < 4.294E9) {
                fspec.nhPackType = 4;
                fspec.offset = fspec.minVal + 2.147E9;
                fspec.packFillValue = -2147000001;
            } else {
                fspec.iscale = -999999;
            }
            NhCopy.prtf("copyVarDef: fspec: " + fspec, new Object[0]);
        }
        if (bugs >= 1) {
            NhCopy.prtf("copyVarDef: nhType: %s", NhVariable.nhTypeNames[nhType]);
        }
        NhDimension[] nhDims = NhCopy.getNhDims(inVar, outGroup);
        int[] dimLens = new int[nhDims.length];
        for (int ii = 0; ii < dimLens.length; ++ii) {
            dimLens[ii] = nhDims[ii].getLength();
        }
        fspec.origFillValueObj = null;
        Attribute fillAttr = inVar.findAttribute("_FillValue");
        if (fillAttr != null) {
            Object[] vals;
            Object fillValue = NhCopy.getAttrValue(fillAttr, useLinear, bugs);
            if (nhType == 8) {
                byte[] bytes;
                if (fillValue instanceof Byte) {
                    bytes = new byte[]{(Byte)fillValue};
                    fillValue = new String(bytes);
                } else if (fillValue instanceof byte[]) {
                    bytes = (byte[])fillValue;
                    if (bytes.length != 1) {
                        NhCopy.throwerr("unexpected fillValue class: " + fillValue.getClass(), new Object[0]);
                    }
                    fillValue = new String(bytes);
                } else {
                    NhCopy.throwerr("unexpected fillValue class: " + fillValue.getClass(), new Object[0]);
                }
            }
            if (fillValue instanceof byte[]) {
                vals = (byte[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Byte(vals[0]);
            } else if (fillValue instanceof short[]) {
                vals = (short[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Short(vals[0]);
            } else if (fillValue instanceof int[]) {
                vals = (int[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Integer(vals[0]);
            } else if (fillValue instanceof long[]) {
                vals = (long[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Long(vals[0]);
            } else if (fillValue instanceof float[]) {
                vals = (float[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Float(vals[0]);
            } else if (fillValue instanceof double[]) {
                vals = (double[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Double(vals[0]);
            } else if (fillValue instanceof char[]) {
                vals = (char[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                fillValue = new Character((char)vals[0]);
            } else if (fillValue instanceof Object[]) {
                vals = (Object[])fillValue;
                if (vals.length != 1) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
                if ((fillValue = (Object)vals[0]) instanceof Object[]) {
                    NhCopy.throwerr("invalid fillValue for inVar: " + inVar, new Object[0]);
                }
            }
            fspec.origFillValueObj = fillValue;
        }
        int[] useChunkLens = null;
        if (nhDims.length > 0) {
            if (fspec.chunkLens != null) {
                if (nhDims.length == 0) {
                    NhCopy.throwerr("cannot spec chunkLens for scaler.  inVar: " + inVar, new Object[0]);
                }
                if (fspec.chunkLens.length != nhDims.length) {
                    NhCopy.throwerr("chunkLens rank mismatch for inVar: " + inVar, new Object[0]);
                }
                for (int ii = 0; ii < nhDims.length; ++ii) {
                    if (fspec.chunkLens[ii] <= dimLens[ii]) continue;
                    NhCopy.throwerr("chunkLen exceeds dim for var: " + inVar, new Object[0]);
                }
                useChunkLens = fspec.chunkLens;
            } else {
                useChunkLens = dimLens;
            }
        }
        int compress = compressionLevel;
        if (nhDims.length == 0) {
            compress = 0;
        }
        int tmpType = nhType;
        Object tmpFill = fspec.origFillValueObj;
        if (fspec.iscale != -999999) {
            tmpType = fspec.nhPackType;
            if (fspec.nhPackType == 1) {
                tmpFill = new Byte((byte)fspec.packFillValue);
            } else if (fspec.nhPackType == 3) {
                tmpFill = new Short((short)fspec.packFillValue);
            } else if (fspec.nhPackType == 4) {
                tmpFill = new Integer(fspec.packFillValue);
            } else {
                NhCopy.throwerr("unknown nhPackType", new Object[0]);
            }
        }
        NhVariable outVar = outGroup.addVariable(inVar.getShortName(), tmpType, nhDims, useChunkLens, tmpFill, compress);
        if (fspec.iscale != -999999) {
            outVar.addAttribute("_Scale", 6, Float.valueOf((float)(1.0 / fspec.mfact)));
            outVar.addAttribute("scale_factor", 6, Float.valueOf((float)(1.0 / fspec.mfact)));
            outVar.addAttribute("_Offset", 6, Float.valueOf((float)fspec.offset));
            outVar.addAttribute("add_offset", 6, Float.valueOf((float)fspec.offset));
            outVar.addAttribute("_FillValue", tmpType, tmpFill);
        }
        for (Attribute attr : inVar.getAttributes()) {
            if (fspec.iscale != -999999 && (attr.getName().equals("_Scale") || attr.getName().equals("scale_factor") || attr.getName().equals("_Offset") || attr.getName().equals("add_offset") || attr.getName().equals("_FillValue"))) {
                if (bugs < 0) continue;
                NhCopy.prtf("attribute changed for scaling: %s/%s", inVar.getName(), attr.getName());
                continue;
            }
            NhCopy.copyAttribute(attr, outVar.getName(), outVar, useLinear, bugs);
        }
    }

    static NhDimension[] getNhDims(Variable inVar, NhGroup outGroup) throws NhException {
        ArrayList<NhDimension> nhDimList = new ArrayList<NhDimension>();
        for (Dimension dim : inVar.getDimensions()) {
            NhDimension nhDim = null;
            for (NhGroup grp = outGroup; grp != null; grp = grp.getParentGroup()) {
                for (NhDimension nhd : grp.getDimensions()) {
                    if (!nhd.getName().equals(dim.getName())) continue;
                    nhDim = nhd;
                    break;
                }
                if (nhDim != null) break;
            }
            if (nhDim == null) {
                NhCopy.throwerr("cannot find dimension \"%s\" for variable \"%s\"", dim.getName(), inVar.getName());
            }
            nhDimList.add(nhDim);
        }
        NhDimension[] nhDims = nhDimList.toArray(new NhDimension[0]);
        return nhDims;
    }

    static void copyAttribute(Attribute attr, String outName, Object outObj, boolean useLinear, int bugs) throws NhException {
        String atName;
        if (bugs >= 1) {
            NhCopy.prtf("copyAttribute: attr: %s", attr);
            NhCopy.prtf("  name: \"%s\"", attr.getName());
            NhCopy.prtf("  type: %s", attr.getDataType());
            NhCopy.prtf("  getLength: %s", attr.getLength());
            if (attr.getLength() == 1) {
                NhCopy.prtf("  len is 1: SCALAR", new Object[0]);
            }
            NhCopy.prtf("  isString: %s", attr.isString());
        }
        if ((atName = attr.getName()).equals("_lastModified") || atName.equals("_Netcdf4Dimid")) {
            NhCopy.prtf("Ignoring internal attribute for variable or group \"%s\".  Attribute: %s", outName, attr);
        } else {
            DataType tp = attr.getDataType();
            int nhType = 0;
            if (tp == DataType.BYTE) {
                nhType = attr.isUnsigned() ? 2 : 1;
            } else if (tp == DataType.SHORT) {
                nhType = 3;
            } else if (tp == DataType.INT) {
                nhType = 4;
            } else if (tp == DataType.LONG) {
                nhType = 5;
            } else if (tp == DataType.FLOAT) {
                nhType = 6;
            } else if (tp == DataType.DOUBLE) {
                nhType = 7;
            } else if (tp == DataType.CHAR) {
                nhType = 8;
            } else if (tp == DataType.STRING) {
                nhType = 9;
            } else {
                NhCopy.throwerr("unknown type for attribute \"%s\".  Type: %s", atName, tp);
            }
            Object attrValue = NhCopy.getAttrValue(attr, useLinear, bugs);
            if (outObj instanceof NhGroup) {
                NhGroup outGrp = (NhGroup)outObj;
                outGrp.addAttribute(atName, nhType, attrValue);
            } else if (outObj instanceof NhVariable) {
                NhVariable outVar = (NhVariable)outObj;
                outVar.addAttribute(atName, nhType, attrValue);
            } else {
                NhCopy.throwerr("invalid outObj: " + outObj, new Object[0]);
            }
        }
    }

    static void copyData(FieldSpec fspec, Variable inVar, NhGroup outGroup, boolean useLinear, boolean useArray, int bugs) throws NhException {
        if (bugs >= 1) {
            NhCopy.prtf("copyData: inVar: %s", inVar.getName());
        }
        NhVariable nhVar = null;
        for (NhVariable nhv : outGroup.getVariables()) {
            if (!nhv.getName().equals(inVar.getShortName())) continue;
            nhVar = nhv;
            break;
        }
        if (nhVar == null) {
            NhCopy.throwerr("nhVar not found", new Object[0]);
        }
        Array arr = null;
        try {
            arr = inVar.read();
        }
        catch (IOException exc) {
            exc.printStackTrace();
            NhCopy.throwerr("caught: " + exc, new Object[0]);
        }
        if (bugs >= 0) {
            int ii;
            if (fspec.numEle == 0) {
                NhCopy.getStatistics(inVar.getDataType(), arr, fspec);
            }
            String tmsg = "  variable: \"" + inVar.getName() + "\"";
            tmsg = tmsg + " (";
            for (ii = 0; ii < inVar.getRank(); ++ii) {
                if (ii > 0) {
                    tmsg = tmsg + ",";
                }
                tmsg = tmsg + inVar.getDimension(ii).getName();
            }
            tmsg = tmsg + ")";
            tmsg = tmsg + " (";
            for (ii = 0; ii < inVar.getRank(); ++ii) {
                if (ii > 0) {
                    tmsg = tmsg + ",";
                }
                tmsg = tmsg + inVar.getDimension(ii).getLength();
            }
            tmsg = tmsg + ")";
            tmsg = tmsg + "  size: " + inVar.getSize();
            DataType tp = inVar.getDataType();
            tmsg = tmsg + "  type: " + tp;
            tmsg = fspec.iscale == -999999 ? tmsg + "  iscale: none" : tmsg + "  iscale: " + fspec.iscale;
            if (tp == DataType.FLOAT || tp == DataType.DOUBLE || tp == DataType.BYTE || tp == DataType.INT || tp == DataType.LONG || tp == DataType.SHORT) {
                tmsg = tmsg + String.format("  min: %g  max: %g  avg: %g", fspec.minVal, fspec.maxVal, fspec.sumVal / (double)fspec.numEle);
            }
            NhCopy.prtf(tmsg, new Object[0]);
        }
        Object rawData = NhCopy.decodeArray(arr, useLinear, bugs);
        int[] strts = null;
        if (inVar.getRank() > 0) {
            strts = new int[inVar.getRank()];
        }
        if (fspec.iscale != -999999) {
            int ii;
            int vlen;
            Object[] vals;
            int[] ivals = null;
            if (!useLinear) {
                NhCopy.throwerr("useScaling requires useLinear", new Object[0]);
            }
            if (inVar.getDataType() == DataType.BYTE) {
                vals = (byte[])rawData;
                vlen = vals.length;
                ivals = new int[vlen];
                for (ii = 0; ii < vlen; ++ii) {
                    int vv = vals[ii];
                    if (fspec.origFillValueObj != null && vv == (Byte)fspec.origFillValueObj) {
                        ivals[ii] = fspec.packFillValue;
                        continue;
                    }
                    if (fspec.useDiff && ii > 0) {
                        vv = vals[ii] - vals[ii - 1];
                    }
                    ivals[ii] = (int)Math.round(((double)vv - fspec.offset) * fspec.mfact);
                }
            } else if (inVar.getDataType() == DataType.SHORT) {
                vals = (short[])rawData;
                vlen = vals.length;
                ivals = new int[vlen];
                for (ii = 0; ii < vlen; ++ii) {
                    int vv = vals[ii];
                    if (fspec.origFillValueObj != null && vv == (Short)fspec.origFillValueObj) {
                        ivals[ii] = fspec.packFillValue;
                        continue;
                    }
                    if (fspec.useDiff && ii > 0) {
                        vv = vals[ii] - vals[ii - 1];
                    }
                    ivals[ii] = (int)Math.round(((double)vv - fspec.offset) * fspec.mfact);
                }
            } else if (inVar.getDataType() == DataType.INT) {
                vals = (int[])rawData;
                vlen = vals.length;
                ivals = new int[vlen];
                for (ii = 0; ii < vlen; ++ii) {
                    int vv = vals[ii];
                    if (fspec.origFillValueObj != null && vv == (Integer)fspec.origFillValueObj) {
                        ivals[ii] = fspec.packFillValue;
                        continue;
                    }
                    if (fspec.useDiff && ii > 0) {
                        vv = vals[ii] - vals[ii - 1];
                    }
                    ivals[ii] = (int)Math.round(((double)vv - fspec.offset) * fspec.mfact);
                }
            } else if (inVar.getDataType() == DataType.FLOAT) {
                vals = (float[])rawData;
                vlen = vals.length;
                ivals = new int[vlen];
                for (ii = 0; ii < vlen; ++ii) {
                    int vv = vals[ii];
                    if (Float.isNaN(vv) || fspec.origFillValueObj != null && vv == ((Float)fspec.origFillValueObj).floatValue()) {
                        ivals[ii] = fspec.packFillValue;
                        continue;
                    }
                    if (fspec.useDiff && ii > 0) {
                        vv = vals[ii] - vals[ii - 1];
                    }
                    ivals[ii] = (int)Math.round(((double)vv - fspec.offset) * fspec.mfact);
                }
            } else if (inVar.getDataType() == DataType.DOUBLE) {
                vals = (double[])rawData;
                vlen = vals.length;
                ivals = new int[vlen];
                for (ii = 0; ii < vlen; ++ii) {
                    int vv = vals[ii];
                    if (Double.isNaN(vv) || fspec.origFillValueObj != null && vv == (Double)fspec.origFillValueObj) {
                        ivals[ii] = fspec.packFillValue;
                        continue;
                    }
                    if (fspec.useDiff && ii > 0) {
                        vv = vals[ii] - vals[ii - 1];
                    }
                    ivals[ii] = (int)Math.round((double)((vv - fspec.offset) * fspec.mfact));
                }
            } else {
                NhCopy.throwerr("unknown type for nhVar: " + nhVar, new Object[0]);
            }
            Object[] finalData = null;
            vlen = ivals.length;
            if (fspec.nhPackType == 1) {
                byte[] vals2 = new byte[vlen];
                for (int ii2 = 0; ii2 < vlen; ++ii2) {
                    vals2[ii2] = (byte)ivals[ii2];
                }
                finalData = vals2;
            } else if (fspec.nhPackType == 3) {
                short[] vals3 = new short[vlen];
                for (int ii3 = 0; ii3 < vlen; ++ii3) {
                    vals3[ii3] = (short)ivals[ii3];
                }
                finalData = vals3;
            } else if (fspec.nhPackType == 4) {
                int[] vals4 = new int[vlen];
                for (int ii4 = 0; ii4 < vlen; ++ii4) {
                    vals4[ii4] = ivals[ii4];
                }
                finalData = vals4;
            } else if (fspec.nhPackType == 6) {
                int[] vals5 = new int[vlen];
                for (int ii5 = 0; ii5 < vlen; ++ii5) {
                    vals5[ii5] = ivals[ii5];
                }
                finalData = vals5;
            } else {
                NhCopy.throwerr("unknown nhPackType", new Object[0]);
            }
            nhVar.writeData(strts, finalData, useLinear);
        } else if (fspec.chunkLens != null) {
            NhCopy.copyDataChunked(fspec, rawData, inVar, nhVar, outGroup, bugs);
        } else if (useArray) {
            nhVar.writeData(strts, arr, useLinear);
        } else {
            nhVar.writeData(strts, rawData, useLinear);
        }
    }

    static void copyDataChunked(FieldSpec fspec, Object rawData, Variable inVar, NhVariable nhVar, NhGroup outGroup, int bugs) throws NhException {
        int[] strts = null;
        if (inVar.getRank() > 0) {
            strts = new int[inVar.getRank()];
        }
        NhDimension[] nhDims = NhCopy.getNhDims(inVar, outGroup);
        int[] dimLens = new int[nhDims.length];
        for (int ii = 0; ii < dimLens.length; ++ii) {
            dimLens[ii] = nhDims[ii].getLength();
        }
        int[] clens = fspec.chunkLens;
        if (dimLens.length == 1) {
            if (!(rawData instanceof float[])) {
                NhCopy.throwerr("wrong type for rawData: " + rawData.getClass(), new Object[0]);
            }
            float[] fvals = (float[])rawData;
            float[] chunkVals = new float[clens[0]];
            strts[0] = 0;
            while (strts[0] < dimLens[0]) {
                int lima = Math.min(clens[0], dimLens[0] - strts[0]);
                for (int ia = 0; ia < lima; ++ia) {
                    chunkVals[ia] = fvals[strts[0] + ia];
                }
                nhVar.writeData(strts, chunkVals, false);
                strts[0] = strts[0] + clens[0];
            }
        } else if (dimLens.length == 2) {
            if (!(rawData instanceof float[][])) {
                NhCopy.throwerr("wrong type for rawData: " + rawData.getClass(), new Object[0]);
            }
            float[][] fvals = (float[][])rawData;
            float[][] chunkVals = new float[clens[0]][clens[1]];
            strts[0] = 0;
            while (strts[0] < dimLens[0]) {
                strts[1] = 0;
                while (strts[1] < dimLens[1]) {
                    int lima = Math.min(clens[0], dimLens[0] - strts[0]);
                    int limb = Math.min(clens[1], dimLens[1] - strts[1]);
                    for (int ia = 0; ia < lima; ++ia) {
                        for (int ib = 0; ib < limb; ++ib) {
                            chunkVals[ia][ib] = fvals[strts[0] + ia][strts[1] + ib];
                        }
                    }
                    nhVar.writeData(strts, chunkVals, false);
                    strts[1] = strts[1] + clens[1];
                }
                strts[0] = strts[0] + clens[0];
            }
        } else if (dimLens.length == 3) {
            if (!(rawData instanceof float[][][])) {
                NhCopy.throwerr("wrong type for rawData: " + rawData.getClass(), new Object[0]);
            }
            float[][][] fvals = (float[][][])rawData;
            float[][][] chunkVals = new float[clens[0]][clens[1]][clens[2]];
            strts[0] = 0;
            while (strts[0] < dimLens[0]) {
                strts[1] = 0;
                while (strts[1] < dimLens[1]) {
                    strts[2] = 0;
                    while (strts[2] < dimLens[2]) {
                        int lima = Math.min(clens[0], dimLens[0] - strts[0]);
                        int limb = Math.min(clens[1], dimLens[1] - strts[1]);
                        int limc = Math.min(clens[2], dimLens[2] - strts[2]);
                        for (int ia = 0; ia < lima; ++ia) {
                            for (int ib = 0; ib < limb; ++ib) {
                                for (int ic = 0; ic < limc; ++ic) {
                                    chunkVals[ia][ib][ic] = fvals[strts[0] + ia][strts[1] + ib][strts[2] + ic];
                                }
                            }
                        }
                        nhVar.writeData(strts, chunkVals, false);
                        strts[2] = strts[2] + clens[2];
                    }
                    strts[1] = strts[1] + clens[1];
                }
                strts[0] = strts[0] + clens[0];
            }
        } else if (dimLens.length == 4) {
            if (!(rawData instanceof float[][][][])) {
                NhCopy.throwerr("wrong type for rawData: " + rawData.getClass(), new Object[0]);
            }
            float[][][][] fvals = (float[][][][])rawData;
            float[][][][] chunkVals = new float[clens[0]][clens[1]][clens[2]][clens[3]];
            strts[0] = 0;
            while (strts[0] < dimLens[0]) {
                strts[1] = 0;
                while (strts[1] < dimLens[1]) {
                    strts[2] = 0;
                    while (strts[2] < dimLens[2]) {
                        strts[3] = 0;
                        while (strts[3] < dimLens[3]) {
                            int lima = Math.min(clens[0], dimLens[0] - strts[0]);
                            int limb = Math.min(clens[1], dimLens[1] - strts[1]);
                            int limc = Math.min(clens[2], dimLens[2] - strts[2]);
                            int limd = Math.min(clens[3], dimLens[3] - strts[3]);
                            for (int ia = 0; ia < lima; ++ia) {
                                for (int ib = 0; ib < limb; ++ib) {
                                    for (int ic = 0; ic < limc; ++ic) {
                                        for (int id = 0; id < limd; ++id) {
                                            chunkVals[ia][ib][ic][id] = fvals[strts[0] + ia][strts[1] + ib][strts[2] + ic][strts[3] + id];
                                        }
                                    }
                                }
                            }
                            nhVar.writeData(strts, chunkVals, false);
                            strts[3] = strts[3] + clens[3];
                        }
                        strts[2] = strts[2] + clens[2];
                    }
                    strts[1] = strts[1] + clens[1];
                }
                strts[0] = strts[0] + clens[0];
            }
        } else if (dimLens.length == 5) {
            if (!(rawData instanceof float[][][][][])) {
                NhCopy.throwerr("wrong type for rawData: " + rawData.getClass(), new Object[0]);
            }
            float[][][][][] fvals = (float[][][][][])rawData;
            float[][][][][] chunkVals = new float[clens[0]][clens[1]][clens[2]][clens[3]][clens[4]];
            strts[0] = 0;
            while (strts[0] < dimLens[0]) {
                strts[1] = 0;
                while (strts[1] < dimLens[1]) {
                    strts[2] = 0;
                    while (strts[2] < dimLens[2]) {
                        strts[3] = 0;
                        while (strts[3] < dimLens[3]) {
                            strts[4] = 0;
                            while (strts[4] < dimLens[4]) {
                                int lima = Math.min(clens[0], dimLens[0] - strts[0]);
                                int limb = Math.min(clens[1], dimLens[1] - strts[1]);
                                int limc = Math.min(clens[2], dimLens[2] - strts[2]);
                                int limd = Math.min(clens[3], dimLens[3] - strts[3]);
                                int lime = Math.min(clens[4], dimLens[4] - strts[4]);
                                for (int ia = 0; ia < lima; ++ia) {
                                    for (int ib = 0; ib < limb; ++ib) {
                                        for (int ic = 0; ic < limc; ++ic) {
                                            for (int id = 0; id < limd; ++id) {
                                                for (int ie = 0; ie < lime; ++ie) {
                                                    chunkVals[ia][ib][ic][id][ie] = fvals[strts[0] + ia][strts[1] + ib][strts[2] + ic][strts[3] + id][strts[4] + ie];
                                                }
                                            }
                                        }
                                    }
                                }
                                nhVar.writeData(strts, chunkVals, false);
                                strts[4] = strts[4] + clens[4];
                            }
                            strts[3] = strts[3] + clens[3];
                        }
                        strts[2] = strts[2] + clens[2];
                    }
                    strts[1] = strts[1] + clens[1];
                }
                strts[0] = strts[0] + clens[0];
            }
        } else {
            NhCopy.throwerr("higher dims not supported yet", new Object[0]);
        }
    }

    static void getStatistics(DataType tp, Array arr, FieldSpec fspec) {
        fspec.numEle = 0;
        fspec.sumVal = 0.0;
        fspec.minVal = Double.MAX_VALUE;
        fspec.maxVal = Double.MIN_VALUE;
        fspec.maxRoundDelta = 0.0;
        if (tp == DataType.FLOAT || tp == DataType.DOUBLE || tp == DataType.BYTE || tp == DataType.INT || tp == DataType.LONG || tp == DataType.SHORT) {
            int ii = 0;
            while ((long)ii < arr.getSize()) {
                ++fspec.numEle;
                double vv = arr.getDouble(ii);
                if (vv < fspec.minVal) {
                    fspec.minVal = vv;
                }
                if (vv > fspec.maxVal) {
                    fspec.maxVal = vv;
                }
                fspec.sumVal += vv;
                double roundDelta = Math.abs(vv - (double)Math.round(vv));
                if (roundDelta > fspec.maxRoundDelta) {
                    fspec.maxRoundDelta = roundDelta;
                }
                ++ii;
            }
        }
    }

    static Object getAttrValue(Attribute attr, boolean useLinear, int bugs) throws NhException {
        if (bugs >= 1) {
            NhCopy.prtf("getAttrValue: attr: %s", attr);
        }
        String[] attrValue = null;
        DataType atType = attr.getDataType();
        if (attr.isString()) {
            int alen = attr.getLength();
            if (alen == 1) {
                attrValue = attr.getStringValue();
            } else {
                String[] stgs = new String[alen];
                for (int ii = 0; ii < alen; ++ii) {
                    stgs[ii] = attr.getStringValue(ii);
                }
                attrValue = stgs;
            }
        } else {
            Array arr = attr.getValues();
            attrValue = NhCopy.decodeArray(arr, useLinear, bugs);
        }
        if (bugs >= 1) {
            NhCopy.prtf("  getAttrValue: return attrValue: %s  cls: %s", attrValue, attrValue.getClass());
        }
        return attrValue;
    }

    static Object decodeArray(Array arr, boolean useLinear, int bugs) throws NhException {
        if (bugs >= 1) {
            int rank = arr.getRank();
            int[] shape = arr.getShape();
            NhCopy.prtf("  decodeArray: getElementType: %s", arr.getElementType());
            NhCopy.prtf("    rank: %d", rank);
            NhCopy.prtf("    shape: %s", NhCopy.formatInts(shape));
            if (rank == 1) {
                for (int ii = 0; ii < shape[0]; ++ii) {
                    Object obj = arr.getObject(ii);
                    NhCopy.prtf("    ele %d: %s  class: %s", ii, obj, obj.getClass().getName());
                }
            } else if (rank == 2) {
                Index index = arr.getIndex();
                for (int ii = 0; ii < shape[0]; ++ii) {
                    for (int jj = 0; jj < shape[1]; ++jj) {
                        index.set(ii, jj);
                        Object obj = arr.getObject(index);
                        NhCopy.prtf("    ele %d %d: %s  class: %s", ii, jj, obj, obj.getClass().getName());
                    }
                }
            }
        }
        Class eleType = arr.getElementType();
        Object resObj = null;
        if (eleType == "".getClass()) {
            resObj = NhCopy.decodeStringArray(arr, useLinear, bugs);
        } else if (arr.getRank() == 0 && arr.getElementType().isPrimitive()) {
            Class cls = arr.getElementType();
            if (cls == Byte.TYPE) {
                resObj = new Byte(arr.getByte(0));
            } else if (cls == Short.TYPE) {
                resObj = new Short(arr.getShort(0));
            } else if (cls == Integer.TYPE) {
                resObj = new Integer(arr.getInt(0));
            } else if (cls == Long.TYPE) {
                resObj = new Long(arr.getLong(0));
            } else if (cls == Float.TYPE) {
                resObj = new Float(arr.getFloat(0));
            } else if (cls == Double.TYPE) {
                resObj = new Double(arr.getDouble(0));
            } else if (cls == Character.TYPE) {
                resObj = new Character(arr.getChar(0));
            } else if (cls == "".getClass()) {
                resObj = arr.getObject(0);
            } else {
                NhCopy.throwerr("unknown cls: " + cls, new Object[0]);
            }
        } else {
            resObj = useLinear ? arr.copyTo1DJavaArray() : arr.copyToNDJavaArray();
        }
        return resObj;
    }

    static Object decodeStringArray(Array arr, boolean useLinear, int bugs) throws NhException {
        Class eleType = arr.getElementType();
        if (eleType != "".getClass()) {
            NhCopy.throwerr("bad type for decodeStringArray", new Object[0]);
        }
        String[] resObj = null;
        int rank = arr.getRank();
        int[] shape = arr.getShape();
        Index index = arr.getIndex();
        if (rank == 0) {
            resObj = arr.getObject(0);
        } else if (useLinear) {
            resObj = arr.copyTo1DJavaArray();
        } else if (rank == 1) {
            String[] stgs = new String[shape[0]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                index.set(ia);
                stgs[ia] = (String)arr.getObject(index);
            }
            resObj = stgs;
        } else if (rank == 2) {
            String[][] stgs = new String[shape[0]][shape[1]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                for (int ib = 0; ib < shape[1]; ++ib) {
                    index.set(ia, ib);
                    stgs[ia][ib] = (String)arr.getObject(index);
                }
            }
            resObj = stgs;
        } else if (rank == 3) {
            String[][][] stgs = new String[shape[0]][shape[1]][shape[2]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                for (int ib = 0; ib < shape[1]; ++ib) {
                    for (int ic = 0; ic < shape[2]; ++ic) {
                        index.set(ia, ib, ic);
                        stgs[ia][ib][ic] = (String)arr.getObject(index);
                    }
                }
            }
            resObj = stgs;
        } else if (rank == 4) {
            String[][][][] stgs = new String[shape[0]][shape[1]][shape[2]][shape[3]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                for (int ib = 0; ib < shape[1]; ++ib) {
                    for (int ic = 0; ic < shape[2]; ++ic) {
                        for (int id = 0; id < shape[3]; ++id) {
                            index.set(ia, ib, ic, id);
                            stgs[ia][ib][ic][id] = (String)arr.getObject(index);
                        }
                    }
                }
            }
            resObj = stgs;
        } else if (rank == 5) {
            String[][][][][] stgs = new String[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                for (int ib = 0; ib < shape[1]; ++ib) {
                    for (int ic = 0; ic < shape[2]; ++ic) {
                        for (int id = 0; id < shape[3]; ++id) {
                            for (int ie = 0; ie < shape[4]; ++ie) {
                                index.set(ia, ib, ic, id, ie);
                                stgs[ia][ib][ic][id][ie] = (String)arr.getObject(index);
                            }
                        }
                    }
                }
            }
            resObj = stgs;
        } else if (rank == 6) {
            String[][][][][][] stgs = new String[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                for (int ib = 0; ib < shape[1]; ++ib) {
                    for (int ic = 0; ic < shape[2]; ++ic) {
                        for (int id = 0; id < shape[3]; ++id) {
                            for (int ie = 0; ie < shape[4]; ++ie) {
                                for (int ig = 0; ig < shape[5]; ++ig) {
                                    index.set(ia, ib, ic, id, ie, ig);
                                    stgs[ia][ib][ic][id][ie][ig] = (String)arr.getObject(index);
                                }
                            }
                        }
                    }
                }
            }
            resObj = stgs;
        } else if (rank == 7) {
            String[][][][][][][] stgs = new String[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]];
            for (int ia = 0; ia < shape[0]; ++ia) {
                for (int ib = 0; ib < shape[1]; ++ib) {
                    for (int ic = 0; ic < shape[2]; ++ic) {
                        for (int id = 0; id < shape[3]; ++id) {
                            for (int ie = 0; ie < shape[4]; ++ie) {
                                for (int ig = 0; ig < shape[5]; ++ig) {
                                    for (int ih = 0; ih < shape[6]; ++ih) {
                                        index.set(ia, ib, ic, id, ie, ig, ih);
                                        stgs[ia][ib][ic][id][ie][ig][ih] = (String)arr.getObject(index);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            resObj = stgs;
        } else {
            NhCopy.throwerr("unknown rank", new Object[0]);
        }
        return resObj;
    }

    static int parseInt(String msg, String stg) throws NhException {
        int ival = 0;
        try {
            ival = Integer.parseInt(stg);
        }
        catch (NumberFormatException exc) {
            NhCopy.throwerr("bad format for parm %s.  value: \"%s\"", msg, stg);
        }
        return ival;
    }

    static boolean parseBoolean(String msg, String stg) throws NhException {
        boolean bval = false;
        if (stg.equals("false") || stg.equals("no")) {
            bval = false;
        } else if (stg.equals("true") || stg.equals("yes")) {
            bval = true;
        } else {
            NhCopy.throwerr("bad format for parm %s.  value: \"%s\"", msg, stg);
        }
        return bval;
    }

    static String formatInts(int[] ivals) {
        String res = "";
        for (int ival : ivals) {
            res = res + " " + ival;
        }
        return res;
    }

    static void throwerr(String msg, Object ... args) throws NhException {
        throw new NhException(String.format(msg, args));
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }
}

