/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfModInt;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.hdf.MsgBase;
import edu.ucar.ral.nujan.hdf.MsgDataSpace;
import edu.ucar.ral.nujan.hdf.MsgDataType;
import java.util.Arrays;

class MsgAttribute
extends MsgBase {
    String attrName;
    int attrType;
    int stgFieldLen;
    Object attrValue;
    boolean isVlen;
    MsgDataType msgDataType;
    MsgDataSpace msgDataSpace;
    int dataDtype;
    int totNumEle;
    int elementLen;
    int[] dataVarDims;
    int[] dsubTypes = null;

    MsgAttribute(String attrName, int attrType, int stgFieldLenParm, Object attrValue, boolean isVlen, HdfGroup hdfGroup, HdfFileWriter hdfFile) throws HdfException {
        super(12, hdfGroup, hdfFile);
        this.attrName = attrName;
        this.attrType = attrType;
        this.stgFieldLen = stgFieldLenParm;
        this.attrValue = attrValue;
        this.isVlen = isVlen;
        int[] dataInfo = HdfUtil.getDimLen(attrValue, isVlen);
        this.dataDtype = dataInfo[0];
        this.totNumEle = dataInfo[1];
        this.elementLen = dataInfo[2];
        this.dataVarDims = Arrays.copyOfRange(dataInfo, 3, dataInfo.length);
        if (hdfFile.bugs >= 1) {
            MsgAttribute.prtf("MsgAttribute: actual data:\n  attrValue object: \"%s\"\n  attrValue dtype: " + HdfGroup.dtypeNames[this.dataDtype] + "\n" + "  attrValue totNumEle: " + this.totNumEle + "\n" + "  attrValue elementLen: " + this.elementLen + "\n" + "  attrValue rank: " + this.dataVarDims.length + "\n" + "  attrValue type and dims: " + HdfUtil.formatDtypeDim(this.dataDtype, this.dataVarDims), attrValue);
            if (attrValue != null) {
                MsgAttribute.prtf("  attrValue class: " + attrValue.getClass(), new Object[0]);
            }
        }
        if (this.totNumEle * this.elementLen > 64535) {
            MsgAttribute.throwerr("Attribute total length too big.  totNumEle: %d  elementLen: %d  attr path: %s", this.totNumEle, this.elementLen, this.getPath());
        }
        if (attrValue != null) {
            HdfUtil.checkTypeMatch(this.getPath(), attrType, this.dataDtype, false, this.dataVarDims, new int[this.dataVarDims.length], this.dataVarDims, this.dataVarDims);
        }
        String[] memberNames = null;
        if (isVlen) {
            if (attrType == 13) {
                MsgAttribute.throwerr("Attribute cannot be both isVlen and DTYPE_COMPOUND.  attribute named \"%s\"", attrName);
            }
            if (this.dataVarDims.length != 2) {
                MsgAttribute.throwerr("cannot have VLEN attribute with num dims != 2", new Object[0]);
            }
            this.dsubTypes = new int[]{attrType};
            attrType = 12;
        } else if (attrType == 13) {
            this.dsubTypes = new int[]{11, 4};
            memberNames = new String[]{"dataset", "dimension"};
        }
        if (attrType == 9 && this.stgFieldLen == 0) {
            this.stgFieldLen = HdfUtil.getMaxStgLen(attrValue);
            if (this.stgFieldLen == 0) {
                this.stgFieldLen = 1;
            }
        }
        if (hdfFile.bugs >= 2) {
            MsgAttribute.prtf("MsgAttribute: " + this, new Object[0]);
        }
        if (isVlen) {
            if (this.dataVarDims.length != 2) {
                MsgAttribute.throwerr("wrong num dimensions for vlen", new Object[0]);
            }
            this.dataVarDims = Arrays.copyOfRange(this.dataVarDims, 0, 1);
        }
        this.msgDataType = new MsgDataType(attrType, this.dsubTypes, memberNames, this.stgFieldLen, hdfGroup, hdfFile);
        int[] vdims = this.dataVarDims;
        if (this.totNumEle == 0) {
            vdims = null;
        }
        this.msgDataSpace = new MsgDataSpace(this.dataVarDims.length, this.totNumEle, vdims, hdfGroup, hdfFile);
    }

    @Override
    public String toString() {
        String res = "  attr path: \"" + this.getPath() + "\"\n" + "  type: " + HdfUtil.formatDtypeDim(this.attrType, this.dataVarDims) + "\n" + "  stgFieldLen: " + this.stgFieldLen + "\n" + "  attrValue: dataDtype: " + HdfGroup.dtypeNames[this.dataDtype] + "  class: ";
        res = this.attrValue == null ? res + "(null)\n" : res + this.attrValue.getClass().getName() + "\n";
        if (this.dsubTypes != null) {
            res = res + "  dsubTypes:";
            for (int ii = 0; ii < this.dsubTypes.length; ++ii) {
                res = res + " " + HdfGroup.dtypeNames[this.dsubTypes[ii]];
            }
            res = res + "\n";
        }
        if (this.hdfFile.bugs >= 10) {
            res = res + "  " + super.toString() + "\n";
        }
        return res;
    }

    String getPath() {
        String nm = this.hdfGroup.getPath();
        nm = nm + "/" + this.attrName;
        return nm;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        byte[] nameBytes = HdfUtil.encodeString(this.attrName, false, this.hdfGroup);
        fmtBuf.putBufByte("MsgAttribute: attrVersion", 3);
        fmtBuf.putBufByte("MsgAttribute: flag", 0);
        fmtBuf.putBufShort("MsgAttribute: nameSize", nameBytes.length + 1);
        fmtBuf.putBufShort("MsgAttribute: dataTypeSize", this.msgDataType.hdrMsgSize);
        fmtBuf.putBufShort("MsgAttribute: dataSpaceSize", this.msgDataSpace.hdrMsgSize);
        fmtBuf.putBufByte("MsgAttribute: encoding", 0);
        fmtBuf.putBufBytes("MsgAttribute: attr name", nameBytes);
        fmtBuf.putBufByte("MsgAttribute: attr name null term", 0);
        this.msgDataType.formatNakedMsg(formatPass, fmtBuf);
        this.msgDataSpace.formatNakedMsg(formatPass, fmtBuf);
        int[] startIxs = new int[this.dataVarDims.length];
        if (this.attrValue != null) {
            if (this.isVlen) {
                int[] heapIxs = this.hdfFile.mainGlobalHeap.putHeapVlenObject(this.hdfGroup, this.msgDataType.dtype, this.msgDataType.subMsgs[0].dtype, this.msgDataType.subMsgs[0].elementLen, this.dataVarDims, this.attrValue);
                if (this.hdfFile.bugs >= 2) {
                    String tmsg = "MsgAttribute vlen: attrName: \"" + this.attrName + "\"\n" + "  heapIxs len: " + heapIxs.length + "\n" + "  heapIxs:";
                    for (int ii = 0; ii < heapIxs.length; ++ii) {
                        tmsg = tmsg + " " + heapIxs[ii];
                    }
                    MsgAttribute.prtf(tmsg, new Object[0]);
                }
                this.hdfGroup.formatVlenRawData(heapIxs, this.attrValue, fmtBuf);
            } else if (this.msgDataType.dtype == 10) {
                int compressionLevel = 0;
                HBuffer refBuf = new HBuffer(null, compressionLevel, this.hdfFile);
                int[] curIxs = new int[this.dataVarDims.length];
                if (this.hdfFile.bugs >= 2) {
                    MsgAttribute.prtf("MsgAttribute: call formatRawData for string data", new Object[0]);
                }
                this.hdfGroup.formatRawData("attrName: " + this.attrName, 0, curIxs, false, this.attrType, this.stgFieldLen, this.dataVarDims, this.dataVarDims, this.dataVarDims, this.elementLen, startIxs, this.attrValue, new HdfModInt(0), this.hdfFile.mainGlobalHeap.blkPosition, this.hdfFile.mainGlobalHeap, refBuf);
                fmtBuf.putBufBuf("STRING_VAR refs", refBuf);
            } else {
                int[] curIxs = new int[this.dataVarDims.length];
                if (this.hdfFile.bugs >= 2) {
                    MsgAttribute.prtf("MsgAttribute: call formatRawData for numeric data", new Object[0]);
                }
                this.hdfGroup.formatRawData("attrName: " + this.attrName, 0, curIxs, false, this.attrType, this.stgFieldLen, this.dataVarDims, this.dataVarDims, this.dataVarDims, this.elementLen, startIxs, this.attrValue, new HdfModInt(0), 0L, null, fmtBuf);
                if (this.totNumEle == 0) {
                    fmtBuf.putBufLong("MsgAttribute: empty attr kluge", 0L);
                }
            }
        }
    }
}

